/*
 * Decompiled with CFR 0.152.
 */
package org.cubexmc.metro.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;

public class Line {
    private String id;
    private String name;
    private final List<String> orderedStopIds;
    private String color;
    private String terminusName;
    private Double maxSpeed;
    private UUID owner;
    private final Set<UUID> admins;

    public Line(String id, String name) {
        this.id = id;
        this.name = name;
        this.orderedStopIds = new ArrayList<String>();
        this.color = "&f";
        this.terminusName = "";
        this.maxSpeed = null;
        this.admins = new HashSet<UUID>();
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getColor() {
        return this.color;
    }

    public void setColor(String color) {
        this.color = color;
    }

    public String getTerminusName() {
        return this.terminusName;
    }

    public void setTerminusName(String terminusName) {
        this.terminusName = terminusName;
    }

    public Double getMaxSpeed() {
        if (this.maxSpeed == null) {
            return -1.0;
        }
        return this.maxSpeed;
    }

    public void setMaxSpeed(Double maxSpeed) {
        this.maxSpeed = maxSpeed;
    }

    public List<String> getOrderedStopIds() {
        return new ArrayList<String>(this.orderedStopIds);
    }

    public boolean isCircular() {
        if (this.orderedStopIds.isEmpty() || this.orderedStopIds.size() < 2) {
            return false;
        }
        return this.orderedStopIds.get(0).equals(this.orderedStopIds.get(this.orderedStopIds.size() - 1));
    }

    public void addStop(String stopId, int index) {
        boolean isMakingCircular;
        boolean bl = isMakingCircular = !this.isCircular() && !this.orderedStopIds.isEmpty() && this.orderedStopIds.get(0).equals(stopId) && (index == -1 || index == this.orderedStopIds.size());
        if (this.orderedStopIds.contains(stopId) && !isMakingCircular) {
            this.orderedStopIds.remove(stopId);
        }
        if (this.isCircular() && index == -1) {
            this.orderedStopIds.add(this.orderedStopIds.size() - 1, stopId);
        } else if (index >= 0 && index < this.orderedStopIds.size()) {
            this.orderedStopIds.add(index, stopId);
        } else {
            this.orderedStopIds.add(stopId);
        }
    }

    public void delStop(String stopId) {
        this.orderedStopIds.remove(stopId);
    }

    public boolean containsStop(String stopId) {
        return this.orderedStopIds.contains(stopId);
    }

    public String getNextStopId(String currentStopId) {
        int index = this.orderedStopIds.indexOf(currentStopId);
        if (index == -1) {
            return null;
        }
        if (index == this.orderedStopIds.size() - 1) {
            if (this.isCircular()) {
                if (this.orderedStopIds.size() > 1) {
                    return this.orderedStopIds.get(1);
                }
                return this.orderedStopIds.get(0);
            }
            return null;
        }
        return this.orderedStopIds.get(index + 1);
    }

    public UUID getOwner() {
        return this.owner;
    }

    public void setOwner(UUID owner) {
        this.owner = owner;
        if (owner != null) {
            this.admins.add(owner);
        }
        this.admins.remove(null);
    }

    public Set<UUID> getAdmins() {
        return new HashSet<UUID>(this.admins);
    }

    public void setAdmins(Collection<UUID> adminIds) {
        this.admins.clear();
        if (adminIds != null) {
            this.admins.addAll(adminIds);
        }
        if (this.owner != null) {
            this.admins.add(this.owner);
        }
        this.admins.remove(null);
    }

    public boolean addAdmin(UUID adminId) {
        if (adminId == null) {
            return false;
        }
        this.admins.remove(null);
        return this.admins.add(adminId);
    }

    public boolean removeAdmin(UUID adminId) {
        if (adminId == null) {
            return false;
        }
        if (this.owner != null && this.owner.equals(adminId)) {
            return false;
        }
        boolean removed = this.admins.remove(adminId);
        this.admins.remove(null);
        return removed;
    }

    public String getPreviousStopId(String currentStopId) {
        int index = this.orderedStopIds.indexOf(currentStopId);
        if (index <= 0) {
            if (this.isCircular()) {
                if (this.orderedStopIds.size() > 2) {
                    return this.orderedStopIds.get(this.orderedStopIds.size() - 2);
                }
                if (this.orderedStopIds.size() == 2) {
                    return this.orderedStopIds.get(0);
                }
            }
            return null;
        }
        return this.orderedStopIds.get(index - 1);
    }
}

