/*
 * Decompiled with CFR 0.152.
 */
package org.cubexmc.metro.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.configuration.ConfigurationSection;

public class Stop {
    private String id;
    private String name;
    private Location corner1;
    private Location corner2;
    private Location stopPointLocation;
    private float launchYaw;
    private List<String> transferableLines;
    private UUID owner;
    private final Set<UUID> admins = new HashSet<UUID>();
    private final Set<String> linkedLineIds = new HashSet<String>();
    private Map<String, Map<String, String>> customTitles;

    public Stop(String id, String name) {
        this.id = id;
        this.name = name;
        this.transferableLines = new ArrayList<String>();
        this.customTitles = new HashMap<String, Map<String, String>>();
    }

    public Stop(String id, ConfigurationSection section) {
        List linkedLines;
        List adminStrings;
        String ownerString;
        String locString;
        String corner2String;
        this.id = id;
        this.name = section.getString("display_name", "");
        String corner1String = section.getString("corner1_location");
        if (corner1String != null) {
            this.corner1 = this.locationFromString(corner1String);
        }
        if ((corner2String = section.getString("corner2_location")) != null) {
            this.corner2 = this.locationFromString(corner2String);
        }
        if ((locString = section.getString("stoppoint_location")) != null) {
            this.stopPointLocation = this.locationFromString(locString);
        }
        this.launchYaw = (float)section.getDouble("launch_yaw", 0.0);
        this.transferableLines = section.getStringList("transferable_lines");
        if (this.transferableLines == null) {
            this.transferableLines = new ArrayList<String>();
        }
        this.customTitles = new HashMap<String, Map<String, String>>();
        ConfigurationSection customTitlesSection = section.getConfigurationSection("custom_titles");
        if (customTitlesSection != null) {
            for (String titleType : customTitlesSection.getKeys(false)) {
                ConfigurationSection titleTypeSection = customTitlesSection.getConfigurationSection(titleType);
                if (titleTypeSection == null) continue;
                HashMap<String, String> titleConfig = new HashMap<String, String>();
                for (String key : titleTypeSection.getKeys(false)) {
                    titleConfig.put(key, titleTypeSection.getString(key));
                }
                this.customTitles.put(titleType, titleConfig);
            }
        }
        if ((ownerString = section.getString("owner")) != null && !ownerString.isEmpty()) {
            try {
                this.owner = UUID.fromString(ownerString);
                this.admins.add(this.owner);
            }
            catch (IllegalArgumentException ignored) {
                this.owner = null;
            }
        }
        if ((adminStrings = section.getStringList("admins")) != null) {
            for (String entry : adminStrings) {
                try {
                    UUID adminId = UUID.fromString(entry);
                    this.admins.add(adminId);
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            }
        }
        if ((linkedLines = section.getStringList("linked_lines")) != null) {
            this.linkedLineIds.addAll(linkedLines);
        }
    }

    public void saveToConfig(ConfigurationSection section) {
        section.set("display_name", (Object)this.name);
        if (this.corner1 != null) {
            section.set("corner1_location", (Object)this.locationToString(this.corner1));
        }
        if (this.corner2 != null) {
            section.set("corner2_location", (Object)this.locationToString(this.corner2));
        }
        if (this.stopPointLocation != null) {
            section.set("stoppoint_location", (Object)this.locationToString(this.stopPointLocation));
        }
        section.set("launch_yaw", (Object)Float.valueOf(this.launchYaw));
        section.set("transferable_lines", this.transferableLines);
        section.set("owner", this.owner != null ? this.owner.toString() : null);
        if (!this.admins.isEmpty()) {
            ArrayList<String> adminStrings = new ArrayList<String>();
            for (UUID uUID : this.admins) {
                if (this.owner != null && this.owner.equals(uUID)) continue;
                adminStrings.add(uUID.toString());
            }
            section.set("admins", adminStrings);
        } else {
            section.set("admins", null);
        }
        if (!this.linkedLineIds.isEmpty()) {
            section.set("linked_lines", new ArrayList<String>(this.linkedLineIds));
        } else {
            section.set("linked_lines", null);
        }
        if (!this.customTitles.isEmpty()) {
            ConfigurationSection customTitlesSection = section.createSection("custom_titles");
            for (Map.Entry entry : this.customTitles.entrySet()) {
                String titleType = (String)entry.getKey();
                Map titleConfig = (Map)entry.getValue();
                if (titleConfig.isEmpty()) continue;
                ConfigurationSection titleTypeSection = customTitlesSection.createSection(titleType);
                for (Map.Entry configEntry : titleConfig.entrySet()) {
                    titleTypeSection.set((String)configEntry.getKey(), configEntry.getValue());
                }
            }
        }
    }

    public Map<String, String> getCustomTitle(String titleType) {
        return this.customTitles.get(titleType);
    }

    public void setCustomTitle(String titleType, Map<String, String> config) {
        this.customTitles.put(titleType, config);
    }

    public boolean removeCustomTitle(String titleType) {
        return this.customTitles.remove(titleType) != null;
    }

    private String locationToString(Location location) {
        return String.format("%s,%d,%d,%d", location.getWorld().getName(), location.getBlockX(), location.getBlockY(), location.getBlockZ());
    }

    private Location locationFromString(String locString) {
        String[] parts = locString.split(",");
        if (parts.length != 4) {
            return null;
        }
        try {
            return new Location(Bukkit.getWorld((String)parts[0]), (double)Integer.parseInt(parts[1]), (double)Integer.parseInt(parts[2]), (double)Integer.parseInt(parts[3]));
        }
        catch (Exception e) {
            return null;
        }
    }

    public boolean isInStop(Location location) {
        if (this.corner1 == null || this.corner2 == null || location == null || location.getWorld() == null || !location.getWorld().equals((Object)this.corner1.getWorld())) {
            return false;
        }
        int minX = Math.min(this.corner1.getBlockX(), this.corner2.getBlockX());
        int maxX = Math.max(this.corner1.getBlockX(), this.corner2.getBlockX());
        int minY = Math.min(this.corner1.getBlockY(), this.corner2.getBlockY());
        int maxY = Math.max(this.corner1.getBlockY(), this.corner2.getBlockY());
        int minZ = Math.min(this.corner1.getBlockZ(), this.corner2.getBlockZ());
        int maxZ = Math.max(this.corner1.getBlockZ(), this.corner2.getBlockZ());
        int x = location.getBlockX();
        int y = location.getBlockY();
        int z = location.getBlockZ();
        return x >= minX && x <= maxX && y >= minY && y <= maxY && z >= minZ && z <= maxZ;
    }

    public List<String> getTransferableLines() {
        return new ArrayList<String>(this.transferableLines);
    }

    public boolean addTransferableLine(String lineId) {
        if (!this.transferableLines.contains(lineId)) {
            return this.transferableLines.add(lineId);
        }
        return false;
    }

    public boolean removeTransferableLine(String lineId) {
        return this.transferableLines.remove(lineId);
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Location getCorner1() {
        return this.corner1;
    }

    public void setCorner1(Location corner1) {
        this.corner1 = corner1;
    }

    public Location getCorner2() {
        return this.corner2;
    }

    public void setCorner2(Location corner2) {
        this.corner2 = corner2;
    }

    public Location getStopPointLocation() {
        return this.stopPointLocation;
    }

    public void setStopPointLocation(Location stopPointLocation) {
        this.stopPointLocation = stopPointLocation;
    }

    public float getLaunchYaw() {
        return this.launchYaw;
    }

    public void setLaunchYaw(float launchYaw) {
        this.launchYaw = launchYaw;
    }

    public UUID getOwner() {
        return this.owner;
    }

    public void setOwner(UUID owner) {
        this.owner = owner;
        if (owner != null) {
            this.admins.add(owner);
        }
        this.admins.remove(null);
    }

    public Set<UUID> getAdmins() {
        return new HashSet<UUID>(this.admins);
    }

    public void setAdmins(Collection<UUID> adminIds) {
        this.admins.clear();
        if (adminIds != null) {
            this.admins.addAll(adminIds);
        }
        if (this.owner != null) {
            this.admins.add(this.owner);
        }
        this.admins.remove(null);
    }

    public boolean addAdmin(UUID adminId) {
        if (adminId == null) {
            return false;
        }
        this.admins.remove(null);
        return this.admins.add(adminId);
    }

    public boolean removeAdmin(UUID adminId) {
        if (adminId == null) {
            return false;
        }
        if (this.owner != null && this.owner.equals(adminId)) {
            return false;
        }
        boolean removed = this.admins.remove(adminId);
        this.admins.remove(null);
        return removed;
    }

    public Set<String> getLinkedLineIds() {
        return new HashSet<String>(this.linkedLineIds);
    }

    public void setLinkedLineIds(Collection<String> lineIds) {
        this.linkedLineIds.clear();
        if (lineIds != null) {
            this.linkedLineIds.addAll(lineIds);
        }
    }

    public boolean allowLine(String lineId) {
        if (lineId == null || lineId.isEmpty()) {
            return false;
        }
        return this.linkedLineIds.add(lineId);
    }

    public boolean denyLine(String lineId) {
        if (lineId == null || lineId.isEmpty()) {
            return false;
        }
        return this.linkedLineIds.remove(lineId);
    }

    public boolean isLineAllowed(String lineId) {
        if (lineId == null || lineId.isEmpty()) {
            return false;
        }
        return this.linkedLineIds.contains(lineId);
    }
}

