/*
 * Decompiled with CFR 0.152.
 */
package org.cubexmc.metro.util;

import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.util.Vector;

public class LocationUtil {
    public static String locationToString(Location location) {
        if (location == null || location.getWorld() == null) {
            return null;
        }
        return String.format("%s,%d,%d,%d", location.getWorld().getName(), location.getBlockX(), location.getBlockY(), location.getBlockZ());
    }

    public static boolean isRail(Location location) {
        if (location == null) {
            return false;
        }
        Block block = location.getBlock();
        return block.getType().name().contains("RAIL");
    }

    public static boolean isOnRail(Location location) {
        if (location == null) {
            return false;
        }
        if (LocationUtil.isRail(location)) {
            return true;
        }
        Location belowLocation = location.clone().subtract(0.0, 1.0, 0.0);
        return LocationUtil.isRail(belowLocation);
    }

    public static Vector getDirectionVector(Location from, Location to) {
        return to.toVector().subtract(from.toVector()).normalize();
    }
}

