/*
 * Decompiled with CFR 0.152.
 */
package org.cubexmc.metro.util;

import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.cubexmc.metro.model.Line;
import org.cubexmc.metro.model.Stop;

public final class OwnershipUtil {
    public static final String PERMISSION_ADMIN = "metro.admin";
    public static final String PERMISSION_LINE_CREATE = "metro.line.create";
    public static final String PERMISSION_STOP_CREATE = "metro.stop.create";

    private OwnershipUtil() {
    }

    public static boolean hasAdminBypass(CommandSender sender) {
        return !(sender instanceof Player) || sender.hasPermission(PERMISSION_ADMIN);
    }

    public static boolean canCreateLine(CommandSender sender) {
        return OwnershipUtil.hasAdminBypass(sender) || sender.hasPermission(PERMISSION_LINE_CREATE);
    }

    public static boolean canCreateStop(CommandSender sender) {
        return OwnershipUtil.hasAdminBypass(sender) || sender.hasPermission(PERMISSION_STOP_CREATE);
    }

    public static boolean isServerOwned(Line line) {
        return line != null && line.getOwner() == null;
    }

    public static boolean isServerOwned(Stop stop) {
        return stop != null && stop.getOwner() == null;
    }

    public static boolean isLineAdmin(UUID playerId, Line line) {
        if (line == null || playerId == null) {
            return false;
        }
        Set<UUID> admins = line.getAdmins();
        return admins.contains(playerId);
    }

    public static boolean isStopAdmin(UUID playerId, Stop stop) {
        if (stop == null || playerId == null) {
            return false;
        }
        Set<UUID> admins = stop.getAdmins();
        return admins.contains(playerId);
    }

    public static boolean canManageLine(CommandSender sender, Line line) {
        Player player;
        block6: {
            block5: {
                if (OwnershipUtil.hasAdminBypass(sender)) {
                    return true;
                }
                if (!(sender instanceof Player)) break block5;
                player = (Player)sender;
                if (line != null) break block6;
            }
            return false;
        }
        if (OwnershipUtil.isServerOwned(line)) {
            return player.isOp();
        }
        return OwnershipUtil.isLineAdmin(player.getUniqueId(), line);
    }

    public static boolean canManageStop(CommandSender sender, Stop stop) {
        Player player;
        block6: {
            block5: {
                if (OwnershipUtil.hasAdminBypass(sender)) {
                    return true;
                }
                if (!(sender instanceof Player)) break block5;
                player = (Player)sender;
                if (stop != null) break block6;
            }
            return false;
        }
        if (OwnershipUtil.isServerOwned(stop)) {
            return player.isOp();
        }
        return OwnershipUtil.isStopAdmin(player.getUniqueId(), stop);
    }

    public static boolean canModifyLineStops(CommandSender sender, Line line, Stop stop) {
        if (!OwnershipUtil.canManageLine(sender, line) || stop == null) {
            return false;
        }
        if (OwnershipUtil.hasAdminBypass(sender)) {
            return true;
        }
        if (!(sender instanceof Player)) {
            return false;
        }
        Player player = (Player)sender;
        UUID playerId = player.getUniqueId();
        if (OwnershipUtil.isStopAdmin(playerId, stop)) {
            return true;
        }
        if (OwnershipUtil.isServerOwned(stop)) {
            return player.isOp();
        }
        return stop.isLineAllowed(line.getId());
    }

    public static boolean canLinkStopToLine(CommandSender sender, Line line, Stop stop) {
        Player player;
        block9: {
            block8: {
                if (OwnershipUtil.hasAdminBypass(sender)) {
                    return true;
                }
                if (!(sender instanceof Player)) break block8;
                player = (Player)sender;
                if (line != null && stop != null) break block9;
            }
            return false;
        }
        UUID playerId = player.getUniqueId();
        if (OwnershipUtil.isServerOwned(line) && !player.isOp()) {
            return false;
        }
        if (OwnershipUtil.isServerOwned(stop)) {
            return player.isOp();
        }
        if (!OwnershipUtil.isLineAdmin(playerId, line)) {
            return false;
        }
        if (OwnershipUtil.isStopAdmin(playerId, stop)) {
            return true;
        }
        return stop.isLineAllowed(line.getId());
    }

    public static boolean canLinkLineWithoutPlayer(Line line, Stop stop) {
        if (line == null || stop == null) {
            return false;
        }
        if (stop.isLineAllowed(line.getId())) {
            return true;
        }
        return Objects.equals(stop.getOwner(), line.getOwner());
    }
}

