/*
 * Decompiled with CFR 0.152.
 */
package org.cubexmc.metro.lang;

import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import org.bukkit.ChatColor;
import org.bukkit.configuration.file.YamlConfiguration;
import org.cubexmc.metro.Metro;

public class LanguageManager {
    private final Metro plugin;
    private final Map<String, YamlConfiguration> languageFiles = new HashMap<String, YamlConfiguration>();
    private String defaultLanguage = "zh_CN";
    private String currentLanguage = "zh_CN";

    public LanguageManager(Metro plugin) {
        this.plugin = plugin;
        this.loadLanguages();
    }

    public void loadLanguages() {
        this.languageFiles.clear();
        this.currentLanguage = this.defaultLanguage = this.plugin.getConfig().getString("settings.default_language", "zh_CN");
        File langDir = new File(this.plugin.getDataFolder(), "lang");
        if (!langDir.exists()) {
            langDir.mkdirs();
        }
        this.saveDefaultLanguageFile("zh_CN");
        File[] langFiles = langDir.listFiles((dir, name) -> name.endsWith(".yml"));
        if (langFiles != null) {
            for (File file : langFiles) {
                String langCode = file.getName().replace(".yml", "");
                try {
                    YamlConfiguration langConfig = YamlConfiguration.loadConfiguration((File)file);
                    this.languageFiles.put(langCode, langConfig);
                    this.plugin.getLogger().info("\u5df2\u52a0\u8f7d\u8bed\u8a00\u6587\u4ef6: " + langCode);
                }
                catch (Exception e) {
                    this.plugin.getLogger().log(Level.WARNING, "\u52a0\u8f7d\u8bed\u8a00\u6587\u4ef6\u5931\u8d25: " + file.getName(), e);
                }
            }
        }
        if (!this.languageFiles.containsKey(this.defaultLanguage)) {
            try {
                InputStream inputStream = this.plugin.getResource("lang/" + this.defaultLanguage + ".yml");
                if (inputStream != null) {
                    YamlConfiguration defaultConfig = YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(inputStream, StandardCharsets.UTF_8));
                    this.languageFiles.put(this.defaultLanguage, defaultConfig);
                    this.plugin.getLogger().info("Loaded default language: " + this.defaultLanguage);
                }
            }
            catch (Exception e) {
                this.plugin.getLogger().log(Level.WARNING, "Failed to load default language: " + this.defaultLanguage, e);
            }
        }
    }

    private void saveDefaultLanguageFile(String langCode) {
        File langFile = new File(this.plugin.getDataFolder(), "lang/" + langCode + ".yml");
        if (!langFile.exists()) {
            this.plugin.saveResource("lang/" + langCode + ".yml", false);
        }
    }

    public boolean setLanguage(String langCode) {
        if (this.languageFiles.containsKey(langCode)) {
            this.currentLanguage = langCode;
            return true;
        }
        return false;
    }

    public String getMessage(String key) {
        return this.getMessage(key, this.currentLanguage);
    }

    public String getMessage(String key, String langCode) {
        YamlConfiguration langConfig = this.languageFiles.get(langCode);
        if (langConfig == null || !langConfig.contains(key)) {
            langConfig = this.languageFiles.get(this.defaultLanguage);
        }
        if (langConfig == null || !langConfig.contains(key)) {
            return "Missing message: " + key;
        }
        String message = langConfig.getString(key);
        return ChatColor.translateAlternateColorCodes((char)'&', (String)message);
    }

    public String getMessage(String key, Object ... args) {
        String message = this.getMessage(key);
        for (int i = 0; i < args.length; ++i) {
            message = message.replace("%" + (i + 1), String.valueOf(args[i]));
        }
        return message;
    }

    public String getMessage(String key, Map<String, Object> namedArgs) {
        String message = this.getMessage(key);
        if (namedArgs != null) {
            for (Map.Entry<String, Object> entry : namedArgs.entrySet()) {
                message = message.replace("{" + entry.getKey() + "}", String.valueOf(entry.getValue()));
            }
        }
        return message;
    }

    public static Map<String, Object> args() {
        return new HashMap<String, Object>();
    }

    public static Map<String, Object> put(Map<String, Object> args, String key, Object value) {
        args.put(key, value);
        return args;
    }
}

