/*
 * Decompiled with CFR 0.152.
 */
package org.cubexmc.metro.train;

import java.util.List;
import java.util.Map;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.md_5.bungee.api.ChatMessageType;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Powerable;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Minecart;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;
import org.cubexmc.metro.Metro;
import org.cubexmc.metro.manager.LineManager;
import org.cubexmc.metro.manager.StopManager;
import org.cubexmc.metro.model.Line;
import org.cubexmc.metro.model.Stop;
import org.cubexmc.metro.train.ScoreboardManager;
import org.cubexmc.metro.util.LocationUtil;
import org.cubexmc.metro.util.SchedulerUtil;
import org.cubexmc.metro.util.SoundUtil;
import org.cubexmc.metro.util.TextUtil;

public class TrainMovementTask
implements Runnable {
    private final Metro plugin;
    private final Minecart minecart;
    private final Player passenger;
    private final Line line;
    private String currentStopId;
    private String targetStopId;
    private TrainState currentState;
    private Object taskId;

    public TrainMovementTask(Metro plugin, Minecart minecart, Player passenger, String lineId, String fromStopId) {
        this(plugin, minecart, passenger, lineId, fromStopId, TrainState.STOPPED_AT_STATION);
    }

    public TrainMovementTask(Metro plugin, Minecart minecart, Player passenger, String lineId, String fromStopId, TrainState initialState) {
        this.plugin = plugin;
        this.minecart = minecart;
        this.passenger = passenger;
        LineManager lineManager = plugin.getLineManager();
        this.line = lineManager.getLine(lineId);
        this.currentStopId = fromStopId;
        this.targetStopId = this.line.getNextStopId(this.currentStopId);
        this.currentState = initialState;
        if (this.targetStopId == null) {
            this.currentState = TrainState.STOPPED_AT_STATION;
            return;
        }
        this.updateScoreboardBasedOnState();
    }

    public void setTaskId(Object taskId) {
        this.taskId = taskId;
    }

    public void cancel() {
        SchedulerUtil.cancelTask(this.taskId);
    }

    private void updateScoreboardBasedOnState() {
        if (this.passenger == null || !this.passenger.isOnline()) {
            return;
        }
        switch (this.currentState.ordinal()) {
            case 0: {
                if (this.targetStopId == null) {
                    ScoreboardManager.updateTerminalScoreboard(this.passenger, this.line, this.currentStopId);
                    break;
                }
                ScoreboardManager.updateEnteringStopScoreboard(this.passenger, this.line, this.currentStopId);
                break;
            }
            case 1: {
                ScoreboardManager.updateEnteringStopScoreboard(this.passenger, this.line, this.targetStopId);
                break;
            }
            case 2: {
                ScoreboardManager.updateTravelingScoreboard(this.passenger, this.line, this.targetStopId);
            }
        }
    }

    @Override
    public void run() {
        if (this.minecart == null || this.minecart.isDead() || this.targetStopId == null && this.currentState != TrainState.STOPPED_AT_STATION) {
            this.cancel();
            return;
        }
        if (!this.isPassengerStillRiding()) {
            this.handlePassengerExit();
            return;
        }
        this.maintainMinecartProperties();
        Stop targetStop = this.plugin.getStopManager().getStop(this.targetStopId);
        if (this.targetStopId != null && (targetStop == null || targetStop.getStopPointLocation() == null)) {
            this.cancel();
            return;
        }
        switch (this.currentState.ordinal()) {
            case 0: {
                break;
            }
            case 1: {
                this.handleMovingInStation(targetStop);
                break;
            }
            case 2: {
                this.handleMovingBetweenStations(targetStop);
            }
        }
    }

    private void maintainMinecartProperties() {
        TextComponent customName = Component.text((String)"MetroMinecart");
        SchedulerUtil.entityRun((Plugin)this.plugin, (Entity)this.minecart, () -> this.lambda$maintainMinecartProperties$0((Component)customName), 0L, -1L);
    }

    private void handleDerailment(Location currentLocation) {
        Location nearbyRailLocation = this.findNearbyRail(currentLocation);
        if (nearbyRailLocation != null) {
            this.minecart.teleport(nearbyRailLocation);
        } else {
            if (this.plugin.getConfig().getBoolean("derailment.explosion.enabled", false)) {
                float power = (float)this.plugin.getConfig().getDouble("derailment.explosion.power", 4.0);
                boolean setFire = this.plugin.getConfig().getBoolean("derailment.explosion.set_fire", true);
                boolean breakBlocks = this.plugin.getConfig().getBoolean("derailment.explosion.break_blocks", true);
                SchedulerUtil.regionRun((Plugin)this.plugin, currentLocation, () -> currentLocation.getWorld().createExplosion(currentLocation, power, setFire, breakBlocks), 0L, -1L);
            }
            if (this.passenger != null) {
                this.passenger.sendMessage(this.plugin.getLanguageManager().getMessage("passenger.train_derailed"));
            }
            this.minecart.eject();
            this.minecart.remove();
            this.cancel();
        }
    }

    private void handleMovingInStation(Stop targetStop) {
        Location targetLocation;
        Location currentLocation = this.minecart.getLocation();
        double distance = currentLocation.distance(targetLocation = targetStop.getStopPointLocation());
        if (distance < 0.8) {
            this.transitionToStoppedAtStation();
            return;
        }
        boolean isInStopArea = targetStop.isInStop(currentLocation);
        if (!isInStopArea) {
            this.transitionToMovingBetweenStations();
            return;
        }
    }

    private void handleMovingBetweenStations(Stop targetStop) {
        Location currentLocation = this.minecart.getLocation();
        boolean isInStopArea = targetStop.isInStop(currentLocation);
        if (isInStopArea) {
            this.transitionToMovingInStation(targetStop);
        }
    }

    private void transitionToStoppedAtStation() {
        this.minecart.setVelocity(new Vector(0, 0, 0));
        TrainState previousState = this.currentState;
        this.currentState = TrainState.STOPPED_AT_STATION;
        if (previousState == TrainState.MOVING_IN_STATION) {
            this.handleArrivalAtStation();
        }
        this.updateScoreboardBasedOnState();
    }

    private void transitionToMovingInStation(Stop targetStop) {
        TrainState previousState = this.currentState;
        this.currentState = TrainState.MOVING_IN_STATION;
        if (previousState == TrainState.MOVING_BETWEEN_STATIONS) {
            this.handleEnteringStation(targetStop);
        }
        this.updateScoreboardBasedOnState();
    }

    private void transitionToMovingBetweenStations() {
        this.currentState = TrainState.MOVING_BETWEEN_STATIONS;
        this.updateScoreboardBasedOnState();
    }

    private void handleEnteringStation(Stop targetStop) {
        if (this.passenger == null || !this.passenger.isOnline()) {
            return;
        }
        this.playArrivalSound();
        this.playStationArrivalSound(targetStop);
        String nextStopId = this.line.getNextStopId(this.targetStopId);
        if (nextStopId == null) {
            if (this.plugin.isTerminalStopTitleEnabled()) {
                this.showTerminalStopInfo(targetStop);
            }
        } else {
            this.showArriveStopInfo(targetStop);
        }
    }

    private void playStationArrivalSound(Stop stop) {
        if (!this.plugin.getConfig().getBoolean("station_arrival.enabled", true)) {
            return;
        }
        List notes = this.plugin.getConfig().getStringList("station_arrival.notes");
        if (notes.isEmpty()) {
            return;
        }
        int initialDelay = this.plugin.getConfig().getInt("station_arrival.initial_delay", 0);
        Location stopLocation = stop.getStopPointLocation();
        if (stopLocation == null) {
            return;
        }
        for (Player player : stopLocation.getWorld().getPlayers()) {
            if (player.equals((Object)this.passenger) || !stop.isInStop(player.getLocation())) continue;
            SoundUtil.playNoteSequence(this.plugin, player, notes, initialDelay);
        }
    }

    private void handleArrivalAtStation() {
        this.handleArrivalAtStation(false);
    }

    private void handleArrivalAtStation(boolean isNewlySpawned) {
        if (!isNewlySpawned) {
            this.currentStopId = this.targetStopId;
        }
        if (this.line.getNextStopId(this.currentStopId) == null) {
            this.handleTerminalStation();
            this.targetStopId = null;
        } else {
            this.showWaitingInfo();
            this.startWaitingSound();
            this.scheduleNextDeparture();
        }
    }

    private void handleDeparture() {
        this.targetStopId = this.line.getNextStopId(this.currentStopId);
        if (this.targetStopId == null) {
            this.plugin.getLogger().warning("\u65e0\u6cd5\u542f\u52a8\u5217\u8f66\uff0c\u6ca1\u6709\u4e0b\u4e00\u7ad9: \u5f53\u524d\u7ad9=" + this.currentStopId);
            return;
        }
        StopManager stopManager = this.plugin.getStopManager();
        Stop currentStop = stopManager.getStop(this.currentStopId);
        Stop nextStop = stopManager.getStop(this.targetStopId);
        if (currentStop == null || nextStop == null) {
            this.plugin.getLogger().warning("\u65e0\u6cd5\u542f\u52a8\u5217\u8f66\uff0c\u7ad9\u70b9\u4fe1\u606f\u65e0\u6548");
            return;
        }
        this.playDepartureSound();
        if (this.plugin.getConfig().getBoolean("titles.departure.enabled", true)) {
            this.showDepartureInfo(currentStop, nextStop);
        }
        this.initMinecartVelocity(currentStop.getLaunchYaw(), this.plugin.getCartSpeed() * 0.5);
        this.currentState = TrainState.MOVING_IN_STATION;
        this.updateScoreboardBasedOnState();
    }

    private void scheduleNextDeparture() {
        SchedulerUtil.entityRun((Plugin)this.plugin, (Entity)this.minecart, () -> {
            if (this.isPassengerStillRiding()) {
                this.handleDeparture();
            } else {
                this.handlePassengerExit();
            }
        }, this.plugin.getCartDepartureDelay(), -1L);
    }

    private void handleTerminalStation() {
        if (this.passenger == null || !this.passenger.isOnline()) {
            return;
        }
        SchedulerUtil.entityRun((Plugin)this.plugin, (Entity)this.minecart, () -> {
            if (this.minecart != null && !this.minecart.isDead()) {
                this.minecart.eject();
                ScoreboardManager.clearPlayerDisplay(this.passenger);
                Minecart finalMinecart = this.minecart;
                SchedulerUtil.entityRun((Plugin)this.plugin, (Entity)finalMinecart, () -> {
                    if (finalMinecart != null && !finalMinecart.isDead()) {
                        finalMinecart.remove();
                    }
                }, 40L, -1L);
            }
            this.cancel();
        }, 60L, -1L);
    }

    private Location findNearbyRail(Location location) {
        for (int x = -2; x <= 2; ++x) {
            for (int y = -2; y <= 2; ++y) {
                for (int z = -2; z <= 2; ++z) {
                    Location checkLoc = location.clone().add((double)x, (double)y, (double)z);
                    if (!LocationUtil.isRail(checkLoc)) continue;
                    return checkLoc.clone().add(0.5, 0.0, 0.5);
                }
            }
        }
        return null;
    }

    private boolean isPassengerStillRiding() {
        if (this.passenger == null || !this.passenger.isOnline()) {
            return false;
        }
        Entity vehicle = this.passenger.getVehicle();
        return vehicle != null && vehicle.equals((Object)this.minecart);
    }

    private void handlePassengerExit() {
        this.cancel();
    }

    private void showArriveStopInfo(Stop stop) {
        if (this.passenger == null || !this.passenger.isOnline()) {
            return;
        }
        String nextStopId = this.line.getNextStopId(stop.getId());
        Stop nextStop = null;
        if (nextStopId != null) {
            nextStop = this.plugin.getStopManager().getStop(nextStopId);
        }
        List<String> stopIds = this.line.getOrderedStopIds();
        Stop terminusStop = null;
        if (!stopIds.isEmpty()) {
            String terminusId = stopIds.get(stopIds.size() - 1);
            terminusStop = this.plugin.getStopManager().getStop(terminusId);
        }
        int fadeIn = this.plugin.getArriveStopFadeIn();
        int stay = this.plugin.getArriveStopStay();
        int fadeOut = this.plugin.getArriveStopFadeOut();
        this.showStopInfo("arrive_stop", stop, null, nextStop, terminusStop, fadeIn, stay, fadeOut, false, null);
    }

    private void showTerminalStopInfo(Stop stop) {
        if (this.passenger == null || !this.passenger.isOnline()) {
            return;
        }
        int fadeIn = this.plugin.getConfig().getInt("titles.terminal_stop.fade_in", 10);
        int stay = this.plugin.getConfig().getInt("titles.terminal_stop.stay", 60);
        int fadeOut = this.plugin.getConfig().getInt("titles.terminal_stop.fade_out", 10);
        this.showStopInfo("terminal_stop", stop, null, null, stop, fadeIn, stay, fadeOut, true, stop.getId());
    }

    private void showDepartureInfo(Stop currentStop, Stop nextStop) {
        String actionbarTemplate;
        if (this.passenger == null || !this.passenger.isOnline()) {
            return;
        }
        List<String> stopIds = this.line.getOrderedStopIds();
        String terminusId = stopIds.isEmpty() ? null : stopIds.get(stopIds.size() - 1);
        Stop terminusStop = terminusId != null ? this.plugin.getStopManager().getStop(terminusId) : null;
        int fadeIn = this.plugin.getConfig().getInt("titles.departure.fade_in", 5);
        int stay = this.plugin.getConfig().getInt("titles.departure.stay", 40);
        int fadeOut = this.plugin.getConfig().getInt("titles.departure.fade_out", 5);
        String actionbarTemplateBase = this.plugin.getConfig().getString("titles.departure.actionbar", "\u5217\u8f66\u5df2\u542f\u52a8\uff0c\u8bf7\u6276\u597d\u7ad9\u7a33\uff0c\u6ce8\u610f\u5b89\u5168");
        Map<String, String> customTitle = currentStop.getCustomTitle("departure");
        if (customTitle != null && customTitle.containsKey("actionbar")) {
            actionbarTemplateBase = customTitle.get("actionbar");
        }
        if ((actionbarTemplate = actionbarTemplateBase).contains("{countdown}")) {
            this.startCountdownActionbar("departure", currentStop, currentStop, nextStop, terminusStop);
        }
        this.showStopInfo("departure", currentStop, currentStop, nextStop, terminusStop, fadeIn, stay, fadeOut, false, null);
    }

    private void startCountdownActionbar(String infoType, Stop mainStop, Stop prevStop, Stop nextStop, Stop terminusStop) {
        int totalSeconds;
        if (this.passenger == null || !this.passenger.isOnline()) {
            return;
        }
        String actionbarTemplateBase = this.plugin.getConfig().getString("titles." + infoType + ".actionbar", "");
        Map<String, String> customTitle = mainStop.getCustomTitle(infoType);
        if (customTitle != null && customTitle.containsKey("actionbar")) {
            actionbarTemplateBase = customTitle.get("actionbar");
        }
        String actionbarTemplate = actionbarTemplateBase;
        LineManager lineManager = this.plugin.getLineManager();
        for (int i = totalSeconds = (int)Math.ceil((double)this.plugin.getCartDepartureDelay() / 20.0); i >= 0; --i) {
            int secondsLeft = i;
            long delayTicks = (long)(totalSeconds - i) * 20L;
            SchedulerUtil.globalRun((Plugin)this.plugin, () -> {
                if (this.passenger == null || !this.passenger.isOnline() || this.passenger.getVehicle() != this.minecart) {
                    return;
                }
                String actionbarText = actionbarTemplate.replace("{countdown}", String.valueOf(secondsLeft));
                actionbarText = TextUtil.replacePlaceholders(actionbarText, this.line, mainStop, prevStop, nextStop, terminusStop, lineManager);
                actionbarText = ChatColor.translateAlternateColorCodes((char)'&', (String)actionbarText);
                this.passenger.spigot().sendMessage(ChatMessageType.ACTION_BAR, net.md_5.bungee.api.chat.TextComponent.fromLegacyText((String)actionbarText));
            }, delayTicks, -1L);
        }
    }

    private void showStopInfo(String infoType, Stop mainStop, Stop prevStop, Stop nextStop, Stop terminusStop, int fadeIn, int stay, int fadeOut, boolean updateTerminalScoreboard, String scoreboardStopId) {
        if (this.passenger == null || !this.passenger.isOnline() || mainStop == null) {
            return;
        }
        LineManager lineManager = this.plugin.getLineManager();
        String titleTemplate = this.plugin.getConfig().getString("titles." + infoType + ".title", "");
        String subtitleTemplate = this.plugin.getConfig().getString("titles." + infoType + ".subtitle", "");
        String actionbarTemplate = this.plugin.getConfig().getString("titles." + infoType + ".actionbar", "");
        Map<String, String> customTitle = mainStop.getCustomTitle(infoType);
        if (customTitle != null) {
            if (customTitle.containsKey("title")) {
                titleTemplate = customTitle.get("title");
            }
            if (customTitle.containsKey("subtitle")) {
                subtitleTemplate = customTitle.get("subtitle");
            }
            if (customTitle.containsKey("actionbar")) {
                actionbarTemplate = customTitle.get("actionbar");
            }
        }
        String title = TextUtil.replacePlaceholders(titleTemplate, this.line, mainStop, prevStop, nextStop, terminusStop, lineManager);
        String subtitle = TextUtil.replacePlaceholders(subtitleTemplate, this.line, mainStop, prevStop, nextStop, terminusStop, lineManager);
        String actionbar = TextUtil.replacePlaceholders(actionbarTemplate, this.line, mainStop, prevStop, nextStop, terminusStop, lineManager);
        title = ChatColor.translateAlternateColorCodes((char)'&', (String)title);
        subtitle = ChatColor.translateAlternateColorCodes((char)'&', (String)subtitle);
        actionbar = ChatColor.translateAlternateColorCodes((char)'&', (String)actionbar);
        this.passenger.sendTitle(title, subtitle, fadeIn, stay, fadeOut);
        this.passenger.spigot().sendMessage(ChatMessageType.ACTION_BAR, net.md_5.bungee.api.chat.TextComponent.fromLegacyText((String)actionbar));
        if (updateTerminalScoreboard) {
            ScoreboardManager.updateTerminalScoreboard(this.passenger, this.line, scoreboardStopId);
        }
    }

    private void playArrivalSound() {
        if (this.plugin.isArrivalSoundEnabled() && !this.plugin.getArrivalNotes().isEmpty() && this.passenger != null) {
            SoundUtil.playNoteSequence(this.plugin, this.passenger, this.plugin.getArrivalNotes(), this.plugin.getArrivalInitialDelay());
        }
    }

    private void playDepartureSound() {
        if (this.plugin.isDepartureSoundEnabled() && !this.plugin.getDepartureNotes().isEmpty() && this.passenger != null) {
            SoundUtil.playNoteSequence(this.plugin, this.passenger, this.plugin.getDepartureNotes(), this.plugin.getDepartureInitialDelay());
        }
    }

    private void showWaitingInfo() {
        String actionbarTemplate;
        List<String> stopIds;
        if (this.passenger == null || !this.passenger.isOnline()) {
            return;
        }
        if (!this.plugin.getConfig().getBoolean("titles.waiting.enabled", true)) {
            return;
        }
        StopManager stopManager = this.plugin.getStopManager();
        Stop currentStop = stopManager.getStop(this.currentStopId);
        String nextStopId = this.line.getNextStopId(this.currentStopId);
        Stop nextStop = null;
        if (nextStopId != null) {
            nextStop = stopManager.getStop(nextStopId);
        }
        String terminusId = (stopIds = this.line.getOrderedStopIds()).isEmpty() ? null : stopIds.get(stopIds.size() - 1);
        Stop terminusStop = terminusId != null ? stopManager.getStop(terminusId) : null;
        LineManager lineManager = this.plugin.getLineManager();
        String titleTemplate = this.plugin.getConfig().getString("titles.waiting.title", "\u5217\u8f66\u5373\u5c06\u53d1\u8f66");
        String subtitleTemplate = this.plugin.getConfig().getString("titles.waiting.subtitle", "\u5f53\u524d\u7ad9\u70b9: &a{stop_name} | \u4e0b\u4e00\u7ad9: &e{next_stop_name}");
        Map<String, String> customTitle = currentStop.getCustomTitle("waiting");
        if (customTitle != null) {
            if (customTitle.containsKey("title")) {
                titleTemplate = customTitle.get("title");
            }
            if (customTitle.containsKey("subtitle")) {
                subtitleTemplate = customTitle.get("subtitle");
            }
        }
        String title = TextUtil.replacePlaceholders(titleTemplate, this.line, currentStop, null, nextStop, terminusStop, lineManager);
        String subtitle = TextUtil.replacePlaceholders(subtitleTemplate, this.line, currentStop, null, nextStop, terminusStop, lineManager);
        title = ChatColor.translateAlternateColorCodes((char)'&', (String)title);
        subtitle = ChatColor.translateAlternateColorCodes((char)'&', (String)subtitle);
        this.passenger.sendTitle(title, subtitle, 0, 1000000, 0);
        String actionbarTemplateBase = this.plugin.getConfig().getString("titles.waiting.actionbar", "\u5217\u8f66\u5c06\u5728 &c{countdown} &f\u79d2\u540e\u53d1\u8f66");
        if (customTitle != null && customTitle.containsKey("actionbar")) {
            actionbarTemplateBase = customTitle.get("actionbar");
        }
        if ((actionbarTemplate = actionbarTemplateBase).contains("{countdown}")) {
            this.startCountdownActionbar("waiting", currentStop, null, nextStop, terminusStop);
        } else {
            String actionbarText = TextUtil.replacePlaceholders(actionbarTemplate, this.line, currentStop, null, nextStop, terminusStop, lineManager);
            actionbarText = ChatColor.translateAlternateColorCodes((char)'&', (String)actionbarText);
            this.passenger.spigot().sendMessage(ChatMessageType.ACTION_BAR, net.md_5.bungee.api.chat.TextComponent.fromLegacyText((String)actionbarText));
        }
    }

    private void startWaitingSound() {
        if (!this.plugin.isWaitingSoundEnabled() || this.plugin.getWaitingNotes().isEmpty() || this.passenger == null) {
            return;
        }
        SchedulerUtil.globalRun((Plugin)this.plugin, () -> this.playWaitingSoundOnce(), this.plugin.getWaitingInitialDelay(), -1L);
        int interval = this.plugin.getWaitingSoundInterval();
        int repeatTimes = (int)Math.ceil(this.plugin.getCartDepartureDelay() / (long)interval);
        for (int i = 1; i <= repeatTimes; ++i) {
            SchedulerUtil.globalRun((Plugin)this.plugin, () -> {
                if (this.passenger != null && this.passenger.isOnline() && this.passenger.getVehicle() == this.minecart && this.currentState == TrainState.STOPPED_AT_STATION) {
                    this.playWaitingSoundOnce();
                }
            }, this.plugin.getWaitingInitialDelay() + interval * i, -1L);
        }
    }

    private void playWaitingSoundOnce() {
        if (this.passenger != null && this.passenger.isOnline()) {
            SoundUtil.playNoteSequence(this.plugin, this.passenger, this.plugin.getWaitingNotes(), 0);
        }
    }

    public static void startTrainTask(Metro plugin, Minecart minecart, Player passenger, String lineId, String currentStopId) {
        String nextStopId;
        LineManager lineManager = plugin.getLineManager();
        Line line = lineManager.getLine(lineId);
        if (line == null) {
            plugin.getLogger().warning("\u65e0\u6cd5\u542f\u52a8\u5217\u8f66\uff0c\u7ebf\u8def\u4e0d\u5b58\u5728: " + lineId);
            return;
        }
        if (passenger == null || !passenger.isOnline() || passenger.getVehicle() != minecart) {
            if (minecart.isValid()) {
                minecart.remove();
            }
            return;
        }
        TrainMovementTask trainTask = new TrainMovementTask(plugin, minecart, passenger, lineId, currentStopId);
        Object taskId = SchedulerUtil.entityRun((Plugin)plugin, (Entity)minecart, trainTask, 1L, 1L);
        trainTask.setTaskId(taskId);
        trainTask.targetStopId = nextStopId = line.getNextStopId(currentStopId);
        trainTask.handleArrivalAtStation(true);
    }

    private void initMinecartVelocity(float yaw, double speed) {
        Powerable powerable;
        Location location = this.minecart.getLocation();
        Block block = location.getBlock();
        BlockData blockData = block.getBlockData();
        if (block.getType() == Material.POWERED_RAIL && blockData instanceof Powerable && (powerable = (Powerable)blockData).isPowered()) {
            Vector direction = new Vector(-Math.sin(Math.toRadians(yaw)), 0.0, Math.cos(Math.toRadians(yaw)));
            this.minecart.setVelocity(direction.multiply(0.4));
        }
    }

    private /* synthetic */ void lambda$maintainMinecartProperties$0(Component customName) {
        Location currentLocation;
        this.minecart.customName(customName);
        this.minecart.setGravity(false);
        for (Entity entity : this.minecart.getNearbyEntities(1.0, 1.0, 1.0)) {
            if (entity == this.passenger || entity == this.minecart) continue;
            this.minecart.teleport(this.minecart.getLocation());
            break;
        }
        if (!LocationUtil.isOnRail(currentLocation = this.minecart.getLocation())) {
            this.handleDerailment(currentLocation);
        }
    }

    public static enum TrainState {
        STOPPED_AT_STATION,
        MOVING_IN_STATION,
        MOVING_BETWEEN_STATIONS;

    }
}

