/*
 * Decompiled with CFR 0.152.
 */
package org.cubexmc.metro.util;

import java.util.List;
import org.bukkit.Instrument;
import org.bukkit.Location;
import org.bukkit.Note;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.cubexmc.metro.util.SchedulerUtil;

public class SoundUtil {
    public static void playNoteSequence(JavaPlugin plugin, Player player, List<String> noteSequence) {
        SoundUtil.playNoteSequence(plugin, player, noteSequence, 0);
    }

    public static void playNoteSequence(JavaPlugin plugin, Player player, List<String> noteSequence, int initialDelay) {
        if (player == null || !player.isOnline() || noteSequence == null || noteSequence.isEmpty()) {
            return;
        }
        long totalDelay = initialDelay;
        for (String noteData : noteSequence) {
            String[] parts = noteData.split(",");
            if (parts.length < 4) continue;
            String type = parts[0].trim();
            try {
                int tone = Integer.parseInt(parts[1].trim());
                float volume = Float.parseFloat(parts[2].trim());
                String instrumentName = parts[3].trim();
                int delay = parts.length > 4 ? Integer.parseInt(parts[4].trim()) : 0;
                SchedulerUtil.regionRun((Plugin)plugin, player.getLocation(), () -> {
                    if ("NOTE".equals(type)) {
                        SoundUtil.playNote(player, tone, volume, instrumentName);
                    } else if ("CUSTOM".equals(type)) {
                        player.playSound(player.getLocation(), instrumentName, volume, SoundUtil.getNoteFrequency(tone));
                    }
                }, totalDelay += (long)delay, -1L);
            }
            catch (NumberFormatException numberFormatException) {}
        }
    }

    public static void playNoteSequenceAtLocation(JavaPlugin plugin, Location location, List<String> noteSequence) {
        SoundUtil.playNoteSequenceAtLocation(plugin, location, noteSequence, 0);
    }

    public static void playNoteSequenceAtLocation(JavaPlugin plugin, Location location, List<String> noteSequence, int initialDelay) {
        if (location == null || location.getWorld() == null || noteSequence == null || noteSequence.isEmpty()) {
            return;
        }
        long totalDelay = initialDelay;
        for (String noteData : noteSequence) {
            String[] parts = noteData.split(",");
            if (parts.length < 4) continue;
            String type = parts[0].trim();
            try {
                int tone = Integer.parseInt(parts[1].trim());
                float volume = Float.parseFloat(parts[2].trim());
                String instrumentName = parts[3].trim();
                int delay = parts.length > 4 ? Integer.parseInt(parts[4].trim()) : 0;
                SchedulerUtil.regionRun((Plugin)plugin, location, () -> {
                    if ("NOTE".equals(type)) {
                        SoundUtil.playNoteAtLocation(location, tone, volume, instrumentName);
                    } else if ("CUSTOM".equals(type)) {
                        location.getWorld().playSound(location, instrumentName, volume, SoundUtil.getNoteFrequency(tone));
                    }
                }, totalDelay += (long)delay, -1L);
            }
            catch (NumberFormatException numberFormatException) {}
        }
    }

    private static void playNote(Player player, int tone, float volume, String instrumentName) {
        Instrument instrument = SoundUtil.getInstrument(instrumentName);
        Note note = SoundUtil.getNote(tone);
        if (instrument != null && note != null) {
            player.playNote(player.getLocation(), instrument, note);
        }
    }

    private static void playNoteAtLocation(Location location, int tone, float volume, String instrumentName) {
        Instrument instrument = SoundUtil.getInstrument(instrumentName);
        Note note = SoundUtil.getNote(tone);
        if (instrument != null && note != null && location.getWorld() != null) {
            location.getWorld().playNote(location, instrument, note);
        }
    }

    private static Instrument getInstrument(String name) {
        try {
            return Instrument.valueOf((String)name);
        }
        catch (IllegalArgumentException e) {
            return Instrument.PIANO;
        }
    }

    private static Note getNote(int tone) {
        try {
            tone = Math.max(0, Math.min(tone, 24));
            return new Note(tone);
        }
        catch (IllegalArgumentException e) {
            return new Note(12);
        }
    }

    private static float getNoteFrequency(int tone) {
        return (float)Math.pow(2.0, (double)(tone - 12) / 12.0);
    }
}

