/*
 * Decompiled with CFR 0.152.
 */
package org.cubexmc.metro;

import java.io.File;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.TabCompleter;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.cubexmc.metro.Metrics;
import org.cubexmc.metro.command.MetroAdminCommand;
import org.cubexmc.metro.command.MetroAdminTabCompleter;
import org.cubexmc.metro.lang.LanguageManager;
import org.cubexmc.metro.listener.PlayerInteractListener;
import org.cubexmc.metro.listener.PlayerMoveListener;
import org.cubexmc.metro.listener.VehicleListener;
import org.cubexmc.metro.manager.LineManager;
import org.cubexmc.metro.manager.StopManager;
import org.cubexmc.metro.train.ScoreboardManager;

public final class Metro
extends JavaPlugin {
    private LineManager lineManager;
    private StopManager stopManager;
    private LanguageManager languageManager;

    public void onEnable() {
        if (!this.getDataFolder().exists()) {
            this.getDataFolder().mkdirs();
        }
        this.saveDefaultConfig();
        this.createDefaultConfigFiles();
        this.languageManager = new LanguageManager(this);
        this.lineManager = new LineManager(this);
        this.stopManager = new StopManager(this);
        ScoreboardManager.initialize(this);
        this.getCommand("m").setExecutor((CommandExecutor)new MetroAdminCommand(this));
        this.getCommand("m").setTabCompleter((TabCompleter)new MetroAdminTabCompleter(this));
        Bukkit.getPluginManager().registerEvents((Listener)new PlayerInteractListener(this), (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new VehicleListener(this), (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new PlayerMoveListener(this), (Plugin)this);
        int pluginId = 25825;
        Metrics metrics = new Metrics((Plugin)this, pluginId);
        this.getLogger().info(this.languageManager.getMessage("plugin.enabled"));
    }

    public void onDisable() {
        this.getLogger().info(this.languageManager.getMessage("plugin.disabled"));
    }

    public void ensureDefaultConfigs() {
        File configFile = new File(this.getDataFolder(), "config.yml");
        if (!configFile.exists()) {
            this.saveDefaultConfig();
            this.getLogger().info("\u91cd\u65b0\u751f\u6210\u9ed8\u8ba4\u4e3b\u914d\u7f6e\u6587\u4ef6");
        }
        this.createDefaultConfigFiles();
    }

    private void createDefaultConfigFiles() {
        this.saveDefaultConfigFiles("lines.yml");
        this.saveDefaultConfigFiles("stops.yml");
    }

    private void saveDefaultConfigFiles(String fileName) {
        File file = new File(this.getDataFolder(), fileName);
        if (!file.exists()) {
            this.saveResource(fileName, false);
        }
    }

    public LineManager getLineManager() {
        return this.lineManager;
    }

    public StopManager getStopManager() {
        return this.stopManager;
    }

    public LanguageManager getLanguageManager() {
        return this.languageManager;
    }

    public boolean isEnterStopTitleEnabled() {
        return this.getConfig().getBoolean("titles.enter_stop.enabled", true);
    }

    public String getEnterStopTitle() {
        String title = this.getConfig().getString("titles.enter_stop.title", "\u00a76{line}");
        return ChatColor.translateAlternateColorCodes((char)'&', (String)title);
    }

    public String getEnterStopSubtitle() {
        String subtitle = this.getConfig().getString("titles.enter_stop.subtitle", "\u00a7a{stop_name}");
        return ChatColor.translateAlternateColorCodes((char)'&', (String)subtitle);
    }

    public int getEnterStopFadeIn() {
        return this.getConfig().getInt("titles.enter_stop.fade_in", 10);
    }

    public int getEnterStopStay() {
        return this.getConfig().getInt("titles.enter_stop.stay", 40);
    }

    public int getEnterStopFadeOut() {
        return this.getConfig().getInt("titles.enter_stop.fade_out", 10);
    }

    public boolean isArriveStopTitleEnabled() {
        return this.getConfig().getBoolean("titles.arrive_stop.enabled", true);
    }

    public String getArriveStopTitle() {
        String title = this.getConfig().getString("titles.arrive_stop.title", "\u00a7a\u5df2\u5230\u7ad9");
        return ChatColor.translateAlternateColorCodes((char)'&', (String)title);
    }

    public String getArriveStopSubtitle() {
        String subtitle = this.getConfig().getString("titles.arrive_stop.subtitle", "\u00a76{stop_name}");
        return ChatColor.translateAlternateColorCodes((char)'&', (String)subtitle);
    }

    public int getArriveStopFadeIn() {
        return this.getConfig().getInt("titles.arrive_stop.fade_in", 10);
    }

    public int getArriveStopStay() {
        return this.getConfig().getInt("titles.arrive_stop.stay", 40);
    }

    public int getArriveStopFadeOut() {
        return this.getConfig().getInt("titles.arrive_stop.fade_out", 10);
    }

    public boolean isTerminalStopTitleEnabled() {
        return this.getConfig().getBoolean("titles.terminal_stop.enabled", true);
    }

    public String getTerminalStopTitle() {
        String title = this.getConfig().getString("titles.terminal_stop.title", "\u00a7c\u7ec8\u70b9\u7ad9");
        return ChatColor.translateAlternateColorCodes((char)'&', (String)title);
    }

    public String getTerminalStopSubtitle() {
        String subtitle = this.getConfig().getString("titles.terminal_stop.subtitle", "\u00a76\u8bf7\u4e0b\u8f66");
        return ChatColor.translateAlternateColorCodes((char)'&', (String)subtitle);
    }

    public int getTerminalStopFadeIn() {
        return this.getConfig().getInt("titles.terminal_stop.fade_in", 10);
    }

    public int getTerminalStopStay() {
        return this.getConfig().getInt("titles.terminal_stop.stay", 60);
    }

    public int getTerminalStopFadeOut() {
        return this.getConfig().getInt("titles.terminal_stop.fade_out", 10);
    }

    public boolean isDepartureSoundEnabled() {
        return this.getConfig().getBoolean("sounds.departure.enabled", true);
    }

    public List<String> getDepartureNotes() {
        return this.getConfig().getStringList("sounds.departure.notes");
    }

    public int getDepartureInitialDelay() {
        return this.getConfig().getInt("sounds.departure.initial_delay", 0);
    }

    public boolean isArrivalSoundEnabled() {
        return this.getConfig().getBoolean("sounds.arrival.enabled", true);
    }

    public List<String> getArrivalNotes() {
        return this.getConfig().getStringList("sounds.arrival.notes");
    }

    public int getArrivalInitialDelay() {
        return this.getConfig().getInt("sounds.arrival.initial_delay", 0);
    }

    public boolean isStationArrivalSoundEnabled() {
        return this.getConfig().getBoolean("sounds.station_arrival.enabled", true);
    }

    public List<String> getStationArrivalNotes() {
        return this.getConfig().getStringList("sounds.station_arrival.notes");
    }

    public int getStationArrivalInitialDelay() {
        return this.getConfig().getInt("sounds.station_arrival.initial_delay", 0);
    }

    public boolean isWaitingSoundEnabled() {
        return this.getConfig().getBoolean("sounds.waiting.enabled", true);
    }

    public List<String> getWaitingNotes() {
        return this.getConfig().getStringList("sounds.waiting.notes");
    }

    public int getWaitingInitialDelay() {
        return this.getConfig().getInt("sounds.waiting.initial_delay", 0);
    }

    public int getWaitingSoundInterval() {
        return this.getConfig().getInt("sounds.waiting.interval", 60);
    }

    public double getCartSpeed() {
        return this.getConfig().getDouble("settings.cart_speed", 0.3);
    }

    public long getCartSpawnDelay() {
        return this.getConfig().getLong("settings.cart_spawn_delay", 100L);
    }

    public long getCartDepartureDelay() {
        return this.getConfig().getLong("settings.cart_departure_delay", 100L);
    }
}

