/*
 * Decompiled with CFR 0.152.
 */
package org.cubexmc.metro.command;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.cubexmc.metro.Metro;
import org.cubexmc.metro.manager.LineManager;
import org.cubexmc.metro.manager.StopManager;
import org.cubexmc.metro.model.Line;
import org.cubexmc.metro.model.Stop;
import org.cubexmc.metro.util.LocationUtil;
import org.cubexmc.metro.util.TextUtil;

public class MetroAdminCommand
implements CommandExecutor {
    private final Metro plugin;

    public MetroAdminCommand(Metro plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        block157: {
            String mainCommand;
            StopManager stopManager;
            LineManager lineManager;
            Player player;
            block158: {
                block156: {
                    if (!(sender instanceof Player)) {
                        sender.sendMessage(this.plugin.getLanguageManager().getMessage("plugin.players_only"));
                        return true;
                    }
                    player = (Player)sender;
                    if (!player.hasPermission("metro.admin")) {
                        player.sendMessage(this.plugin.getLanguageManager().getMessage("plugin.no_permission"));
                        return true;
                    }
                    if (args.length == 0) {
                        this.sendHelpMessage(player);
                        return true;
                    }
                    lineManager = this.plugin.getLineManager();
                    stopManager = this.plugin.getStopManager();
                    mainCommand = args[0].toLowerCase();
                    if (mainCommand.equals("testendpoint")) {
                        player.sendMessage(String.valueOf(ChatColor.GREEN) + "\u6b63\u5728\u6d4b\u8bd5\u7ec8\u70b9\u7ad9\u63d0\u793a...");
                        if (this.plugin.isTerminalStopTitleEnabled()) {
                            String title = this.plugin.getTerminalStopTitle();
                            String subtitle = this.plugin.getTerminalStopSubtitle();
                            Line testLine = new Line("test_line", "\u6d4b\u8bd5\u7ebf\u8def");
                            Stop testStop = new Stop("test_stop", "\u6d4b\u8bd5\u7ad9\u70b9");
                            Stop lastStop = new Stop("last_stop", "\u4e0a\u4e00\u7ad9");
                            title = TextUtil.replacePlaceholders(title, testLine, testStop, lastStop, null, testStop, this.plugin.getLineManager());
                            subtitle = TextUtil.replacePlaceholders(subtitle, testLine, testStop, lastStop, null, testStop, this.plugin.getLineManager());
                            player.sendMessage(String.valueOf(ChatColor.GREEN) + "\u663e\u793a\u7ec8\u70b9\u7ad9\u63d0\u793a: title=" + title + ", subtitle=" + subtitle);
                            player.sendTitle(ChatColor.translateAlternateColorCodes((char)'&', (String)title), ChatColor.translateAlternateColorCodes((char)'&', (String)subtitle), this.plugin.getTerminalStopFadeIn(), this.plugin.getTerminalStopStay(), this.plugin.getTerminalStopFadeOut());
                            return true;
                        }
                        player.sendMessage(String.valueOf(ChatColor.RED) + "\u7ec8\u70b9\u7ad9\u63d0\u793a\u672a\u542f\u7528\u3002\u914d\u7f6e\u4e2d titles.terminal_stop.enabled = false");
                        return true;
                    }
                    if (mainCommand.equals("teststopinfo")) {
                        if (args.length < 2) {
                            player.sendMessage(String.valueOf(ChatColor.RED) + "\u7528\u6cd5: /m teststopinfo <line_id> [stop_id]");
                            return true;
                        }
                        String lineId = args[1];
                        Line line = lineManager.getLine(lineId);
                        if (line == null) {
                            player.sendMessage(String.valueOf(ChatColor.RED) + "\u672a\u627e\u5230\u7ebf\u8def: " + lineId);
                            return true;
                        }
                        if (args.length > 2) {
                            String stopId = args[2];
                            Stop stop = stopManager.getStop(stopId);
                            if (stop == null) {
                                player.sendMessage(String.valueOf(ChatColor.RED) + "\u672a\u627e\u5230\u505c\u9760\u533a: " + stopId);
                                return true;
                            }
                            String lastStopId = line.getPreviousStopId(stopId);
                            String nextStopId = line.getNextStopId(stopId);
                            Stop lastStop = lastStopId != null ? stopManager.getStop(lastStopId) : null;
                            Stop nextStop = nextStopId != null ? stopManager.getStop(nextStopId) : null;
                            List<String> stopIds = line.getOrderedStopIds();
                            Stop terminalStop = null;
                            if (!stopIds.isEmpty()) {
                                String terminalStopId = stopIds.get(stopIds.size() - 1);
                                terminalStop = stopManager.getStop(terminalStopId);
                            }
                            player.sendMessage(String.valueOf(ChatColor.GREEN) + "===== \u505c\u9760\u533a\u4fe1\u606f =====");
                            player.sendMessage(String.valueOf(ChatColor.GOLD) + "\u7ebf\u8def: " + line.getName() + " (" + line.getId() + ")");
                            player.sendMessage(String.valueOf(ChatColor.GOLD) + "\u5f53\u524d\u7ad9: " + stop.getName() + " (" + stop.getId() + ")");
                            player.sendMessage(String.valueOf(ChatColor.GOLD) + "\u4e0a\u4e00\u7ad9: " + (lastStop != null ? lastStop.getName() : "\u65e0 (\u8d77\u59cb\u7ad9)"));
                            player.sendMessage(String.valueOf(ChatColor.GOLD) + "\u4e0b\u4e00\u7ad9: " + (nextStop != null ? nextStop.getName() : "\u65e0 (\u7ec8\u70b9\u7ad9)"));
                            player.sendMessage(String.valueOf(ChatColor.GOLD) + "\u7ec8\u70b9\u7ad9: " + (terminalStop != null ? terminalStop.getName() : "\u65e0"));
                            String title = this.plugin.getEnterStopTitle();
                            String subtitle = this.plugin.getEnterStopSubtitle();
                            title = TextUtil.replacePlaceholders(title, line, stop, lastStop, nextStop, terminalStop, lineManager);
                            subtitle = TextUtil.replacePlaceholders(subtitle, line, stop, lastStop, nextStop, terminalStop, lineManager);
                            player.sendMessage(String.valueOf(ChatColor.GREEN) + "\u6807\u9898\u9884\u89c8: " + title);
                            player.sendMessage(String.valueOf(ChatColor.GREEN) + "\u526f\u6807\u9898\u9884\u89c8: " + subtitle);
                            player.sendTitle(ChatColor.translateAlternateColorCodes((char)'&', (String)title), ChatColor.translateAlternateColorCodes((char)'&', (String)subtitle), this.plugin.getEnterStopFadeIn(), this.plugin.getEnterStopStay(), this.plugin.getEnterStopFadeOut());
                        } else {
                            List<String> stopIds = line.getOrderedStopIds();
                            if (stopIds.isEmpty()) {
                                player.sendMessage(String.valueOf(ChatColor.YELLOW) + "\u7ebf\u8def " + line.getName() + " \u4e0a\u6ca1\u6709\u7ad9\u70b9\u3002");
                                return true;
                            }
                            player.sendMessage(String.valueOf(ChatColor.GREEN) + "===== \u7ebf\u8def\u7ad9\u70b9 =====");
                            player.sendMessage(String.valueOf(ChatColor.GOLD) + "\u7ebf\u8def: " + line.getName() + " (" + line.getId() + ")");
                            for (int i = 0; i < stopIds.size(); ++i) {
                                String stopId = stopIds.get(i);
                                Stop stop = stopManager.getStop(stopId);
                                if (stop == null) continue;
                                String status = "";
                                if (i == 0) {
                                    status = " (\u8d77\u59cb\u7ad9)";
                                }
                                if (i == stopIds.size() - 1) {
                                    status = " (\u7ec8\u70b9\u7ad9)";
                                }
                                player.sendMessage(String.valueOf(ChatColor.AQUA) + (i + 1) + ". " + String.valueOf(ChatColor.YELLOW) + stop.getName() + String.valueOf(ChatColor.WHITE) + " (" + stop.getId() + ")" + String.valueOf(ChatColor.GOLD) + status);
                            }
                            player.sendMessage(String.valueOf(ChatColor.GREEN) + "\u4f7f\u7528 /m teststopinfo " + lineId + " <stop_id> \u67e5\u770b\u8be6\u7ec6\u4fe1\u606f");
                        }
                        return true;
                    }
                    if (!mainCommand.equals("line")) break block156;
                    if (args.length < 2) {
                        this.sendLineHelpMessage(player);
                        return true;
                    }
                    String subCommand = args[1].toLowerCase();
                    if (subCommand.equals("setcolor")) {
                        if (args.length < 4) {
                            player.sendMessage(String.valueOf(ChatColor.RED) + "\u7528\u6cd5: /m line setcolor <line_id> <\u989c\u8272>");
                            player.sendMessage(String.valueOf(ChatColor.YELLOW) + "\u989c\u8272\u793a\u4f8b: &a, &b, &c, &9 \u7b49Minecraft\u989c\u8272\u4ee3\u7801");
                            return true;
                        }
                        String lineId = args[2];
                        String color = args[3];
                        Line line = lineManager.getLine(lineId);
                        if (line == null) {
                            player.sendMessage(String.valueOf(ChatColor.RED) + "\u672a\u627e\u5230\u7ebf\u8def: " + lineId);
                            return true;
                        }
                        lineManager.setLineColor(lineId, color);
                        player.sendMessage(String.valueOf(ChatColor.GREEN) + "\u6210\u529f\u8bbe\u7f6e\u7ebf\u8def " + line.getName() + " \u7684\u989c\u8272\u4e3a: " + ChatColor.translateAlternateColorCodes((char)'&', (String)color) + "\u793a\u4f8b\u6587\u672c");
                        return true;
                    }
                    if (subCommand.equals("setterminus")) {
                        if (args.length < 4) {
                            player.sendMessage(String.valueOf(ChatColor.RED) + "\u7528\u6cd5: /m line setterminus <line_id> <\u7ec8\u70b9\u65b9\u5411\u540d\u79f0>");
                            return true;
                        }
                        String lineId = args[2];
                        StringBuilder terminusName = new StringBuilder();
                        for (int i = 3; i < args.length; ++i) {
                            if (i > 3) {
                                terminusName.append(" ");
                            }
                            terminusName.append(args[i]);
                        }
                        Line line = lineManager.getLine(lineId);
                        if (line == null) {
                            player.sendMessage(String.valueOf(ChatColor.RED) + "\u672a\u627e\u5230\u7ebf\u8def: " + lineId);
                            return true;
                        }
                        lineManager.setLineTerminusName(lineId, terminusName.toString());
                        player.sendMessage(String.valueOf(ChatColor.GREEN) + "\u6210\u529f\u8bbe\u7f6e\u7ebf\u8def " + line.getName() + " \u7684\u7ec8\u70b9\u65b9\u5411\u540d\u79f0\u4e3a: " + String.valueOf(terminusName));
                        return true;
                    }
                    if (subCommand.equals("rename")) {
                        if (args.length < 4) {
                            player.sendMessage(String.valueOf(ChatColor.RED) + "\u7528\u6cd5: /m line rename <line_id> <\u65b0\u540d\u79f0>");
                            return true;
                        }
                        String lineId = args[2];
                        StringBuilder newName = new StringBuilder();
                        for (int i = 3; i < args.length; ++i) {
                            if (i > 3) {
                                newName.append(" ");
                            }
                            newName.append(args[i]);
                        }
                        Line line = lineManager.getLine(lineId);
                        if (line == null) {
                            player.sendMessage(String.valueOf(ChatColor.RED) + "\u672a\u627e\u5230\u7ebf\u8def: " + lineId);
                            return true;
                        }
                        String oldName = line.getName();
                        if (lineManager.setLineName(lineId, newName.toString())) {
                            player.sendMessage(String.valueOf(ChatColor.GREEN) + "\u6210\u529f\u5c06\u7ebf\u8def " + oldName + " \u91cd\u547d\u540d\u4e3a: " + String.valueOf(newName));
                        } else {
                            player.sendMessage(String.valueOf(ChatColor.RED) + "\u91cd\u547d\u540d\u7ebf\u8def\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u7ebf\u8defID\u662f\u5426\u5b58\u5728\u3002");
                        }
                        return true;
                    }
                    switch (subCommand) {
                        case "create": {
                            if (args.length < 3) {
                                player.sendMessage(String.valueOf(ChatColor.RED) + "\u7528\u6cd5: /m line create <line_id> <\"\u663e\u793a\u540d\u79f0\">");
                                return true;
                            }
                            String lineId = args[2];
                            StringBuilder nameBuilder = new StringBuilder();
                            for (int i = 3; i < args.length; ++i) {
                                nameBuilder.append(args[i]).append(" ");
                            }
                            String lineName = nameBuilder.toString().trim();
                            if (lineManager.createLine(lineId, lineName)) {
                                player.sendMessage(String.valueOf(ChatColor.GREEN) + "\u6210\u529f\u521b\u5efa\u7ebf\u8def: " + lineName);
                                break;
                            }
                            player.sendMessage(String.valueOf(ChatColor.RED) + "\u7ebf\u8defID " + lineId + " \u5df2\u5b58\u5728!");
                            break;
                        }
                        case "delete": {
                            if (args.length < 3) {
                                player.sendMessage(String.valueOf(ChatColor.RED) + "\u7528\u6cd5: /m line delete <line_id>");
                                return true;
                            }
                            String lineId = args[2];
                            if (lineManager.deleteLine(lineId)) {
                                player.sendMessage(String.valueOf(ChatColor.GREEN) + "\u6210\u529f\u5220\u9664\u7ebf\u8def: " + lineId);
                                break;
                            }
                            player.sendMessage(String.valueOf(ChatColor.RED) + "\u627e\u4e0d\u5230\u7ebf\u8defID: " + lineId);
                            break;
                        }
                        case "list": {
                            List<Line> lines = lineManager.getAllLines();
                            if (lines.isEmpty()) {
                                player.sendMessage(String.valueOf(ChatColor.YELLOW) + "\u6682\u65e0\u7ebf\u8def\u3002");
                                break;
                            }
                            player.sendMessage(String.valueOf(ChatColor.GREEN) + "===== \u7ebf\u8def\u5217\u8868 =====");
                            for (Line line : lines) {
                                player.sendMessage(String.valueOf(ChatColor.GOLD) + line.getId() + String.valueOf(ChatColor.WHITE) + ": " + String.valueOf(ChatColor.YELLOW) + line.getName());
                            }
                            break block157;
                        }
                        case "addstop": {
                            if (args.length < 4) {
                                player.sendMessage(String.valueOf(ChatColor.RED) + "\u7528\u6cd5: /m line addstop <line_id> <stop_id> [\u987a\u5e8f\u7d22\u5f15]");
                                return true;
                            }
                            String lineId = args[2];
                            String stopId = args[3];
                            int index = -1;
                            if (args.length > 4) {
                                try {
                                    index = Integer.parseInt(args[4]);
                                }
                                catch (NumberFormatException e) {
                                    player.sendMessage(String.valueOf(ChatColor.RED) + "\u7d22\u5f15\u5fc5\u987b\u662f\u4e00\u4e2a\u6570\u5b57\u3002");
                                    return true;
                                }
                            }
                            if (lineManager.addStopToLine(lineId, stopId, index)) {
                                player.sendMessage(String.valueOf(ChatColor.GREEN) + "\u6210\u529f\u5c06\u505c\u9760\u533a " + stopId + " \u6dfb\u52a0\u5230\u7ebf\u8def " + lineId);
                                break;
                            }
                            player.sendMessage(String.valueOf(ChatColor.RED) + "\u6dfb\u52a0\u505c\u9760\u533a\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u7ebf\u8defID\u548c\u505c\u9760\u533aID\u662f\u5426\u5b58\u5728\u3002");
                            break;
                        }
                        case "delstop": {
                            if (args.length < 4) {
                                player.sendMessage(String.valueOf(ChatColor.RED) + "\u7528\u6cd5: /m line delstop <line_id> <stop_id>");
                                return true;
                            }
                            String lineId = args[2];
                            String stopId = args[3];
                            if (lineManager.removeStopFromLine(lineId, stopId)) {
                                player.sendMessage(String.valueOf(ChatColor.GREEN) + "\u6210\u529f\u4ece\u7ebf\u8def " + lineId + " \u4e2d\u79fb\u9664\u505c\u9760\u533a " + stopId);
                                break;
                            }
                            player.sendMessage(String.valueOf(ChatColor.RED) + "\u79fb\u9664\u505c\u9760\u533a\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u7ebf\u8defID\u548c\u505c\u9760\u533aID\u662f\u5426\u5b58\u5728\u3002");
                            break;
                        }
                        case "stops": {
                            if (args.length < 3) {
                                player.sendMessage(String.valueOf(ChatColor.RED) + "\u7528\u6cd5: /m line stops <line_id>");
                                return true;
                            }
                            String lineId = args[2];
                            Line line = lineManager.getLine(lineId);
                            if (line == null) {
                                player.sendMessage(String.valueOf(ChatColor.RED) + "\u672a\u627e\u5230\u7ebf\u8def: " + lineId);
                                return true;
                            }
                            List<String> stopIds = line.getOrderedStopIds();
                            if (stopIds.isEmpty()) {
                                player.sendMessage(String.valueOf(ChatColor.YELLOW) + "\u7ebf\u8def " + line.getName() + " \u4e0a\u6ca1\u6709\u7ad9\u70b9\u3002");
                                return true;
                            }
                            player.sendMessage(String.valueOf(ChatColor.GREEN) + "===== \u7ebf\u8def\u7ad9\u70b9\u5217\u8868 =====");
                            player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)line.getColor()) + line.getName() + String.valueOf(ChatColor.GRAY) + " (" + line.getId() + ")");
                            for (int i = 0; i < stopIds.size(); ++i) {
                                String currentStopId = stopIds.get(i);
                                Stop stop = stopManager.getStop(currentStopId);
                                if (stop != null) {
                                    String status = "";
                                    if (i == 0) {
                                        status = " (\u8d77\u59cb\u7ad9)";
                                    }
                                    if (i == stopIds.size() - 1) {
                                        status = " (\u7ec8\u70b9\u7ad9)";
                                    }
                                    player.sendMessage(String.valueOf(ChatColor.AQUA) + (i + 1) + ". " + String.valueOf(ChatColor.YELLOW) + stop.getName() + String.valueOf(ChatColor.WHITE) + " (" + stop.getId() + ")" + String.valueOf(ChatColor.GOLD) + status);
                                    continue;
                                }
                                player.sendMessage(String.valueOf(ChatColor.AQUA) + (i + 1) + ". " + String.valueOf(ChatColor.RED) + currentStopId + " (\u65e0\u6548\u7ad9\u70b9)");
                            }
                            break block157;
                        }
                        default: {
                            this.sendLineHelpMessage(player);
                        }
                    }
                    break block157;
                }
                if (!mainCommand.equals("stop")) break block158;
                if (args.length < 2) {
                    this.sendStopHelpMessage(player);
                    return true;
                }
                String subCommand = args[1].toLowerCase();
                if (subCommand.equals("addtransfer")) {
                    if (args.length < 4) {
                        player.sendMessage(String.valueOf(ChatColor.RED) + "\u7528\u6cd5: /m stop addtransfer <stop_id> <transfer_line_id>");
                        return true;
                    }
                    String stopId = args[2];
                    String transferLineId = args[3];
                    Stop stop = stopManager.getStop(stopId);
                    if (stop == null) {
                        player.sendMessage(String.valueOf(ChatColor.RED) + "\u672a\u627e\u5230\u505c\u9760\u533a: " + stopId);
                        return true;
                    }
                    Line transferLine = lineManager.getLine(transferLineId);
                    if (transferLine == null) {
                        player.sendMessage(String.valueOf(ChatColor.RED) + "\u672a\u627e\u5230\u7ebf\u8def: " + transferLineId);
                        return true;
                    }
                    if (stopManager.addTransferLine(stopId, transferLineId)) {
                        player.sendMessage(String.valueOf(ChatColor.GREEN) + "\u6210\u529f\u5c06\u7ebf\u8def " + transferLine.getName() + " \u6dfb\u52a0\u4e3a\u505c\u9760\u533a " + stop.getName() + " \u7684\u53ef\u6362\u4e58\u7ebf\u8def");
                    } else {
                        player.sendMessage(String.valueOf(ChatColor.YELLOW) + "\u505c\u9760\u533a " + stop.getName() + " \u5df2\u5b58\u5728\u53ef\u6362\u4e58\u7ebf\u8def " + transferLine.getName());
                    }
                    return true;
                }
                if (subCommand.equals("deltransfer")) {
                    if (args.length < 4) {
                        player.sendMessage(String.valueOf(ChatColor.RED) + "\u7528\u6cd5: /m stop deltransfer <stop_id> <transfer_line_id>");
                        return true;
                    }
                    String stopId = args[2];
                    String transferLineId = args[3];
                    Stop stop = stopManager.getStop(stopId);
                    if (stop == null) {
                        player.sendMessage(String.valueOf(ChatColor.RED) + "\u672a\u627e\u5230\u505c\u9760\u533a: " + stopId);
                        return true;
                    }
                    Line transferLine = lineManager.getLine(transferLineId);
                    if (transferLine == null) {
                        player.sendMessage(String.valueOf(ChatColor.RED) + "\u672a\u627e\u5230\u7ebf\u8def: " + transferLineId);
                        return true;
                    }
                    if (stopManager.removeTransferLine(stopId, transferLineId)) {
                        player.sendMessage(String.valueOf(ChatColor.GREEN) + "\u6210\u529f\u4ece\u505c\u9760\u533a " + stop.getName() + " \u79fb\u9664\u53ef\u6362\u4e58\u7ebf\u8def " + transferLine.getName());
                    } else {
                        player.sendMessage(String.valueOf(ChatColor.YELLOW) + "\u505c\u9760\u533a " + stop.getName() + " \u4e0d\u5b58\u5728\u53ef\u6362\u4e58\u7ebf\u8def " + transferLine.getName());
                    }
                    return true;
                }
                if (subCommand.equals("listtransfers")) {
                    if (args.length < 3) {
                        player.sendMessage(String.valueOf(ChatColor.RED) + "\u7528\u6cd5: /m stop listtransfers <stop_id>");
                        return true;
                    }
                    String stopId = args[2];
                    Stop stop = stopManager.getStop(stopId);
                    if (stop == null) {
                        player.sendMessage(String.valueOf(ChatColor.RED) + "\u672a\u627e\u5230\u505c\u9760\u533a: " + stopId);
                        return true;
                    }
                    List<String> transferLineIds = stop.getTransferableLines();
                    if (transferLineIds.isEmpty()) {
                        player.sendMessage(String.valueOf(ChatColor.YELLOW) + "\u505c\u9760\u533a " + stop.getName() + " \u6ca1\u6709\u53ef\u6362\u4e58\u7ebf\u8def");
                        return true;
                    }
                    player.sendMessage(String.valueOf(ChatColor.GREEN) + "\u505c\u9760\u533a " + stop.getName() + " \u7684\u53ef\u6362\u4e58\u7ebf\u8def:");
                    for (String transferLineId : transferLineIds) {
                        Line transferLine = lineManager.getLine(transferLineId);
                        if (transferLine != null) {
                            player.sendMessage(String.valueOf(ChatColor.YELLOW) + "- " + ChatColor.translateAlternateColorCodes((char)'&', (String)transferLine.getColor()) + transferLine.getName() + String.valueOf(ChatColor.GRAY) + " (" + transferLineId + ")");
                            continue;
                        }
                        player.sendMessage(String.valueOf(ChatColor.RED) + "- " + transferLineId + " (\u65e0\u6548\u7ebf\u8def)");
                    }
                    return true;
                }
                if (subCommand.equals("settitle")) {
                    if (args.length < 6) {
                        player.sendMessage(String.valueOf(ChatColor.RED) + "\u7528\u6cd5: /m stop settitle <stop_id> <title_type> <key> <value>");
                        player.sendMessage(String.valueOf(ChatColor.RED) + "title_type: stop_continuous, arrive_stop, terminal_stop, departure");
                        player.sendMessage(String.valueOf(ChatColor.RED) + "key: title, subtitle, actionbar");
                        return true;
                    }
                    String stopId = args[2];
                    String titleType = args[3];
                    String key = args[4];
                    StringBuilder valueBuilder = new StringBuilder();
                    for (int i = 5; i < args.length; ++i) {
                        if (i > 5) {
                            valueBuilder.append(" ");
                        }
                        valueBuilder.append(args[i]);
                    }
                    String value = valueBuilder.toString();
                    Stop stop = stopManager.getStop(stopId);
                    if (stop == null) {
                        player.sendMessage(String.valueOf(ChatColor.RED) + "\u672a\u627e\u5230\u505c\u9760\u533a: " + stopId);
                        return true;
                    }
                    if (!this.isValidTitleType(titleType)) {
                        player.sendMessage(String.valueOf(ChatColor.RED) + "\u65e0\u6548\u7684title\u7c7b\u578b: " + titleType);
                        player.sendMessage(String.valueOf(ChatColor.RED) + "\u6709\u6548\u7c7b\u578b: stop_continuous, arrive_stop, terminal_stop, departure");
                        return true;
                    }
                    if (!this.isValidTitleKey(key)) {
                        player.sendMessage(String.valueOf(ChatColor.RED) + "\u65e0\u6548\u7684title\u952e: " + key);
                        player.sendMessage(String.valueOf(ChatColor.RED) + "\u6709\u6548\u952e: title, subtitle, actionbar");
                        return true;
                    }
                    Map<String, String> titleConfig = stop.getCustomTitle(titleType);
                    if (titleConfig == null) {
                        titleConfig = new HashMap<String, String>();
                    }
                    titleConfig.put(key, value);
                    stop.setCustomTitle(titleType, titleConfig);
                    stopManager.saveConfig();
                    player.sendMessage(String.valueOf(ChatColor.GREEN) + "\u6210\u529f\u4e3a\u505c\u9760\u533a " + stop.getName() + " \u8bbe\u7f6e\u81ea\u5b9a\u4e49title: [" + titleType + "." + key + "] = \"" + value + "\"");
                    return true;
                }
                if (subCommand.equals("deltitle")) {
                    if (args.length < 4) {
                        player.sendMessage(String.valueOf(ChatColor.RED) + "\u7528\u6cd5: /m stop deltitle <stop_id> <title_type> [key]");
                        player.sendMessage(String.valueOf(ChatColor.RED) + "\u7701\u7565key\u5c06\u5220\u9664\u6574\u4e2atitle_type\u7684\u6240\u6709\u8bbe\u7f6e");
                        return true;
                    }
                    String stopId = args[2];
                    String titleType = args[3];
                    String key = args.length > 4 ? args[4] : null;
                    Stop stop = stopManager.getStop(stopId);
                    if (stop == null) {
                        player.sendMessage(String.valueOf(ChatColor.RED) + "\u672a\u627e\u5230\u505c\u9760\u533a: " + stopId);
                        return true;
                    }
                    if (!this.isValidTitleType(titleType)) {
                        player.sendMessage(String.valueOf(ChatColor.RED) + "\u65e0\u6548\u7684title\u7c7b\u578b: " + titleType);
                        player.sendMessage(String.valueOf(ChatColor.RED) + "\u6709\u6548\u7c7b\u578b: stop_continuous, arrive_stop, terminal_stop, departure");
                        return true;
                    }
                    if (key == null) {
                        if (stop.removeCustomTitle(titleType)) {
                            stopManager.saveConfig();
                            player.sendMessage(String.valueOf(ChatColor.GREEN) + "\u6210\u529f\u4ece\u505c\u9760\u533a " + stop.getName() + " \u79fb\u9664\u6240\u6709 " + titleType + " \u81ea\u5b9a\u4e49title\u8bbe\u7f6e");
                        } else {
                            player.sendMessage(String.valueOf(ChatColor.YELLOW) + "\u505c\u9760\u533a " + stop.getName() + " \u6ca1\u6709 " + titleType + " \u81ea\u5b9a\u4e49title\u8bbe\u7f6e");
                        }
                    } else {
                        Map<String, String> titleConfig = stop.getCustomTitle(titleType);
                        if (titleConfig != null && titleConfig.containsKey(key)) {
                            titleConfig.remove(key);
                            if (titleConfig.isEmpty()) {
                                stop.removeCustomTitle(titleType);
                            } else {
                                stop.setCustomTitle(titleType, titleConfig);
                            }
                            stopManager.saveConfig();
                            player.sendMessage(String.valueOf(ChatColor.GREEN) + "\u6210\u529f\u4ece\u505c\u9760\u533a " + stop.getName() + " \u79fb\u9664\u81ea\u5b9a\u4e49title: [" + titleType + "." + key + "]");
                        } else {
                            player.sendMessage(String.valueOf(ChatColor.YELLOW) + "\u505c\u9760\u533a " + stop.getName() + " \u6ca1\u6709\u81ea\u5b9a\u4e49title: [" + titleType + "." + key + "]");
                        }
                    }
                    return true;
                }
                if (subCommand.equals("listtitles")) {
                    String[] titleTypes;
                    if (args.length < 3) {
                        player.sendMessage(String.valueOf(ChatColor.RED) + "\u7528\u6cd5: /m stop listtitles <stop_id>");
                        return true;
                    }
                    String stopId = args[2];
                    Stop stop = stopManager.getStop(stopId);
                    if (stop == null) {
                        player.sendMessage(String.valueOf(ChatColor.RED) + "\u672a\u627e\u5230\u505c\u9760\u533a: " + stopId);
                        return true;
                    }
                    player.sendMessage(String.valueOf(ChatColor.GREEN) + "===== \u505c\u9760\u533a " + stop.getName() + " \u81ea\u5b9a\u4e49Title\u914d\u7f6e =====");
                    boolean hasCustomTitles = false;
                    for (String titleType : titleTypes = new String[]{"stop_continuous", "arrive_stop", "terminal_stop", "departure"}) {
                        Map<String, String> titleConfig = stop.getCustomTitle(titleType);
                        if (titleConfig == null || titleConfig.isEmpty()) continue;
                        hasCustomTitles = true;
                        player.sendMessage(String.valueOf(ChatColor.GOLD) + "\u7c7b\u578b: " + titleType);
                        for (Map.Entry<String, String> entry : titleConfig.entrySet()) {
                            player.sendMessage(String.valueOf(ChatColor.YELLOW) + "  - " + entry.getKey() + ": \"" + String.valueOf(ChatColor.WHITE) + entry.getValue() + String.valueOf(ChatColor.YELLOW) + "\"");
                        }
                    }
                    if (!hasCustomTitles) {
                        player.sendMessage(String.valueOf(ChatColor.YELLOW) + "\u8be5\u505c\u9760\u533a\u6ca1\u6709\u81ea\u5b9a\u4e49Title\u914d\u7f6e");
                    }
                    return true;
                }
                if (subCommand.equals("rename")) {
                    if (args.length < 4) {
                        player.sendMessage(String.valueOf(ChatColor.RED) + "\u7528\u6cd5: /m stop rename <stop_id> <\u65b0\u540d\u79f0>");
                        return true;
                    }
                    String stopId = args[2];
                    StringBuilder newName = new StringBuilder();
                    for (int i = 3; i < args.length; ++i) {
                        if (i > 3) {
                            newName.append(" ");
                        }
                        newName.append(args[i]);
                    }
                    Stop stop = stopManager.getStop(stopId);
                    if (stop == null) {
                        player.sendMessage(String.valueOf(ChatColor.RED) + "\u672a\u627e\u5230\u505c\u9760\u533a: " + stopId);
                        return true;
                    }
                    String oldName = stop.getName();
                    if (stopManager.setStopName(stopId, newName.toString())) {
                        player.sendMessage(String.valueOf(ChatColor.GREEN) + "\u6210\u529f\u5c06\u505c\u9760\u533a " + oldName + " \u91cd\u547d\u540d\u4e3a: " + String.valueOf(newName));
                    } else {
                        player.sendMessage(String.valueOf(ChatColor.RED) + "\u91cd\u547d\u540d\u505c\u9760\u533a\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u505c\u9760\u533aID\u662f\u5426\u5b58\u5728\u3002");
                    }
                    return true;
                }
                switch (subCommand) {
                    case "create": {
                        if (args.length < 3) {
                            player.sendMessage(String.valueOf(ChatColor.RED) + "\u7528\u6cd5: /m stop create <stop_id> <\"\u663e\u793a\u540d\u79f0\">");
                            return true;
                        }
                        String stopId = args[2];
                        StringBuilder nameBuilder = new StringBuilder();
                        for (int i = 3; i < args.length; ++i) {
                            nameBuilder.append(args[i]).append(" ");
                        }
                        String stopName = nameBuilder.toString().trim();
                        Stop newStop = stopManager.createStop(stopId, stopName);
                        if (newStop != null) {
                            player.sendMessage(String.valueOf(ChatColor.GREEN) + "\u6210\u529f\u521b\u5efa\u505c\u9760\u533a: " + stopName);
                            break;
                        }
                        player.sendMessage(String.valueOf(ChatColor.RED) + "\u505c\u9760\u533aID " + stopId + " \u5df2\u5b58\u5728!");
                        break;
                    }
                    case "delete": {
                        if (args.length < 3) {
                            player.sendMessage(String.valueOf(ChatColor.RED) + "\u7528\u6cd5: /m stop delete <stop_id>");
                            return true;
                        }
                        String stopId = args[2];
                        if (stopManager.deleteStop(stopId)) {
                            player.sendMessage(String.valueOf(ChatColor.GREEN) + "\u6210\u529f\u5220\u9664\u505c\u9760\u533a: " + stopId);
                            break;
                        }
                        player.sendMessage(String.valueOf(ChatColor.RED) + "\u627e\u4e0d\u5230\u505c\u9760\u533aID: " + stopId);
                        break;
                    }
                    case "list": {
                        ArrayList stops = new ArrayList(stopManager.getAllStopIds().stream().map(stopManager::getStop).filter(Objects::nonNull).collect(Collectors.toList()));
                        if (stops.isEmpty()) {
                            player.sendMessage(String.valueOf(ChatColor.YELLOW) + "\u6682\u65e0\u505c\u9760\u533a\u3002");
                            break;
                        }
                        player.sendMessage(String.valueOf(ChatColor.GREEN) + "===== \u505c\u9760\u533a\u5217\u8868 =====");
                        for (Stop stop : stops) {
                            player.sendMessage(String.valueOf(ChatColor.GOLD) + stop.getId() + String.valueOf(ChatColor.WHITE) + ": " + String.valueOf(ChatColor.YELLOW) + stop.getName());
                        }
                        break block157;
                    }
                    case "setcorner1": {
                        if (args.length < 3) {
                            player.sendMessage(String.valueOf(ChatColor.RED) + "\u7528\u6cd5: /m stop setcorner1 <stop_id>");
                            return true;
                        }
                        String stopId = args[2];
                        Location location = player.getLocation();
                        if (stopManager.setStopCorner1(stopId, location)) {
                            player.sendMessage(String.valueOf(ChatColor.GREEN) + "\u6210\u529f\u4e3a\u505c\u9760\u533a " + stopId + " \u8bbe\u7f6e\u533a\u57df\u7b2c\u4e00\u4e2a\u89d2\u70b9: " + LocationUtil.locationToString(location));
                            break;
                        }
                        player.sendMessage(String.valueOf(ChatColor.RED) + "\u8bbe\u7f6e\u505c\u9760\u533a\u89d2\u70b9\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u505c\u9760\u533aID\u662f\u5426\u5b58\u5728\u3002");
                        break;
                    }
                    case "setcorner2": {
                        if (args.length < 3) {
                            player.sendMessage(String.valueOf(ChatColor.RED) + "\u7528\u6cd5: /m stop setcorner2 <stop_id>");
                            return true;
                        }
                        String stopId = args[2];
                        Location location = player.getLocation();
                        if (stopManager.setStopCorner2(stopId, location)) {
                            player.sendMessage(String.valueOf(ChatColor.GREEN) + "\u6210\u529f\u4e3a\u505c\u9760\u533a " + stopId + " \u8bbe\u7f6e\u533a\u57df\u7b2c\u4e8c\u4e2a\u89d2\u70b9: " + LocationUtil.locationToString(location));
                            break;
                        }
                        player.sendMessage(String.valueOf(ChatColor.RED) + "\u8bbe\u7f6e\u505c\u9760\u533a\u89d2\u70b9\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u505c\u9760\u533aID\u662f\u5426\u5b58\u5728\u3002");
                        break;
                    }
                    case "setpoint": {
                        Location location = player.getLocation();
                        if (!LocationUtil.isRail(location)) {
                            player.sendMessage(this.plugin.getLanguageManager().getMessage("command.stop.setpoint_not_rail"));
                            return true;
                        }
                        Stop stop = stopManager.getStopContainingLocation(location);
                        if (stop == null) {
                            player.sendMessage(this.plugin.getLanguageManager().getMessage("command.stop.no_stop_found_at_location"));
                            return true;
                        }
                        String stopId = stop.getId();
                        float yaw = player.getLocation().getYaw();
                        if (args.length > 2) {
                            try {
                                yaw = Float.parseFloat(args[2]);
                            }
                            catch (NumberFormatException e) {
                                player.sendMessage(this.plugin.getLanguageManager().getMessage("command.stop.setpoint_yaw_invalid"));
                                return true;
                            }
                        }
                        if (stopManager.setStopPoint(stopId, location, yaw)) {
                            player.sendMessage(this.plugin.getLanguageManager().getMessage("command.stop.setpoint_success", stopId, String.valueOf(yaw)));
                            break;
                        }
                        player.sendMessage(this.plugin.getLanguageManager().getMessage("command.stop.setpoint_fail"));
                        break;
                    }
                    default: {
                        this.sendStopHelpMessage(player);
                    }
                }
                break block157;
            }
            if (mainCommand.equals("reload")) {
                this.plugin.ensureDefaultConfigs();
                this.plugin.reloadConfig();
                lineManager.reload();
                stopManager.reload();
                this.plugin.getLanguageManager().loadLanguages();
                player.sendMessage(this.plugin.getLanguageManager().getMessage("plugin.reload"));
            } else {
                this.sendHelpMessage(player);
            }
        }
        return true;
    }

    private void sendHelpMessage(Player player) {
        player.sendMessage(this.plugin.getLanguageManager().getMessage("command.help_header"));
        player.sendMessage(this.plugin.getLanguageManager().getMessage("command.help_line"));
        player.sendMessage(this.plugin.getLanguageManager().getMessage("command.help_stop"));
        player.sendMessage(this.plugin.getLanguageManager().getMessage("command.help_reload"));
        player.sendMessage(this.plugin.getLanguageManager().getMessage("command.help_testendpoint"));
        player.sendMessage(this.plugin.getLanguageManager().getMessage("command.help_teststopinfo"));
    }

    private void sendLineHelpMessage(Player player) {
        player.sendMessage(this.plugin.getLanguageManager().getMessage("command.line.help_header"));
        player.sendMessage(this.plugin.getLanguageManager().getMessage("command.line.help_create"));
        player.sendMessage(this.plugin.getLanguageManager().getMessage("command.line.help_delete"));
        player.sendMessage(this.plugin.getLanguageManager().getMessage("command.line.help_list"));
        player.sendMessage(this.plugin.getLanguageManager().getMessage("command.line.help_setcolor"));
        player.sendMessage(this.plugin.getLanguageManager().getMessage("command.line.help_setterminus"));
        player.sendMessage(this.plugin.getLanguageManager().getMessage("command.line.help_addstop"));
        player.sendMessage(this.plugin.getLanguageManager().getMessage("command.line.help_removestop"));
        player.sendMessage(this.plugin.getLanguageManager().getMessage("command.line.help_stops"));
        player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)"&6/m line rename <line_id> <\u65b0\u540d\u79f0> &f- \u4fee\u6539\u7ebf\u8def\u7684\u663e\u793a\u540d\u79f0"));
    }

    private void sendStopHelpMessage(Player player) {
        player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)this.plugin.getLanguageManager().getMessage("command.stop.help_header")));
        player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)this.plugin.getLanguageManager().getMessage("command.stop.help_create")));
        player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)this.plugin.getLanguageManager().getMessage("command.stop.help_delete")));
        player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)this.plugin.getLanguageManager().getMessage("command.stop.help_list")));
        player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)this.plugin.getLanguageManager().getMessage("command.stop.help_setcorner1")));
        player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)this.plugin.getLanguageManager().getMessage("command.stop.help_setcorner2")));
        player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)this.plugin.getLanguageManager().getMessage("command.stop.help_setpoint")));
        player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)this.plugin.getLanguageManager().getMessage("command.stop.help_addtransfer")));
        player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)this.plugin.getLanguageManager().getMessage("command.stop.help_deltransfer")));
        player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)this.plugin.getLanguageManager().getMessage("command.stop.help_listtransfers")));
        player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)"&6/m stop settitle <stop_id> <title_type> <key> <value> &f- \u8bbe\u7f6e\u505c\u9760\u533a\u81ea\u5b9a\u4e49title"));
        player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)"&6/m stop deltitle <stop_id> <title_type> [key] &f- \u5220\u9664\u505c\u9760\u533a\u81ea\u5b9a\u4e49title"));
        player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)"&6/m stop listtitles <stop_id> &f- \u67e5\u770b\u505c\u9760\u533a\u6240\u6709\u81ea\u5b9a\u4e49title"));
        player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)"&6/m stop rename <stop_id> <\u65b0\u540d\u79f0> &f- \u4fee\u6539\u505c\u9760\u533a\u7684\u663e\u793a\u540d\u79f0"));
    }

    private boolean isValidTitleType(String titleType) {
        return titleType.equals("stop_continuous") || titleType.equals("arrive_stop") || titleType.equals("terminal_stop") || titleType.equals("departure");
    }

    private boolean isValidTitleKey(String key) {
        return key.equals("title") || key.equals("subtitle") || key.equals("actionbar");
    }
}

