/*
 * Decompiled with CFR 0.152.
 */
package org.cubexmc.metro.command;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.bukkit.util.StringUtil;
import org.cubexmc.metro.Metro;
import org.cubexmc.metro.manager.LineManager;
import org.cubexmc.metro.manager.StopManager;
import org.cubexmc.metro.model.Line;

public class MetroAdminTabCompleter
implements TabCompleter {
    private final Metro plugin;
    private static final List<String> MAIN_COMMANDS = Arrays.asList("line", "stop", "reload", "testendpoint", "teststopinfo");
    private static final List<String> LINE_SUBCOMMANDS = Arrays.asList("create", "delete", "list", "setcolor", "setterminus", "addstop", "delstop", "stops", "rename");
    private static final List<String> STOP_SUBCOMMANDS = Arrays.asList("create", "delete", "list", "setcorner1", "setcorner2", "setpoint", "addtransfer", "deltransfer", "listtransfers", "settitle", "deltitle", "listtitles", "rename");
    private static final List<String> COLOR_CODES = Arrays.asList("&0", "&1", "&2", "&3", "&4", "&5", "&6", "&7", "&8", "&9", "&a", "&b", "&c", "&d", "&e", "&f");
    private static final List<String> TITLE_TYPES = Arrays.asList("stop_continuous", "arrive_stop", "terminal_stop", "departure");
    private static final List<String> TITLE_KEYS = Arrays.asList("title", "subtitle", "actionbar");

    public MetroAdminTabCompleter(Metro plugin) {
        this.plugin = plugin;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        String subCommand;
        if (!(sender instanceof Player)) {
            return Collections.emptyList();
        }
        Player player = (Player)sender;
        if (!player.hasPermission("metro.admin")) {
            return Collections.emptyList();
        }
        if (args.length == 1) {
            return this.getCompletions(args[0], MAIN_COMMANDS);
        }
        String mainCommand = args[0].toLowerCase();
        if (args.length == 2) {
            if ("line".equals(mainCommand)) {
                return this.getCompletions(args[1], LINE_SUBCOMMANDS);
            }
            if ("stop".equals(mainCommand)) {
                return this.getCompletions(args[1], STOP_SUBCOMMANDS);
            }
            if ("teststopinfo".equals(mainCommand)) {
                return this.getLineIds();
            }
        }
        if (args.length == 3) {
            if ("line".equals(mainCommand)) {
                subCommand = args[1].toLowerCase();
                if ("delete".equals(subCommand) || "setcolor".equals(subCommand) || "setterminus".equals(subCommand) || "addstop".equals(subCommand) || "delstop".equals(subCommand) || "stops".equals(subCommand) || "rename".equals(subCommand)) {
                    return this.getLineIds();
                }
            } else if ("stop".equals(mainCommand)) {
                subCommand = args[1].toLowerCase();
                if ("delete".equals(subCommand) || "setcorner1".equals(subCommand) || "setcorner2".equals(subCommand) || "setpoint".equals(subCommand) || "addtransfer".equals(subCommand) || "deltransfer".equals(subCommand) || "listtransfers".equals(subCommand) || "settitle".equals(subCommand) || "deltitle".equals(subCommand) || "listtitles".equals(subCommand) || "rename".equals(subCommand)) {
                    return this.getStopIds();
                }
            } else if ("teststopinfo".equals(mainCommand)) {
                String lineId = args[1];
                return this.getStopsForLine(lineId);
            }
        }
        if (args.length == 4) {
            if ("line".equals(mainCommand)) {
                subCommand = args[1].toLowerCase();
                if ("setcolor".equals(subCommand)) {
                    return this.getCompletions(args[3], COLOR_CODES);
                }
                if ("addstop".equals(subCommand)) {
                    return this.getStopIds();
                }
            } else if ("stop".equals(mainCommand)) {
                subCommand = args[1].toLowerCase();
                if ("addtransfer".equals(subCommand) || "deltransfer".equals(subCommand)) {
                    return this.getLineIds();
                }
                if ("settitle".equals(subCommand) || "deltitle".equals(subCommand)) {
                    return this.getCompletions(args[3], TITLE_TYPES);
                }
            }
        }
        if (args.length == 5 && "stop".equals(mainCommand) && ("settitle".equals(subCommand = args[1].toLowerCase()) || "deltitle".equals(subCommand))) {
            return this.getCompletions(args[4], TITLE_KEYS);
        }
        return Collections.emptyList();
    }

    private List<String> getCompletions(String currentArg, List<String> options) {
        ArrayList<String> completions = new ArrayList<String>();
        StringUtil.copyPartialMatches((String)currentArg, options, completions);
        Collections.sort(completions);
        return completions;
    }

    private List<String> getLineIds() {
        LineManager lineManager = this.plugin.getLineManager();
        return lineManager.getAllLines().stream().map(Line::getId).collect(Collectors.toList());
    }

    private List<String> getStopIds() {
        StopManager stopManager = this.plugin.getStopManager();
        return new ArrayList<String>(stopManager.getAllStopIds());
    }

    private List<String> getStopsForLine(String lineId) {
        LineManager lineManager = this.plugin.getLineManager();
        Line line = lineManager.getLine(lineId);
        if (line == null) {
            return Collections.emptyList();
        }
        return line.getOrderedStopIds();
    }
}

