/*
 * Decompiled with CFR 0.152.
 */
package org.cubexmc.metro.listener;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Minecart;
import org.bukkit.entity.Player;
import org.bukkit.entity.Vehicle;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.vehicle.VehicleEnterEvent;
import org.bukkit.event.vehicle.VehicleExitEvent;
import org.bukkit.event.vehicle.VehicleMoveEvent;
import org.bukkit.plugin.Plugin;
import org.cubexmc.metro.Metro;
import org.cubexmc.metro.manager.LineManager;
import org.cubexmc.metro.manager.StopManager;
import org.cubexmc.metro.model.Line;
import org.cubexmc.metro.model.Stop;
import org.cubexmc.metro.train.ScoreboardManager;
import org.cubexmc.metro.train.TrainMovementTask;
import org.cubexmc.metro.util.LocationUtil;
import org.cubexmc.metro.util.SchedulerUtil;

public class VehicleListener
implements Listener {
    private final Metro plugin;
    private final Map<UUID, Object> trainMovementTasks = new HashMap<UUID, Object>();

    public VehicleListener(Metro plugin) {
        this.plugin = plugin;
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onVehicleEnter(VehicleEnterEvent event) {
        Line line;
        Vehicle vehicle = event.getVehicle();
        Entity passenger = event.getEntered();
        if (!(vehicle instanceof Minecart) || !(passenger instanceof Player)) {
            return;
        }
        Player player = (Player)passenger;
        Minecart minecart = (Minecart)vehicle;
        if (!"MetroMinecart".equals(minecart.getCustomName())) {
            return;
        }
        Location location = minecart.getLocation();
        StopManager stopManager = this.plugin.getStopManager();
        Stop stop = stopManager.getStopContainingLocation(location);
        if (stop != null && (line = this.findLineForStop(stop)) != null) {
            this.startTrainMovementTask(player, minecart, line, stop.getId());
        }
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onVehicleExit(VehicleExitEvent event) {
        Vehicle vehicle = event.getVehicle();
        LivingEntity passenger = event.getExited();
        if (!(vehicle instanceof Minecart) || !(passenger instanceof Player)) {
            return;
        }
        Player player = (Player)passenger;
        Minecart minecart = (Minecart)vehicle;
        if (!"MetroMinecart".equals(minecart.getCustomName())) {
            return;
        }
        ScoreboardManager.clearScoreboard(player);
        this.cancelTrainMovementTask(player.getUniqueId());
        Location location = minecart.getLocation();
        if (!this.isAtStop(location)) {
            Minecart finalMinecart = minecart;
            SchedulerUtil.regionRun((Plugin)this.plugin, location, () -> {
                if (finalMinecart != null && !finalMinecart.isDead()) {
                    finalMinecart.remove();
                }
            }, 1L, -1L);
            return;
        }
        int despawnDelay = this.plugin.getConfig().getInt("settings.cart_despawn_delay", 60);
        Minecart finalMinecart = minecart;
        SchedulerUtil.regionRun((Plugin)this.plugin, location, () -> {
            if (finalMinecart != null && !finalMinecart.isDead()) {
                finalMinecart.remove();
            }
        }, despawnDelay, -1L);
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onVehicleMove(VehicleMoveEvent event) {
        Vehicle vehicle = event.getVehicle();
        if (!(vehicle instanceof Minecart)) {
            return;
        }
        Minecart minecart = (Minecart)vehicle;
        if (!"MetroMinecart".equals(minecart.getCustomName())) {
            return;
        }
        Location location = minecart.getLocation();
        if (!LocationUtil.isOnRail(location)) {
            minecart.eject();
            minecart.remove();
        }
    }

    private void startTrainMovementTask(Player player, Minecart minecart, Line line, String stopId) {
        UUID playerId = player.getUniqueId();
        this.cancelTrainMovementTask(playerId);
        TrainMovementTask task = new TrainMovementTask(this.plugin, minecart, player, line.getId(), stopId);
        if (line.getNextStopId(stopId) == null) {
            return;
        }
        Object taskId = SchedulerUtil.globalRun((Plugin)this.plugin, task, 1L, 1L);
        task.setTaskId(taskId);
        this.trainMovementTasks.put(playerId, taskId);
    }

    private void cancelTrainMovementTask(UUID playerId) {
        Object taskId = this.trainMovementTasks.remove(playerId);
        if (taskId != null) {
            SchedulerUtil.cancelTask(taskId);
        }
    }

    private Line findLineForStop(Stop stop) {
        if (stop == null) {
            return null;
        }
        LineManager lineManager = this.plugin.getLineManager();
        for (Line line : lineManager.getAllLines()) {
            if (!line.containsStop(stop.getId())) continue;
            return line;
        }
        return null;
    }

    private boolean isAtStop(Location location) {
        StopManager stopManager = this.plugin.getStopManager();
        return stopManager.getStopContainingLocation(location) != null;
    }
}

