/*
 * Decompiled with CFR 0.152.
 */
package org.cubexmc.metro.util;

import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.util.Vector;

public class LocationUtil {
    public static String locationToString(Location location) {
        if (location == null || location.getWorld() == null) {
            return null;
        }
        return String.format("%s,%d,%d,%d", location.getWorld().getName(), location.getBlockX(), location.getBlockY(), location.getBlockZ());
    }

    public static Location stringToLocation(String locationStr) {
        if (locationStr == null || locationStr.isEmpty()) {
            return null;
        }
        String[] parts = locationStr.split(",");
        if (parts.length < 4) {
            return null;
        }
        World world = Bukkit.getWorld((String)parts[0]);
        if (world == null) {
            return null;
        }
        try {
            int x = Integer.parseInt(parts[1]);
            int y = Integer.parseInt(parts[2]);
            int z = Integer.parseInt(parts[3]);
            return new Location(world, (double)x, (double)y, (double)z);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public static boolean isRail(Location location) {
        if (location == null) {
            return false;
        }
        Block block = location.getBlock();
        return block.getType().name().contains("RAIL");
    }

    public static boolean isOnRail(Location location) {
        if (location == null) {
            return false;
        }
        if (LocationUtil.isRail(location)) {
            return true;
        }
        Location belowLocation = location.clone().subtract(0.0, 1.0, 0.0);
        return LocationUtil.isRail(belowLocation);
    }

    public static boolean isPoweredRail(Location location) {
        if (location == null) {
            return false;
        }
        Block block = location.getBlock();
        return block.getType() == Material.POWERED_RAIL;
    }

    public static Vector getDirectionVector(Location from, Location to) {
        return to.toVector().subtract(from.toVector()).normalize();
    }
}

