/*
 * Decompiled with CFR 0.152.
 */
package org.cubexmc.metro.util;

import io.papermc.paper.threadedregions.scheduler.AsyncScheduler;
import io.papermc.paper.threadedregions.scheduler.EntityScheduler;
import io.papermc.paper.threadedregions.scheduler.GlobalRegionScheduler;
import io.papermc.paper.threadedregions.scheduler.RegionScheduler;
import io.papermc.paper.threadedregions.scheduler.ScheduledTask;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Server;
import org.bukkit.entity.Entity;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;

public class SchedulerUtil {
    public static boolean isFolia() {
        try {
            Class.forName("io.papermc.paper.threadedregions.RegionizedServer");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public static Object globalRun(Plugin plugin, Runnable task, long delay, long period) {
        delay = Math.max(0L, delay);
        if (SchedulerUtil.isFolia()) {
            Server server = Bukkit.getServer();
            GlobalRegionScheduler globbalScheduler = server.getGlobalRegionScheduler();
            Consumer<ScheduledTask> foliaTask = scheduledTask -> task.run();
            if (delay == 0L) {
                return globbalScheduler.run(plugin, foliaTask);
            }
            if (period < 0L) {
                return globbalScheduler.runDelayed(plugin, foliaTask, delay);
            }
            return globbalScheduler.runAtFixedRate(plugin, foliaTask, delay, period);
        }
        if (delay == 0L) {
            return Bukkit.getScheduler().runTask(plugin, task);
        }
        if (period < 0L) {
            return Bukkit.getScheduler().runTaskLater(plugin, task, delay);
        }
        return Bukkit.getScheduler().runTaskTimer(plugin, task, delay, period);
    }

    public static void cancelTask(Object task) {
        if (task == null) {
            return;
        }
        try {
            if (SchedulerUtil.isFolia()) {
                if (task instanceof ScheduledTask) {
                    ((ScheduledTask)task).cancel();
                }
            } else if (task instanceof BukkitTask) {
                ((BukkitTask)task).cancel();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static Object entityRun(Plugin plugin, Entity entity, Runnable task, long delay, long period) {
        delay = Math.max(0L, delay);
        if (SchedulerUtil.isFolia()) {
            Consumer foliaTask;
            EntityScheduler entityScheduler = entity.getScheduler();
            if (task instanceof Runnable) {
                foliaTask = scheduledTask -> task.run();
            } else if (task instanceof Consumer) {
                foliaTask = (Consumer)((Object)task);
            } else {
                throw new IllegalArgumentException("Task must be either Runnable or Consumer<ScheduledTask>");
            }
            Runnable retiredCallback = () -> plugin.getLogger().fine("Entity scheduler task cancelled: entity no longer exists");
            if (delay == 0L) {
                return entityScheduler.run(plugin, foliaTask, retiredCallback);
            }
            if (period < 0L) {
                return entityScheduler.runDelayed(plugin, foliaTask, retiredCallback, delay);
            }
            return entityScheduler.runAtFixedRate(plugin, foliaTask, retiredCallback, delay, period);
        }
        if (delay == 0L) {
            return Bukkit.getScheduler().runTask(plugin, task);
        }
        if (period < 0L) {
            return Bukkit.getScheduler().runTaskLater(plugin, task, delay);
        }
        return Bukkit.getScheduler().runTaskTimer(plugin, task, delay, period);
    }

    public static Object regionRun(Plugin plugin, Location location, Runnable task, long delay, long period) {
        delay = Math.max(0L, delay);
        if (SchedulerUtil.isFolia()) {
            Server server = Bukkit.getServer();
            RegionScheduler regionScheduler = server.getRegionScheduler();
            Consumer<ScheduledTask> foliaTask = scheduledTask -> task.run();
            if (delay == 0L) {
                return regionScheduler.run(plugin, location, foliaTask);
            }
            if (period < 0L) {
                return regionScheduler.runDelayed(plugin, location, foliaTask, delay);
            }
            return regionScheduler.runAtFixedRate(plugin, location, foliaTask, delay, period);
        }
        if (delay == 0L) {
            return Bukkit.getScheduler().runTask(plugin, task);
        }
        if (period < 0L) {
            return Bukkit.getScheduler().runTaskLater(plugin, task, delay);
        }
        return Bukkit.getScheduler().runTaskTimer(plugin, task, delay, period);
    }

    public static void asyncRun(Plugin plugin, Runnable task, long delay) {
        delay = Math.max(0L, delay);
        if (SchedulerUtil.isFolia()) {
            Server server = Bukkit.getServer();
            AsyncScheduler asyncScheduler = server.getAsyncScheduler();
            Consumer<ScheduledTask> foliaTask = scheduledTask -> task.run();
            if (delay <= 0L) {
                asyncScheduler.runNow(plugin, foliaTask);
            } else {
                asyncScheduler.runDelayed(plugin, foliaTask, delay * 50L, TimeUnit.MILLISECONDS);
            }
        } else {
            Bukkit.getScheduler().runTaskLaterAsynchronously(plugin, task, delay);
        }
    }
}

