/*
 * Decompiled with CFR 0.152.
 */
package com.example.griefprevention3d.claims;

import com.example.griefprevention3d.GriefPrevention3D;
import com.example.griefprevention3d.claims.Claim;
import com.example.griefprevention3d.storage.PlayerDataProvider;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class ClaimBlockManager {
    private final GriefPrevention3D plugin;
    private final PlayerDataProvider playerDataProvider;
    private final int accrualAmount;

    public ClaimBlockManager(GriefPrevention3D plugin, PlayerDataProvider playerDataProvider) {
        this.plugin = plugin;
        this.playerDataProvider = playerDataProvider;
        this.accrualAmount = plugin.getConfig().getInt("claim-block-accrual.amount");
    }

    public int getMaxClaimBlocks(Player player) {
        int maxBlocks = this.plugin.getConfig().getInt("max-claim-blocks-by-permission.default");
        for (String permissionKey : this.plugin.getConfig().getConfigurationSection("max-claim-blocks-by-permission").getKeys(false)) {
            int amount;
            if (permissionKey.equals("default") || !player.hasPermission(permissionKey) || (amount = this.plugin.getConfig().getInt("max-claim-blocks-by-permission." + permissionKey)) <= maxBlocks) continue;
            maxBlocks = amount;
        }
        return maxBlocks;
    }

    public void startAccrualTask() {
        Bukkit.getScheduler().runTaskTimer((Plugin)this.plugin, () -> {
            for (Player player : Bukkit.getOnlinePlayers()) {
                int maxBlocks;
                int currentBlocks = this.playerDataProvider.getClaimBlocks(player.getUniqueId());
                if (currentBlocks >= (maxBlocks = this.getMaxClaimBlocks(player))) continue;
                int newAmount = Math.min(currentBlocks + this.accrualAmount, maxBlocks);
                this.playerDataProvider.setClaimBlocks(player.getUniqueId(), newAmount);
            }
        }, 72000L, 72000L);
    }

    public boolean hasEnoughClaimBlocks(Player player, int amount) {
        return this.playerDataProvider.getClaimBlocks(player.getUniqueId()) >= amount;
    }

    public int getClaimBlocks(UUID playerID) {
        return this.playerDataProvider.getClaimBlocks(playerID);
    }

    public void addClaimBlocks(UUID playerID, int amount) {
        int currentBlocks = this.playerDataProvider.getClaimBlocks(playerID);
        this.playerDataProvider.setClaimBlocks(playerID, currentBlocks + amount);
    }

    public void removeClaimBlocks(UUID playerID, int amount) {
        int currentBlocks = this.playerDataProvider.getClaimBlocks(playerID);
        this.playerDataProvider.setClaimBlocks(playerID, currentBlocks - amount);
    }

    public int getClaimVolume(Claim claim) {
        return (int)(Math.abs(claim.getCorner1().getX() - claim.getCorner2().getX()) + 1.0) * (int)(Math.abs(claim.getCorner1().getY() - claim.getCorner2().getY()) + 1.0) * (int)(Math.abs(claim.getCorner1().getZ() - claim.getCorner2().getZ()) + 1.0);
    }
}

