/*
 * Decompiled with CFR 0.152.
 */
package com.example.griefprevention3d.fawe;

import com.example.griefprevention3d.GriefPrevention3D;
import com.example.griefprevention3d.claims.Claim;
import com.example.griefprevention3d.claims.ClaimManager;
import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.extent.clipboard.BlockArrayClipboard;
import com.sk89q.worldedit.extent.clipboard.Clipboard;
import com.sk89q.worldedit.extent.clipboard.io.BuiltInClipboardFormat;
import com.sk89q.worldedit.extent.clipboard.io.ClipboardFormats;
import com.sk89q.worldedit.extent.clipboard.io.ClipboardReader;
import com.sk89q.worldedit.extent.clipboard.io.ClipboardWriter;
import com.sk89q.worldedit.function.operation.ForwardExtentCopy;
import com.sk89q.worldedit.function.operation.Operation;
import com.sk89q.worldedit.function.operation.Operations;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.regions.CuboidRegion;
import com.sk89q.worldedit.regions.Region;
import com.sk89q.worldedit.world.World;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.plugin.Plugin;

public class FAWEIntegration {
    private final GriefPrevention3D plugin;
    private final File schematicsDir;

    public FAWEIntegration(GriefPrevention3D plugin) {
        this.plugin = plugin;
        this.schematicsDir = new File(plugin.getDataFolder(), "schematics");
        if (!this.schematicsDir.exists()) {
            this.schematicsDir.mkdirs();
        }
    }

    public CompletableFuture<Void> saveAllClaims(ClaimManager claimManager, org.bukkit.World world) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
            ArrayList<CompletableFuture<Void>> futures = new ArrayList<CompletableFuture<Void>>();
            try {
                List<Claim> claimsToSave = claimManager.getClaimsByWorld(world);
                this.plugin.getLogger().info("Found " + claimsToSave.size() + " claims to save in world: " + world.getName());
                File[] existingSchematicFiles = this.schematicsDir.listFiles((dir, name) -> name.endsWith(".schem"));
                Set activeClaimIds = claimsToSave.stream().map(claim -> claim.getClaimID().toString()).collect(Collectors.toSet());
                if (existingSchematicFiles != null) {
                    for (File schematicFile : existingSchematicFiles) {
                        String fileName = schematicFile.getName();
                        String claimIdFromFile = fileName.substring(0, fileName.lastIndexOf("."));
                        if (activeClaimIds.contains(claimIdFromFile)) continue;
                        if (schematicFile.delete()) {
                            this.plugin.getLogger().info("Deleted old schematic file: " + fileName);
                            continue;
                        }
                        this.plugin.getLogger().warning("Failed to delete old schematic file: " + fileName);
                    }
                }
                for (Claim claim2 : claimsToSave) {
                    if (claim2.getCorner1() == null || claim2.getCorner1().getWorld() == null) continue;
                    futures.add(this.saveClaim(claim2, world));
                }
                CompletableFuture.allOf(futures.toArray(new CompletableFuture[0])).thenRun(() -> future.complete(null));
            }
            catch (Exception e) {
                this.plugin.getLogger().severe("Error in saveAllClaims for world " + world.getName() + ": " + e.getMessage());
                e.printStackTrace();
                future.completeExceptionally(e);
            }
        });
        return future;
    }

    private CompletableFuture<Void> saveClaim(Claim claim, org.bukkit.World bukkitWorld) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
            try {
                this.plugin.getLogger().info("Attempting to save claim: " + String.valueOf(claim.getClaimID()) + " in world: " + bukkitWorld.getName());
                World weWorld = BukkitAdapter.adapt((org.bukkit.World)bukkitWorld);
                BlockVector3 pos1 = BukkitAdapter.asBlockVector((Location)claim.getCorner1());
                BlockVector3 pos2 = BukkitAdapter.asBlockVector((Location)claim.getCorner2());
                CuboidRegion region = new CuboidRegion(weWorld, pos1, pos2);
                BlockArrayClipboard clipboard = new BlockArrayClipboard((Region)region);
                clipboard.setOrigin(region.getMinimumPoint());
                this.plugin.getLogger().info("Creating EditSession for claim: " + String.valueOf(claim.getClaimID()));
                try (EditSession editSession = WorldEdit.getInstance().newEditSession(weWorld);){
                    this.plugin.getLogger().info("EditSession created for claim: " + String.valueOf(claim.getClaimID()));
                    ForwardExtentCopy copy = new ForwardExtentCopy((Extent)editSession, (Region)region, (Extent)clipboard, clipboard.getOrigin());
                    copy.setCopyingEntities(false);
                    Operations.complete((Operation)copy);
                    this.plugin.getLogger().info("Copy operation completed for claim: " + String.valueOf(claim.getClaimID()));
                }
                Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
                    try {
                        File schematicFile = new File(this.schematicsDir, String.valueOf(claim.getClaimID()) + ".schem");
                        this.plugin.getLogger().info("Writing schematic file for claim: " + String.valueOf(claim.getClaimID()) + " to: " + schematicFile.getAbsolutePath());
                        try (ClipboardWriter writer = BuiltInClipboardFormat.SPONGE_SCHEMATIC.getWriter((OutputStream)new FileOutputStream(schematicFile));){
                            writer.write((Clipboard)clipboard);
                        }
                        this.plugin.getLogger().info("Schematic file written successfully for claim: " + String.valueOf(claim.getClaimID()));
                        future.complete(null);
                    }
                    catch (IOException e) {
                        this.plugin.getLogger().severe("Error writing schematic file for claim " + String.valueOf(claim.getClaimID()) + ": " + e.getMessage());
                        e.printStackTrace();
                        future.completeExceptionally(e);
                    }
                });
            }
            catch (Exception e) {
                this.plugin.getLogger().severe("Error creating or copying claim " + String.valueOf(claim.getClaimID()) + ": " + e.getMessage());
                e.printStackTrace();
                future.completeExceptionally(e);
            }
        });
        return future;
    }

    public CompletableFuture<Void> loadAllClaims(ClaimManager claimManager, org.bukkit.World bukkitWorld) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
            World world = BukkitAdapter.adapt((org.bukkit.World)bukkitWorld);
            for (Claim claim : claimManager.getAllClaims()) {
                this.plugin.getLogger().info("Loading claim: " + String.valueOf(claim.getClaimID()));
                try {
                    File schematicFile = new File(this.schematicsDir, String.valueOf(claim.getClaimID()) + ".schem");
                    if (schematicFile.exists()) {
                        this.plugin.getLogger().info("Schematic file found: " + schematicFile.getPath());
                        ClipboardReader reader = ClipboardFormats.findByFile((File)schematicFile).getReader((InputStream)new FileInputStream(schematicFile));
                        Clipboard clipboard = reader.read();
                        Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
                            try (EditSession editSession = WorldEdit.getInstance().newEditSession(world);){
                                BlockVector3 min = BlockVector3.at((double)Math.min(claim.getCorner1().getX(), claim.getCorner2().getX()), (double)Math.min(claim.getCorner1().getY(), claim.getCorner2().getY()), (double)Math.min(claim.getCorner1().getZ(), claim.getCorner2().getZ()));
                                this.plugin.getLogger().info("Pasting schematic to: " + min.toString());
                                clipboard.paste((Extent)editSession, min, true);
                                editSession.flushSession();
                                this.plugin.getLogger().info("Paste operation completed for claim: " + String.valueOf(claim.getClaimID()));
                            }
                            catch (Exception e) {
                                this.plugin.getLogger().severe("Error pasting schematic for claim " + String.valueOf(claim.getClaimID()) + ": " + e.getMessage());
                                e.printStackTrace();
                            }
                        });
                        continue;
                    }
                    this.plugin.getLogger().warning("Schematic file not found for claim: " + String.valueOf(claim.getClaimID()));
                }
                catch (IOException e) {
                    this.plugin.getLogger().severe("Error loading claim " + String.valueOf(claim.getClaimID()) + ": " + e.getMessage());
                    e.printStackTrace();
                }
            }
            future.complete(null);
        });
        return future;
    }
}

