/*
 * Decompiled with CFR 0.152.
 */
package com.example.griefprevention3d.listeners;

import com.example.griefprevention3d.GriefPrevention3D;
import com.example.griefprevention3d.claims.Claim;
import com.example.griefprevention3d.claims.ClaimBlockManager;
import com.example.griefprevention3d.claims.ClaimManager;
import com.example.griefprevention3d.ui.VisualizationManager;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerItemHeldEvent;
import org.bukkit.inventory.ItemStack;

public class ClaimToolListener
implements Listener {
    private final Map<UUID, Location> corner1 = new HashMap<UUID, Location>();
    private final Map<UUID, Location> corner2 = new HashMap<UUID, Location>();
    private final VisualizationManager visualizationManager;
    private final ClaimManager claimManager;
    private final ClaimBlockManager claimBlockManager;
    private final Map<UUID, ResizingData> resizingMode = new HashMap<UUID, ResizingData>();
    private final GriefPrevention3D plugin;

    public ClaimToolListener(VisualizationManager visualizationManager, ClaimManager claimManager, ClaimBlockManager claimBlockManager, GriefPrevention3D plugin) {
        this.visualizationManager = visualizationManager;
        this.claimManager = claimManager;
        this.claimBlockManager = claimBlockManager;
        this.plugin = plugin;
    }

    @EventHandler
    public void onPlayerInteract(PlayerInteractEvent event) {
        Player player = event.getPlayer();
        if (event.getItem() != null && event.getItem().getType() == Material.GOLDEN_SHOVEL) {
            this.plugin.getLogger().info("Player " + player.getName() + " interacted with golden shovel. Action: " + event.getAction().name());
            if (event.getClickedBlock() == null) {
                this.plugin.getLogger().info("Clicked block is null.");
                return;
            }
            Location loc = event.getClickedBlock().getLocation();
            this.plugin.getLogger().info("Clicked block location: " + loc.toString());
            if (event.getAction().isLeftClick()) {
                if (this.resizingMode.containsKey(player.getUniqueId())) {
                    this.plugin.getLogger().info("Player " + player.getName() + " is in resizing mode, setting new corner.");
                    ResizingData resizingData = this.resizingMode.get(player.getUniqueId());
                    Claim claim = resizingData.claim;
                    int oldVolume = this.claimBlockManager.getClaimVolume(claim);
                    if (resizingData.corner == 1) {
                        claim.setCorner1(loc);
                    } else {
                        claim.setCorner2(loc);
                    }
                    int newVolume = this.claimBlockManager.getClaimVolume(claim);
                    int diff = newVolume - oldVolume;
                    if (diff > 0 && !this.claimBlockManager.hasEnoughClaimBlocks(player, diff)) {
                        player.sendMessage(String.valueOf(ChatColor.RED) + "You do not have enough claim blocks to resize this claim.");
                        if (resizingData.corner == 1) {
                            claim.setCorner1(resizingData.claim.getCorner1());
                        } else {
                            claim.setCorner2(resizingData.claim.getCorner2());
                        }
                        this.plugin.getLogger().warning("Player " + player.getName() + " does not have enough claim blocks to resize.");
                        return;
                    }
                    this.claimBlockManager.addClaimBlocks(player.getUniqueId(), oldVolume);
                    this.claimBlockManager.removeClaimBlocks(player.getUniqueId(), newVolume);
                    this.resizingMode.remove(player.getUniqueId());
                    player.sendMessage(String.valueOf(ChatColor.GREEN) + "Claim resized.");
                    this.visualizationManager.hideCorner(player, resizingData.claim.getCorner1());
                    this.visualizationManager.hideCorner(player, resizingData.claim.getCorner2());
                    this.visualizationManager.showClaimBoundaries(player, claim);
                    event.setCancelled(true);
                    this.plugin.getLogger().info("Claim " + String.valueOf(claim.getClaimID()) + " resized by " + player.getName() + ".");
                    return;
                }
                List<Claim> playerClaims = this.claimManager.getPlayerClaims(player);
                this.plugin.getLogger().info("Player " + player.getName() + " has " + playerClaims.size() + " claims.");
                for (Claim claim : playerClaims) {
                    this.plugin.getLogger().info("Checking claim " + String.valueOf(claim.getClaimID()) + " for resizing.");
                    if (claim.getCorner1().getWorld() == null || !claim.getCorner1().getWorld().getName().equals(loc.getWorld().getName())) {
                        this.plugin.getLogger().info("Claim " + String.valueOf(claim.getClaimID()) + " is in a different world or has null world.");
                        continue;
                    }
                    double dist1 = claim.getCorner1().distanceSquared(loc);
                    double dist2 = claim.getCorner2().distanceSquared(loc);
                    this.plugin.getLogger().info("Distance to corner1: " + dist1 + ", Distance to corner2: " + dist2);
                    if (dist1 < 4.0) {
                        this.resizingMode.put(player.getUniqueId(), new ResizingData(claim, 1));
                        player.sendMessage(String.valueOf(ChatColor.GREEN) + "Resizing claim. Left-click to set the new position for this corner.");
                        event.setCancelled(true);
                        this.plugin.getLogger().info("Resizing mode activated for corner 1 of claim " + String.valueOf(claim.getClaimID()) + ".");
                        return;
                    }
                    if (!(dist2 < 4.0)) continue;
                    this.resizingMode.put(player.getUniqueId(), new ResizingData(claim, 2));
                    player.sendMessage(String.valueOf(ChatColor.GREEN) + "Resizing claim. Left-click to set the new position for this corner.");
                    event.setCancelled(true);
                    this.plugin.getLogger().info("Resizing mode activated for corner 2 of claim " + String.valueOf(claim.getClaimID()) + ".");
                    return;
                }
            } else if (event.getAction().isRightClick()) {
                if (event.getClickedBlock() == null) {
                    return;
                }
                if (!this.corner1.containsKey(player.getUniqueId()) || this.corner2.containsKey(player.getUniqueId())) {
                    this.corner1.put(player.getUniqueId(), loc);
                    this.corner2.remove(player.getUniqueId());
                    player.sendMessage(String.valueOf(ChatColor.GREEN) + "First corner set.");
                } else {
                    this.corner2.put(player.getUniqueId(), loc);
                    player.sendMessage(String.valueOf(ChatColor.GREEN) + "Second corner set. Type /claim create to create your claim.");
                    this.visualizationManager.showClaimBoundaries(player, this.corner1.get(player.getUniqueId()), this.corner2.get(player.getUniqueId()));
                }
                event.setCancelled(true);
            }
        }
    }

    public Location getCorner1(Player player) {
        return this.corner1.get(player.getUniqueId());
    }

    public Location getCorner2(Player player) {
        return this.corner2.get(player.getUniqueId());
    }

    public void clearCorners(Player player) {
        this.corner1.remove(player.getUniqueId());
        this.corner2.remove(player.getUniqueId());
    }

    @EventHandler
    public void onPlayerItemHeld(PlayerItemHeldEvent event) {
        Player player = event.getPlayer();
        ItemStack newItem = player.getInventory().getItem(event.getNewSlot());
        ItemStack oldItem = player.getInventory().getItem(event.getPreviousSlot());
        if (newItem != null && newItem.getType() == Material.GOLDEN_SHOVEL) {
            for (Claim claim : this.claimManager.getPlayerClaims(player)) {
                this.visualizationManager.showCorner(player, claim.getCorner1());
                this.visualizationManager.showCorner(player, claim.getCorner2());
            }
        }
        if (oldItem != null && oldItem.getType() == Material.GOLDEN_SHOVEL) {
            for (Claim claim : this.claimManager.getPlayerClaims(player)) {
                this.visualizationManager.hideCorner(player, claim.getCorner1());
                this.visualizationManager.hideCorner(player, claim.getCorner2());
            }
            if (this.corner1.containsKey(player.getUniqueId()) || this.resizingMode.containsKey(player.getUniqueId())) {
                this.clearCorners(player);
                this.resizingMode.remove(player.getUniqueId());
                player.sendMessage(String.valueOf(ChatColor.YELLOW) + "Claim selection/resizing cancelled.");
            }
        }
    }

    private static class ResizingData {
        public final Claim claim;
        public final int corner;

        public ResizingData(Claim claim, int corner) {
            this.claim = claim;
            this.corner = corner;
        }
    }
}

