/*
 * Decompiled with CFR 0.152.
 */
package com.example.griefprevention3d.storage;

import com.example.griefprevention3d.GriefPrevention3D;
import com.example.griefprevention3d.libs.gson.Gson;
import com.example.griefprevention3d.libs.gson.GsonBuilder;
import com.example.griefprevention3d.libs.gson.reflect.TypeToken;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

public class PlayerDataProvider {
    private final File playerDataFile;
    private final Gson gson;
    private Map<UUID, Integer> claimBlocks = new HashMap<UUID, Integer>();

    public PlayerDataProvider(GriefPrevention3D plugin) {
        this.playerDataFile = new File(plugin.getDataFolder(), "playerdata.json");
        this.gson = new GsonBuilder().setPrettyPrinting().create();
        this.loadPlayerData();
    }

    public void loadPlayerData() {
        if (!this.playerDataFile.exists()) {
            return;
        }
        try (FileReader reader = new FileReader(this.playerDataFile);){
            Type type = new TypeToken<Map<UUID, Integer>>(this){}.getType();
            this.claimBlocks = (Map)this.gson.fromJson((Reader)reader, type);
            if (this.claimBlocks == null) {
                this.claimBlocks = new HashMap<UUID, Integer>();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void savePlayerData() {
        try (FileWriter writer = new FileWriter(this.playerDataFile);){
            this.gson.toJson(this.claimBlocks, (Appendable)writer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public int getClaimBlocks(UUID playerID) {
        return this.claimBlocks.getOrDefault(playerID, ((GriefPrevention3D)GriefPrevention3D.getPlugin(GriefPrevention3D.class)).getConfig().getInt("new-player-claim-blocks"));
    }

    public void setClaimBlocks(UUID playerID, int amount) {
        this.claimBlocks.put(playerID, amount);
    }
}

