/*
 * Decompiled with CFR 0.152.
 */
package com.example.griefprevention3d;

import com.example.griefprevention3d.claims.ClaimBlockManager;
import com.example.griefprevention3d.claims.ClaimManager;
import com.example.griefprevention3d.commands.ClaimCommand;
import com.example.griefprevention3d.fawe.FAWEIntegration;
import com.example.griefprevention3d.listeners.ClaimListener;
import com.example.griefprevention3d.listeners.ClaimToolListener;
import com.example.griefprevention3d.listeners.ClaimVisualizerListener;
import com.example.griefprevention3d.storage.PlayerDataProvider;
import com.example.griefprevention3d.storage.StorageManager;
import com.example.griefprevention3d.ui.VisualizationManager;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandExecutor;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class GriefPrevention3D
extends JavaPlugin {
    private ClaimManager claimManager;
    private StorageManager storageManager;
    private FAWEIntegration faweIntegration;
    private VisualizationManager visualizationManager;
    private PlayerDataProvider playerDataProvider;
    private ClaimBlockManager claimBlockManager;

    public void onEnable() {
        this.saveDefaultConfig();
        this.claimManager = new ClaimManager();
        this.storageManager = new StorageManager(this);
        this.faweIntegration = new FAWEIntegration(this);
        this.visualizationManager = new VisualizationManager();
        this.playerDataProvider = new PlayerDataProvider(this);
        this.claimBlockManager = new ClaimBlockManager(this, this.playerDataProvider);
        this.getServer().getScheduler().runTask((Plugin)this, () -> this.storageManager.loadClaims(this.claimManager));
        this.claimBlockManager.startAccrualTask();
        ClaimToolListener claimToolListener = new ClaimToolListener(this.visualizationManager, this.claimManager, this.claimBlockManager);
        this.getCommand("claim").setExecutor((CommandExecutor)new ClaimCommand(this, this.claimManager, claimToolListener, this.faweIntegration, this.claimBlockManager));
        this.getServer().getPluginManager().registerEvents((Listener)new ClaimListener(this.claimManager), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)claimToolListener, (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new ClaimVisualizerListener(this.claimManager, this.visualizationManager), (Plugin)this);
        this.getLogger().info("GriefPrevention3D has been enabled!");
    }

    public void onDisable() {
        this.storageManager.saveClaims(this.claimManager);
        this.playerDataProvider.savePlayerData();
        this.getLogger().info("GriefPrevention3D has been disabled!");
    }

    public ClaimManager getClaimManager() {
        return this.claimManager;
    }

    public StorageManager getStorageManager() {
        return this.storageManager;
    }

    public FAWEIntegration getFaweIntegration() {
        return this.faweIntegration;
    }

    public VisualizationManager getVisualizationManager() {
        return this.visualizationManager;
    }

    public String getMessage(String path) {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)this.getConfig().getString(path));
    }
}

