/*
 * Decompiled with CFR 0.152.
 */
package com.example.griefprevention3d.claims;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Location;

public class Claim {
    private final UUID claimID;
    private final UUID owner;
    private Location corner1;
    private Location corner2;
    private final Map<UUID, TrustLevel> trustedPlayers = new HashMap<UUID, TrustLevel>();
    private final List<Claim> children = new ArrayList<Claim>();
    private Claim parent;

    public Claim(UUID owner, Location corner1, Location corner2) {
        this.claimID = UUID.randomUUID();
        this.owner = owner;
        this.corner1 = corner1;
        this.corner2 = corner2;
    }

    public UUID getClaimID() {
        return this.claimID;
    }

    public UUID getOwner() {
        return this.owner;
    }

    public Location getCorner1() {
        return this.corner1;
    }

    public void setCorner1(Location corner1) {
        this.corner1 = corner1;
    }

    public Location getCorner2() {
        return this.corner2;
    }

    public void setCorner2(Location corner2) {
        this.corner2 = corner2;
    }

    public Map<UUID, TrustLevel> getTrustedPlayers() {
        return this.trustedPlayers;
    }

    public List<Claim> getChildren() {
        return this.children;
    }

    public Claim getParent() {
        return this.parent;
    }

    public void setParent(Claim parent) {
        this.parent = parent;
    }

    public boolean isInside(Location location) {
        double x1 = Math.min(this.corner1.getX(), this.corner2.getX());
        double y1 = Math.min(this.corner1.getY(), this.corner2.getY());
        double z1 = Math.min(this.corner1.getZ(), this.corner2.getZ());
        double x2 = Math.max(this.corner1.getX(), this.corner2.getX());
        double y2 = Math.max(this.corner1.getY(), this.corner2.getY());
        double z2 = Math.max(this.corner1.getZ(), this.corner2.getZ());
        return location.getX() >= x1 && location.getX() <= x2 && location.getY() >= y1 && location.getY() <= y2 && location.getZ() >= z1 && location.getZ() <= z2;
    }

    public boolean hasPermission(UUID player, TrustLevel level) {
        if (this.owner.equals(player)) {
            return true;
        }
        TrustLevel playerTrustLevel = this.trustedPlayers.get(player);
        if (playerTrustLevel != null) {
            return playerTrustLevel.ordinal() >= level.ordinal();
        }
        if (this.parent != null) {
            return this.parent.hasPermission(player, level);
        }
        return false;
    }

    public static enum TrustLevel {
        ACCESS,
        CONTAINER,
        BUILD,
        MANAGER;

    }
}

