/*
 * Decompiled with CFR 0.152.
 */
package com.example.griefprevention3d.claims;

import com.example.griefprevention3d.claims.Claim;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Player;

public class ClaimManager {
    private final List<Claim> claims = new ArrayList<Claim>();

    public Claim createClaim(Player owner, Location corner1, Location corner2) {
        Claim claim = new Claim(owner.getUniqueId(), corner1, corner2);
        this.claims.add(claim);
        return claim;
    }

    public void deleteClaim(Claim claim) {
        this.claims.remove(claim);
    }

    public Claim getClaimAt(Location location) {
        for (Claim claim : this.claims) {
            if (!claim.isInside(location)) continue;
            return claim;
        }
        return null;
    }

    public List<Claim> getPlayerClaims(Player player) {
        return this.claims.stream().filter(claim -> claim.getOwner().equals(player.getUniqueId())).collect(Collectors.toList());
    }

    public List<Claim> getAllClaims() {
        return new ArrayList<Claim>(this.claims);
    }

    public void addClaim(Claim claim) {
        this.claims.add(claim);
    }

    public List<Claim> getClaimsByWorld(World world) {
        return this.claims.stream().filter(claim -> claim.getCorner1() != null && claim.getCorner1().getWorld() != null && claim.getCorner1().getWorld().equals((Object)world)).collect(Collectors.toList());
    }
}

