/*
 * Decompiled with CFR 0.152.
 */
package com.example.griefprevention3d.fawe;

import com.example.griefprevention3d.GriefPrevention3D;
import com.example.griefprevention3d.claims.Claim;
import com.example.griefprevention3d.claims.ClaimManager;
import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.extent.clipboard.BlockArrayClipboard;
import com.sk89q.worldedit.extent.clipboard.Clipboard;
import com.sk89q.worldedit.extent.clipboard.io.BuiltInClipboardFormat;
import com.sk89q.worldedit.extent.clipboard.io.ClipboardFormats;
import com.sk89q.worldedit.extent.clipboard.io.ClipboardReader;
import com.sk89q.worldedit.extent.clipboard.io.ClipboardWriter;
import com.sk89q.worldedit.function.operation.ForwardExtentCopy;
import com.sk89q.worldedit.function.operation.Operation;
import com.sk89q.worldedit.function.operation.Operations;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.regions.CuboidRegion;
import com.sk89q.worldedit.regions.Region;
import com.sk89q.worldedit.world.World;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.plugin.Plugin;

public class FAWEIntegration {
    private final File schematicsDir;

    public FAWEIntegration(GriefPrevention3D plugin) {
        this.schematicsDir = new File(plugin.getDataFolder(), "schematics");
        if (!this.schematicsDir.exists()) {
            this.schematicsDir.mkdirs();
        }
    }

    public void saveAllClaims(ClaimManager claimManager, org.bukkit.World world) {
        ArrayList<CallSite> savedClaimIds = new ArrayList<CallSite>();
        for (Claim claim : claimManager.getClaimsByWorld(world)) {
            if (claim.getCorner1() == null || claim.getCorner1().getWorld() == null) continue;
            try {
                File schematicFile = new File(this.schematicsDir, String.valueOf(claim.getClaimID()) + ".schem");
                World weWorld = BukkitAdapter.adapt((org.bukkit.World)claim.getCorner1().getWorld());
                BlockVector3 pos1 = BukkitAdapter.asBlockVector((Location)claim.getCorner1());
                BlockVector3 pos2 = BukkitAdapter.asBlockVector((Location)claim.getCorner2());
                CuboidRegion region = new CuboidRegion(weWorld, pos1, pos2);
                BlockArrayClipboard clipboard = new BlockArrayClipboard((Region)region);
                clipboard.setOrigin(region.getMinimumPoint());
                try (EditSession editSession = WorldEdit.getInstance().newEditSession(weWorld);){
                    ForwardExtentCopy copy = new ForwardExtentCopy((Extent)editSession, (Region)region, (Extent)clipboard, clipboard.getOrigin());
                    copy.setCopyingEntities(false);
                    Operations.complete((Operation)copy);
                }
                try (ClipboardWriter writer = BuiltInClipboardFormat.SPONGE_SCHEMATIC.getWriter((OutputStream)new FileOutputStream(schematicFile));){
                    writer.write((Clipboard)clipboard);
                }
                savedClaimIds.add((CallSite)((Object)(String.valueOf(claim.getClaimID()) + ".schem")));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        File[] existingSchematics = this.schematicsDir.listFiles();
        if (existingSchematics != null) {
            for (File schematicFile : existingSchematics) {
                if (savedClaimIds.contains(schematicFile.getName())) continue;
                schematicFile.delete();
            }
        }
    }

    public CompletableFuture<Void> loadAllClaims(ClaimManager claimManager, org.bukkit.World bukkitWorld) {
        GriefPrevention3D plugin = (GriefPrevention3D)GriefPrevention3D.getPlugin(GriefPrevention3D.class);
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        Bukkit.getScheduler().runTask((Plugin)plugin, () -> {
            World world = BukkitAdapter.adapt((org.bukkit.World)bukkitWorld);
            for (Claim claim : claimManager.getAllClaims()) {
                plugin.getLogger().info("Loading claim: " + String.valueOf(claim.getClaimID()));
                try {
                    File schematicFile = new File(this.schematicsDir, String.valueOf(claim.getClaimID()) + ".schem");
                    if (schematicFile.exists()) {
                        plugin.getLogger().info("Schematic file found: " + schematicFile.getPath());
                        ClipboardReader reader = ClipboardFormats.findByFile((File)schematicFile).getReader((InputStream)new FileInputStream(schematicFile));
                        Clipboard clipboard = reader.read();
                        EditSession editSession = WorldEdit.getInstance().newEditSession(world);
                        try {
                            BlockVector3 min = BlockVector3.at((double)Math.min(claim.getCorner1().getX(), claim.getCorner2().getX()), (double)Math.min(claim.getCorner1().getY(), claim.getCorner2().getY()), (double)Math.min(claim.getCorner1().getZ(), claim.getCorner2().getZ()));
                            plugin.getLogger().info("Pasting schematic to: " + min.toString());
                            clipboard.paste((Extent)editSession, min, false);
                            editSession.flushSession();
                            plugin.getLogger().info("Paste operation completed for claim: " + String.valueOf(claim.getClaimID()));
                            continue;
                        }
                        finally {
                            if (editSession != null) {
                                editSession.close();
                            }
                            continue;
                        }
                    }
                    plugin.getLogger().warning("Schematic file not found for claim: " + String.valueOf(claim.getClaimID()));
                }
                catch (IOException e) {
                    plugin.getLogger().severe("Error loading claim " + String.valueOf(claim.getClaimID()) + ": " + e.getMessage());
                    e.printStackTrace();
                }
            }
            future.complete(null);
        });
        return future;
    }
}

