/*
 * Decompiled with CFR 0.152.
 */
package com.example.griefprevention3d.listeners;

import com.example.griefprevention3d.claims.Claim;
import com.example.griefprevention3d.claims.ClaimBlockManager;
import com.example.griefprevention3d.claims.ClaimManager;
import com.example.griefprevention3d.ui.VisualizationManager;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerItemHeldEvent;
import org.bukkit.inventory.ItemStack;

public class ClaimToolListener
implements Listener {
    private final Map<UUID, Location> corner1 = new HashMap<UUID, Location>();
    private final Map<UUID, Location> corner2 = new HashMap<UUID, Location>();
    private final VisualizationManager visualizationManager;
    private final ClaimManager claimManager;
    private final ClaimBlockManager claimBlockManager;
    private final Map<UUID, ResizingData> resizingMode = new HashMap<UUID, ResizingData>();

    public ClaimToolListener(VisualizationManager visualizationManager, ClaimManager claimManager, ClaimBlockManager claimBlockManager) {
        this.visualizationManager = visualizationManager;
        this.claimManager = claimManager;
        this.claimBlockManager = claimBlockManager;
    }

    @EventHandler
    public void onPlayerInteract(PlayerInteractEvent event) {
        Player player = event.getPlayer();
        if (event.getItem() != null && event.getItem().getType() == Material.GOLDEN_SHOVEL && event.getAction().isRightClick()) {
            if (event.getClickedBlock() == null) {
                return;
            }
            Location loc = event.getClickedBlock().getLocation();
            if (this.resizingMode.containsKey(player.getUniqueId())) {
                ResizingData resizingData = this.resizingMode.get(player.getUniqueId());
                Claim claim = resizingData.claim;
                int oldVolume = this.claimBlockManager.getClaimVolume(claim);
                if (resizingData.corner == 1) {
                    claim.setCorner1(loc);
                } else {
                    claim.setCorner2(loc);
                }
                int newVolume = this.claimBlockManager.getClaimVolume(claim);
                int diff = newVolume - oldVolume;
                if (diff > 0 && !this.claimBlockManager.hasEnoughClaimBlocks(player, diff)) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "You do not have enough claim blocks to resize this claim.");
                    if (resizingData.corner == 1) {
                        claim.setCorner1(resizingData.claim.getCorner1());
                    } else {
                        claim.setCorner2(resizingData.claim.getCorner2());
                    }
                    return;
                }
                this.claimBlockManager.addClaimBlocks(player.getUniqueId(), oldVolume);
                this.claimBlockManager.removeClaimBlocks(player.getUniqueId(), newVolume);
                this.resizingMode.remove(player.getUniqueId());
                player.sendMessage(String.valueOf(ChatColor.GREEN) + "Claim resized.");
                this.visualizationManager.hideCorner(player, resizingData.claim.getCorner1());
                this.visualizationManager.hideCorner(player, resizingData.claim.getCorner2());
                this.visualizationManager.showClaimBoundaries(player, claim);
                return;
            }
            for (Claim claim : this.claimManager.getPlayerClaims(player)) {
                if (claim.getCorner1().distanceSquared(loc) < 1.0) {
                    this.resizingMode.put(player.getUniqueId(), new ResizingData(claim, 1));
                    player.sendMessage(String.valueOf(ChatColor.GREEN) + "Resizing claim. Right-click to set the new position for this corner.");
                    event.setCancelled(true);
                    return;
                }
                if (!(claim.getCorner2().distanceSquared(loc) < 1.0)) continue;
                this.resizingMode.put(player.getUniqueId(), new ResizingData(claim, 2));
                player.sendMessage(String.valueOf(ChatColor.GREEN) + "Resizing claim. Right-click to set the new position for this corner.");
                event.setCancelled(true);
                return;
            }
            if (!this.corner1.containsKey(player.getUniqueId()) || this.corner2.containsKey(player.getUniqueId())) {
                this.corner1.put(player.getUniqueId(), loc);
                this.corner2.remove(player.getUniqueId());
                player.sendMessage(String.valueOf(ChatColor.GREEN) + "First corner set.");
            } else {
                this.corner2.put(player.getUniqueId(), loc);
                player.sendMessage(String.valueOf(ChatColor.GREEN) + "Second corner set. Type /claim create to create your claim.");
                this.visualizationManager.showClaimBoundaries(player, this.corner1.get(player.getUniqueId()), this.corner2.get(player.getUniqueId()));
            }
            event.setCancelled(true);
        }
    }

    public Location getCorner1(Player player) {
        return this.corner1.get(player.getUniqueId());
    }

    public Location getCorner2(Player player) {
        return this.corner2.get(player.getUniqueId());
    }

    public void clearCorners(Player player) {
        this.corner1.remove(player.getUniqueId());
        this.corner2.remove(player.getUniqueId());
    }

    @EventHandler
    public void onPlayerItemHeld(PlayerItemHeldEvent event) {
        Player player = event.getPlayer();
        ItemStack newItem = player.getInventory().getItem(event.getNewSlot());
        ItemStack oldItem = player.getInventory().getItem(event.getPreviousSlot());
        if (newItem != null && newItem.getType() == Material.GOLDEN_SHOVEL) {
            for (Claim claim : this.claimManager.getPlayerClaims(player)) {
                this.visualizationManager.showCorner(player, claim.getCorner1());
                this.visualizationManager.showCorner(player, claim.getCorner2());
            }
        }
        if (oldItem != null && oldItem.getType() == Material.GOLDEN_SHOVEL) {
            for (Claim claim : this.claimManager.getPlayerClaims(player)) {
                this.visualizationManager.hideCorner(player, claim.getCorner1());
                this.visualizationManager.hideCorner(player, claim.getCorner2());
            }
        }
    }

    private static class ResizingData {
        public final Claim claim;
        public final int corner;

        public ResizingData(Claim claim, int corner) {
            this.claim = claim;
            this.corner = corner;
        }
    }
}

