/*
 * Decompiled with CFR 0.152.
 */
package com.example.griefprevention3d.commands;

import com.example.griefprevention3d.GriefPrevention3D;
import com.example.griefprevention3d.claims.Claim;
import com.example.griefprevention3d.claims.ClaimBlockManager;
import com.example.griefprevention3d.claims.ClaimManager;
import com.example.griefprevention3d.commands.HelpCommand;
import com.example.griefprevention3d.fawe.FAWEIntegration;
import com.example.griefprevention3d.listeners.ClaimToolListener;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class ClaimCommand
implements CommandExecutor {
    private final GriefPrevention3D plugin;
    private final ClaimManager claimManager;
    private final ClaimToolListener claimToolListener;
    private final FAWEIntegration faweIntegration;
    private final ClaimBlockManager claimBlockManager;
    private final Map<UUID, Boolean> subdivideMode = new HashMap<UUID, Boolean>();

    public ClaimCommand(GriefPrevention3D plugin, ClaimManager claimManager, ClaimToolListener claimToolListener, FAWEIntegration faweIntegration, ClaimBlockManager claimBlockManager) {
        this.plugin = plugin;
        this.claimManager = claimManager;
        this.claimToolListener = claimToolListener;
        this.faweIntegration = faweIntegration;
        this.claimBlockManager = claimBlockManager;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage("Only players can use this command.");
            return true;
        }
        Player player = (Player)sender;
        if (args.length == 0) {
            HelpCommand.sendHelp(sender);
            return true;
        }
        if (args[0].equalsIgnoreCase("create")) {
            if (!player.hasPermission("griefprevention3d.claim.create")) {
                player.sendMessage(String.valueOf(ChatColor.RED) + "You do not have permission to create claims.");
                return true;
            }
            Location corner1 = this.claimToolListener.getCorner1(player);
            Location corner2 = this.claimToolListener.getCorner2(player);
            if (corner1 == null || corner2 == null) {
                player.sendMessage(String.valueOf(ChatColor.RED) + "You must set both corners of your claim with a golden shovel first.");
                return true;
            }
            Claim claim = new Claim(player.getUniqueId(), corner1, corner2);
            int claimVolume = this.claimBlockManager.getClaimVolume(claim);
            if (!this.claimBlockManager.hasEnoughClaimBlocks(player, claimVolume)) {
                player.sendMessage(String.valueOf(ChatColor.RED) + "You do not have enough claim blocks to create this claim.");
                return true;
            }
            if (this.subdivideMode.getOrDefault(player.getUniqueId(), false).booleanValue()) {
                Claim parentClaim = this.claimManager.getClaimAt(corner1);
                if (parentClaim == null || !parentClaim.equals(this.claimManager.getClaimAt(corner2))) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "Both corners of a subclaim must be inside the same parent claim.");
                    return true;
                }
                if (!parentClaim.getOwner().equals(player.getUniqueId())) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "You can only create subclaims in your own claims.");
                    return true;
                }
                claim.setParent(parentClaim);
                parentClaim.getChildren().add(claim);
                this.claimManager.addClaim(claim);
                player.sendMessage(String.valueOf(ChatColor.GREEN) + "Subclaim created!");
            } else {
                this.claimManager.addClaim(claim);
                player.sendMessage(String.valueOf(ChatColor.GREEN) + "Claim created!");
            }
            this.claimBlockManager.removeClaimBlocks(player.getUniqueId(), claimVolume);
            this.claimToolListener.clearCorners(player);
        } else if (args[0].equalsIgnoreCase("abandon")) {
            if (!player.hasPermission("griefprevention3d.claim.abandon")) {
                player.sendMessage(String.valueOf(ChatColor.RED) + "You do not have permission to abandon claims.");
                return true;
            }
            Claim claim = this.claimManager.getClaimAt(player.getLocation());
            if (claim == null) {
                player.sendMessage(String.valueOf(ChatColor.RED) + "You are not standing in a claim.");
                return true;
            }
            if (!claim.getOwner().equals(player.getUniqueId())) {
                player.sendMessage(String.valueOf(ChatColor.RED) + "You do not own this claim.");
                return true;
            }
            int claimVolume = this.claimBlockManager.getClaimVolume(claim);
            this.claimBlockManager.addClaimBlocks(player.getUniqueId(), claimVolume);
            this.claimManager.deleteClaim(claim);
            player.sendMessage(String.valueOf(ChatColor.GREEN) + "Claim abandoned and " + claimVolume + " claim blocks refunded.");
        } else if (args[0].equalsIgnoreCase("trust")) {
            if (!player.hasPermission("griefprevention3d.claim.trust")) {
                player.sendMessage(String.valueOf(ChatColor.RED) + "You do not have permission to trust players.");
                return true;
            }
            if (args.length < 3) {
                player.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /claim trust <player> <level>");
                return true;
            }
            Claim claim = this.claimManager.getClaimAt(player.getLocation());
            if (claim == null) {
                player.sendMessage(String.valueOf(ChatColor.RED) + "You are not standing in a claim.");
                return true;
            }
            if (!claim.getOwner().equals(player.getUniqueId())) {
                player.sendMessage(String.valueOf(ChatColor.RED) + "You do not own this claim.");
                return true;
            }
            Player trustedPlayer = Bukkit.getPlayer((String)args[1]);
            if (trustedPlayer == null) {
                player.sendMessage(String.valueOf(ChatColor.RED) + "Player not found.");
                return true;
            }
            if (trustedPlayer.equals((Object)player)) {
                player.sendMessage(String.valueOf(ChatColor.RED) + "You cannot trust yourself.");
                return true;
            }
            try {
                Claim.TrustLevel level = Claim.TrustLevel.valueOf(args[2].toUpperCase());
                claim.getTrustedPlayers().put(trustedPlayer.getUniqueId(), level);
                player.sendMessage(String.valueOf(ChatColor.GREEN) + "Player " + trustedPlayer.getName() + " has been trusted with level " + level.name());
            }
            catch (IllegalArgumentException e) {
                player.sendMessage(String.valueOf(ChatColor.RED) + "Invalid trust level. Valid levels are: ACCESS, CONTAINER, BUILD, MANAGER");
            }
        } else if (args[0].equalsIgnoreCase("untrust")) {
            if (!player.hasPermission("griefprevention3d.claim.untrust")) {
                player.sendMessage(String.valueOf(ChatColor.RED) + "You do not have permission to untrust players.");
                return true;
            }
            if (args.length < 2) {
                player.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /claim untrust <player>");
                return true;
            }
            Claim claim = this.claimManager.getClaimAt(player.getLocation());
            if (claim == null) {
                player.sendMessage(String.valueOf(ChatColor.RED) + "You are not standing in a claim.");
                return true;
            }
            if (!claim.getOwner().equals(player.getUniqueId())) {
                player.sendMessage(String.valueOf(ChatColor.RED) + "You do not own this claim.");
                return true;
            }
            Player untrustedPlayer = Bukkit.getPlayer((String)args[1]);
            if (untrustedPlayer == null) {
                player.sendMessage(String.valueOf(ChatColor.RED) + "Player not found.");
                return true;
            }
            claim.getTrustedPlayers().remove(untrustedPlayer.getUniqueId());
            player.sendMessage(String.valueOf(ChatColor.GREEN) + "Player " + untrustedPlayer.getName() + " has been untrusted.");
        } else if (args[0].equalsIgnoreCase("subdivide")) {
            if (!player.hasPermission("griefprevention3d.claim.subdivide")) {
                player.sendMessage(String.valueOf(ChatColor.RED) + "You do not have permission to subdivide claims.");
                return true;
            }
            this.subdivideMode.put(player.getUniqueId(), this.subdivideMode.getOrDefault(player.getUniqueId(), false) == false);
            if (this.subdivideMode.get(player.getUniqueId()).booleanValue()) {
                player.sendMessage(String.valueOf(ChatColor.GREEN) + "Subdivide mode enabled. Use the golden shovel to create a subclaim.");
            } else {
                player.sendMessage(String.valueOf(ChatColor.YELLOW) + "Subdivide mode disabled.");
            }
        } else if (args[0].equalsIgnoreCase("giveblocks")) {
            if (!player.hasPermission("griefprevention3d.admin.giveblocks")) {
                player.sendMessage(String.valueOf(ChatColor.RED) + "You do not have permission to use this command.");
                return true;
            }
            if (args.length < 3) {
                player.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /claim giveblocks <player> <amount>");
                return true;
            }
            Player target = Bukkit.getPlayer((String)args[1]);
            if (target == null) {
                player.sendMessage(String.valueOf(ChatColor.RED) + "Player not found.");
                return true;
            }
            try {
                int amount = Integer.parseInt(args[2]);
                this.claimBlockManager.addClaimBlocks(target.getUniqueId(), amount);
                player.sendMessage(String.valueOf(ChatColor.GREEN) + "Gave " + amount + " claim blocks to " + target.getName());
            }
            catch (NumberFormatException e) {
                player.sendMessage(String.valueOf(ChatColor.RED) + "Invalid amount.");
            }
        } else if (args[0].equalsIgnoreCase("saveall")) {
            if (!player.hasPermission("griefprevention3d.admin.saveall")) {
                player.sendMessage(String.valueOf(ChatColor.RED) + "You do not have permission to use this command.");
                return true;
            }
            this.faweIntegration.saveAllClaims(this.claimManager);
            player.sendMessage(String.valueOf(ChatColor.GREEN) + "All claims have been saved.");
        } else if (args[0].equalsIgnoreCase("loadall")) {
            if (!player.hasPermission("griefprevention3d.admin.loadall")) {
                player.sendMessage(String.valueOf(ChatColor.RED) + "You do not have permission to use this command.");
                return true;
            }
            player.sendMessage(String.valueOf(ChatColor.GREEN) + "Loading all claims...");
            this.plugin.getLogger().info("Starting /claim loadall command...");
            this.faweIntegration.loadAllClaims(this.claimManager).thenRun(() -> {
                player.sendMessage(String.valueOf(ChatColor.GREEN) + "All claims have been loaded.");
                this.plugin.getLogger().info("Finished /claim loadall command.");
            });
        } else if (args[0].equalsIgnoreCase("blocks")) {
            if (!player.hasPermission("griefprevention3d.claim.blocks")) {
                player.sendMessage(String.valueOf(ChatColor.RED) + "You do not have permission to check your claim blocks.");
                return true;
            }
            int currentBlocks = this.claimBlockManager.getClaimBlocks(player.getUniqueId());
            int maxBlocks = this.claimBlockManager.getMaxClaimBlocks(player);
            player.sendMessage(String.valueOf(ChatColor.GREEN) + "You have " + currentBlocks + "/" + maxBlocks + " claim blocks.");
        }
        return true;
    }
}

