/*
 * Decompiled with CFR 0.152.
 */
package com.example.griefprevention3d.listeners;

import com.example.griefprevention3d.ui.VisualizationManager;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerInteractEvent;

public class ClaimToolListener
implements Listener {
    private final Map<UUID, Location> corner1 = new HashMap<UUID, Location>();
    private final Map<UUID, Location> corner2 = new HashMap<UUID, Location>();
    private final VisualizationManager visualizationManager;

    public ClaimToolListener(VisualizationManager visualizationManager) {
        this.visualizationManager = visualizationManager;
    }

    @EventHandler
    public void onPlayerInteract(PlayerInteractEvent event) {
        Player player = event.getPlayer();
        if (event.getItem() != null && event.getItem().getType() == Material.GOLDEN_SHOVEL && event.getAction().isRightClick()) {
            if (event.getClickedBlock() == null) {
                return;
            }
            Location loc = event.getClickedBlock().getLocation();
            if (!this.corner1.containsKey(player.getUniqueId()) || this.corner2.containsKey(player.getUniqueId())) {
                this.corner1.put(player.getUniqueId(), loc);
                this.corner2.remove(player.getUniqueId());
                player.sendMessage(String.valueOf(ChatColor.GREEN) + "First corner set.");
            } else {
                this.corner2.put(player.getUniqueId(), loc);
                player.sendMessage(String.valueOf(ChatColor.GREEN) + "Second corner set. Type /claim create to create your claim.");
                this.visualizationManager.showClaimBoundaries(player, this.corner1.get(player.getUniqueId()), this.corner2.get(player.getUniqueId()));
            }
            event.setCancelled(true);
        }
    }

    public Location getCorner1(Player player) {
        return this.corner1.get(player.getUniqueId());
    }

    public Location getCorner2(Player player) {
        return this.corner2.get(player.getUniqueId());
    }

    public void clearCorners(Player player) {
        this.corner1.remove(player.getUniqueId());
        this.corner2.remove(player.getUniqueId());
    }
}

