/*
 * Decompiled with CFR 0.152.
 */
package com.example.griefprevention3d.storage;

import com.example.griefprevention3d.GriefPrevention3D;
import com.example.griefprevention3d.claims.Claim;
import com.example.griefprevention3d.claims.ClaimManager;
import com.example.griefprevention3d.libs.gson.Gson;
import com.example.griefprevention3d.libs.gson.GsonBuilder;
import com.example.griefprevention3d.libs.gson.reflect.TypeToken;
import com.example.griefprevention3d.storage.LocationAdapter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.List;
import org.bukkit.Location;

public class StorageManager {
    private final File claimsFile;
    private final Gson gson;

    public StorageManager(GriefPrevention3D plugin) {
        this.claimsFile = new File(plugin.getDataFolder(), "claims.json");
        this.gson = new GsonBuilder().registerTypeAdapter((Type)((Object)Location.class), new LocationAdapter()).setPrettyPrinting().create();
    }

    public void loadClaims(ClaimManager claimManager) {
        if (!this.claimsFile.exists()) {
            return;
        }
        try (FileReader reader = new FileReader(this.claimsFile);){
            Type type = new TypeToken<List<Claim>>(this){}.getType();
            List claims = (List)this.gson.fromJson((Reader)reader, type);
            if (claims != null) {
                for (Claim claim : claims) {
                    claimManager.addClaim(claim);
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void saveClaims(ClaimManager claimManager) {
        try (FileWriter writer = new FileWriter(this.claimsFile);){
            this.gson.toJson(claimManager.getAllClaims(), (Appendable)writer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

