/*
 * Decompiled with CFR 0.152.
 */
package net.enderbyteprograms.KeepChoice;

import net.enderbyteprograms.KeepChoice.Static;
import net.enderbyteprograms.KeepChoice.Structures.Config;
import net.enderbyteprograms.KeepChoice.Structures.PlayerData;
import net.enderbyteprograms.KeepChoice.bstats.Metrics;
import net.enderbyteprograms.KeepChoice.commands.KeepInventoryCommand;
import net.enderbyteprograms.KeepChoice.commands.KeepInventoryTabCompleter;
import net.enderbyteprograms.KeepChoice.listeners.OnDeath;
import net.enderbyteprograms.KeepChoice.listeners.OnJoin;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.TabCompleter;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class KeepChoiceMain
extends JavaPlugin {
    public void onEnable() {
        Static.Plugin = this;
        this.saveDefaultConfig();
        Static.RawConfig = this.getConfig();
        Static.Logger = this.getLogger();
        Static.Config = new Config(Static.RawConfig);
        this.getLogger().info("Found " + String.valueOf(Static.Config.WorldSettings.size()) + " Configurations");
        int pluginID = 24015;
        Metrics metrics = new Metrics((Plugin)this, pluginID);
        this.ReadPlayerData();
        this.getServer().getPluginManager().registerEvents((Listener)new OnJoin(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new OnDeath(), (Plugin)this);
        this.getCommand("keepinventory").setExecutor((CommandExecutor)new KeepInventoryCommand());
        this.getCommand("keepinventory").setTabCompleter((TabCompleter)new KeepInventoryTabCompleter());
        this.getLogger().info("KeepChoice is ready. (c) 2024-2025 Enderbyte Programs, some rights reserved");
    }

    public void onDisable() {
        this.WritePlayerData();
        this.getLogger().info("ByeBye Everybody!");
    }

    public void WritePlayerData() {
        for (PlayerData datablocks : Static.Data.values()) {
            for (String worldkey : datablocks.WorldData.keySet()) {
                this.getConfig().set(String.format("data.%s.%s", datablocks.UUID, worldkey), (Object)datablocks.WorldData.get(worldkey));
            }
        }
        this.saveConfig();
    }

    public void ReadPlayerData() {
        for (String data : this.getConfig().getConfigurationSection("data").getKeys(false)) {
            if (data.equals("__placeholder")) continue;
            PlayerData pd = new PlayerData(data);
            ConfigurationSection thisdata = this.getConfig().getConfigurationSection("data." + data);
            for (String key : thisdata.getKeys(false)) {
                Boolean vv = thisdata.getBoolean(key);
                pd.WorldData.put(key, vv);
            }
            Static.Data.put(data, pd);
        }
    }
}

