/*
 * Decompiled with CFR 0.152.
 */
package net.enderbyteprograms.KeepChoice.Structures;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.enderbyteprograms.KeepChoice.Static;
import net.enderbyteprograms.KeepChoice.Structures.ConfigDefaultBehaviour;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.configuration.file.FileConfiguration;

public class Config {
    public HashMap<String, ConfigDefaultBehaviour> WorldSettings = new HashMap();
    public List<String> RunInWorlds = new ArrayList<String>();
    public boolean WasWildcardWorld = false;

    public ConfigDefaultBehaviour getDefault() {
        return this.WorldSettings.get("default");
    }

    public Config(FileConfiguration ingress) {
        this.RunInWorlds = ingress.getStringList("runinworlds");
        this.RunInWorlds.remove("__placeholder");
        if (this.RunInWorlds.contains("*")) {
            this.WasWildcardWorld = true;
            this.RunInWorlds.clear();
            for (World w : Bukkit.getWorlds()) {
                this.RunInWorlds.add(w.getName());
            }
        }
        this.RunInWorlds.remove("*");
        ArrayList configkeys = new ArrayList(ingress.getKeys(false));
        for (String configkey : configkeys) {
            if (configkey.equals("runinworlds") || configkey.equals("data")) continue;
            if (!configkey.equals("default")) {
                try {
                    World w = Bukkit.getWorld((String)configkey);
                    if (w == null) {
                        throw new Exception();
                    }
                }
                catch (Exception e) {
                    Static.Logger.warning("Skipped world " + configkey + " as it doesn't exist.");
                }
            }
            ConfigDefaultBehaviour pv = new ConfigDefaultBehaviour(ingress, configkey);
            this.WorldSettings.put(configkey, pv);
        }
    }

    public boolean IsWorldKnown(String name) {
        return this.WorldSettings.containsKey(name);
    }

    public boolean IsWorldAllowed(String name) {
        return this.RunInWorlds.contains(name);
    }

    public boolean GetFor(String worldname) {
        if (this.IsWorldKnown(worldname)) {
            return this.WorldSettings.get((Object)worldname).KeepItems;
        }
        return this.getDefault().KeepItems;
    }
}

