/*
 * Decompiled with CFR 0.152.
 */
package net.enderbyteprograms.KeepChoice.commands;

import java.util.Iterator;
import java.util.Objects;
import net.enderbyteprograms.KeepChoice.Static;
import net.enderbyteprograms.KeepChoice.Structures.Config;
import net.enderbyteprograms.KeepChoice.Structures.ConfigDefaultBehaviour;
import net.enderbyteprograms.KeepChoice.Structures.PlayerData;
import net.enderbyteprograms.KeepChoice.Utils;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.World;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class KeepInventoryCommand
implements CommandExecutor {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        Iterator<String> currentworld2;
        try {
            if (args.length == 0) {
                if (!(sender instanceof Player)) {
                    Utils.SendError(sender, "Please specify a world and a player, or run /keepinventory help for a list of options");
                    return false;
                }
                if (!Static.Data.containsKey(((Player)sender).getUniqueId().toString())) {
                    Static.Data.put(((Player)sender).getUniqueId().toString(), new PlayerData(((Player)sender).getUniqueId().toString()));
                }
                PlayerData currentdata = Static.Data.get(((Player)sender).getUniqueId().toString());
                String currentworld2 = ((Player)sender).getWorld().getName();
                if (!Static.Config.IsWorldAllowed(currentworld2)) {
                    Utils.SendError(sender, "Keep Inventory Choice is not permitted in this world.");
                    return false;
                }
                if (!currentdata.WorldData.containsKey(currentworld2)) {
                    currentdata.WorldData.put(currentworld2, Static.Config.getDefault().KeepItems);
                }
                currentdata.WorldData.put(currentworld2, currentdata.WorldData.get(currentworld2) == false);
                sender.sendMessage("Keep Inventory for world \"" + currentworld2 + "\" is now " + Utils.FriendlyBool(currentdata.WorldData.get(currentworld2)));
                Static.Plugin.WritePlayerData();
                return true;
            }
            String action = args[0];
            if (Objects.equals(action, "help")) {
                sender.sendMessage(ChatColor.BLUE + "KeepChoice v" + "1.0.13" + ChatColor.RESET + " Help Page");
                sender.sendMessage("<> denotes mandatory argument, [] denotes optional argument.");
                if (Utils.isAdmin(sender)) {
                    sender.sendMessage(ChatColor.AQUA + "/keepinventory" + ChatColor.RESET + "[world] [player]\n    Toggles keep inventory status (if the player is allowed to) for [world] if specified, and for [player] if specified (themself if not)\n" + ChatColor.AQUA + "/keepinventory" + ChatColor.RESET + " info\n    Lists world configurations stored in data\n" + ChatColor.AQUA + "/keepinventory" + ChatColor.RESET + " list\n    Lists all player data\n" + ChatColor.AQUA + "/keepinventory" + ChatColor.RESET + " setrunson <world> <yes|no>\n    Set whether this plugin runs on <world>.\n" + ChatColor.AQUA + "/keepinventory" + ChatColor.RESET + " setdefaultkion <world> <yes|no> [force|noforce]\n    Set the default keep inventory status for <world>. If force is specified, every player's settings will be updated to match this. If not, only newly joined players will experience the change. \n" + ChatColor.AQUA + "/keepinventory" + ChatColor.RESET + " reload\n    Reload configuration from the disk");
                    return true;
                }
                sender.sendMessage(ChatColor.AQUA + "/keepinventory" + ChatColor.RESET + " [world]\n    Toggles keep inventory status for [world] if specified (else use current world)\n");
                return true;
            }
            if (!action.equals("info")) {
                if (action.equals("list")) {
                    sender.sendMessage("Note that data will appear whether or not this plugin is allowed in that world.");
                    Iterator<PlayerData> currentworld2 = Static.Data.values().iterator();
                    block4: while (true) {
                        if (!currentworld2.hasNext()) return true;
                        PlayerData p = currentworld2.next();
                        sender.sendMessage(Utils.SafeGetNameOrUUID(p.Player) + ":");
                        Iterator<String> w = p.WorldData.keySet().iterator();
                        while (true) {
                            if (!w.hasNext()) continue block4;
                            String worldkey = w.next();
                            sender.sendMessage("    " + worldkey + ": " + Utils.FriendlyBool(p.WorldData.get(worldkey)));
                        }
                        break;
                    }
                }
                if (action.equals("setrunson")) {
                    if (args.length < 3) {
                        Utils.SendError(sender, "Not enough arguments");
                        return false;
                    }
                    if (!Utils.isAdmin(sender)) {
                        Utils.SendError(sender, "Insufficient Privilege!");
                        return false;
                    }
                    String forworld = args[1];
                    boolean newstate = Utils.BoolFromS(args[2]);
                    if (forworld.equals("#all")) {
                        if (!newstate) {
                            Static.Config.RunInWorlds.clear();
                            Static.RawConfig.set("runinworlds", (Object)new String[]{"__placeholder"});
                            Static.Plugin.saveConfig();
                            Utils.SendSuccess(sender, "Plugin disabled on all worlds.");
                            return true;
                        }
                        Static.Config.RunInWorlds.clear();
                        Iterator w = Bukkit.getWorlds().iterator();
                        while (true) {
                            if (!w.hasNext()) {
                                Static.RawConfig.set("runinworlds", (Object)new String[]{"*"});
                                Static.Plugin.saveConfig();
                                Utils.SendSuccess(sender, "Plugin enabled on all worlds");
                                return true;
                            }
                            World w2 = (World)w.next();
                            Static.Config.RunInWorlds.add(w2.getName());
                        }
                    }
                    if (newstate) {
                        Static.Config.RunInWorlds.add(forworld);
                    } else {
                        Static.Config.RunInWorlds.remove(forworld);
                    }
                    Static.RawConfig.set("runinworlds", (Object)Static.Config.RunInWorlds.toArray());
                    Utils.SendSuccess(sender, "Updated plugin state for " + forworld);
                    return true;
                }
                if (action.equals("setdefaultkion")) {
                    if (args.length < 3) {
                        Utils.SendError(sender, "Not enough arguments");
                        return false;
                    }
                    if (!Utils.isAdmin(sender)) {
                        Utils.SendError(sender, "Insufficient Privilege!");
                        return false;
                    }
                    String forworld = args[1];
                    boolean newstate = Utils.BoolFromS(args[2]);
                    boolean force = false;
                    if (args.length >= 4 && args[3].equals("force")) {
                        force = true;
                    }
                    if (!forworld.equals("#default") && Bukkit.getWorld((String)forworld) == null) {
                        Utils.SendError(sender, "Invalid world name. Either use a world name, or #default to edit the default settings");
                        return false;
                    }
                    if (forworld.equals("#default")) {
                        ConfigDefaultBehaviour olddata = Static.Config.WorldSettings.get("default");
                        olddata.KeepItems = newstate;
                        Static.Config.WorldSettings.put("default", olddata);
                        if (force) {
                            for (PlayerData p : Static.Data.values()) {
                                for (String worldname : p.WorldData.keySet()) {
                                    if (Static.Config.IsWorldKnown(worldname)) continue;
                                    p.WorldData.put(worldname, newstate);
                                }
                            }
                        }
                        Static.RawConfig.set("default.Enabled", (Object)newstate);
                        Static.Plugin.saveConfig();
                        Utils.SendSuccess(sender, "Updated default setting for all worlds using default settings");
                        return true;
                    }
                    ConfigDefaultBehaviour olddata = Static.Config.WorldSettings.get(forworld);
                    if (olddata == null) {
                        olddata = new ConfigDefaultBehaviour(newstate);
                    }
                    olddata.KeepItems = newstate;
                    Static.Config.WorldSettings.put(forworld, olddata);
                    Static.RawConfig.set(forworld + ".Enabled", (Object)newstate);
                    if (force) {
                        for (PlayerData p : Static.Data.values()) {
                            p.WorldData.put(forworld, newstate);
                        }
                    }
                    Static.Plugin.saveConfig();
                    Utils.SendSuccess(sender, "Updated default setting for world " + forworld);
                    return true;
                }
                if (action.equals("reload")) {
                    if (Utils.isAdmin(sender)) {
                        Static.Config = new Config(Static.Plugin.getConfig());
                        Utils.SendSuccess(sender, "Reloaded");
                        return true;
                    }
                    Utils.SendError(sender, "Insufficient Privilege!");
                    return false;
                }
                if (args.length == 1) {
                    String currentworld3 = args[0];
                    if (!(sender instanceof Player)) {
                        Utils.SendError(sender, "Please specify a world and a player, or run /keepinventory help for a list of options");
                        return false;
                    }
                    if (!Static.Data.containsKey(((Player)sender).getUniqueId().toString())) {
                        Static.Data.put(((Player)sender).getUniqueId().toString(), new PlayerData(((Player)sender).getUniqueId().toString()));
                    }
                    PlayerData currentdata = Static.Data.get(((Player)sender).getUniqueId().toString());
                    if (!Static.Config.IsWorldAllowed(currentworld3)) {
                        Utils.SendError(sender, "Keep Inventory Choice is not permitted in this world.");
                        return false;
                    }
                    if (!currentdata.WorldData.containsKey(currentworld3)) {
                        currentdata.WorldData.put(currentworld3, Static.Config.getDefault().KeepItems);
                    }
                    currentdata.WorldData.put(currentworld3, currentdata.WorldData.get(currentworld3) == false);
                    sender.sendMessage("Keep Inventory for world \"" + currentworld3 + "\" is now " + Utils.FriendlyBool(currentdata.WorldData.get(currentworld3)));
                    Static.Plugin.WritePlayerData();
                    return true;
                }
                if (!Utils.isAdmin(sender)) {
                    Utils.SendError(sender, "Insufficient Permission");
                    return false;
                }
                String currentworld4 = args[0];
                String sfname = args[1];
                if (!Static.Data.containsKey(Bukkit.getOfflinePlayer((String)sfname).getUniqueId().toString())) {
                    Static.Data.put(Bukkit.getOfflinePlayer((String)sfname).getUniqueId().toString(), new PlayerData(Bukkit.getOfflinePlayer((String)sfname).getUniqueId().toString()));
                }
                PlayerData currentdata = Static.Data.get(Bukkit.getOfflinePlayer((String)sfname).getUniqueId().toString());
                if (!Static.Config.IsWorldAllowed(currentworld4)) {
                    Utils.SendError(sender, "Keep Inventory Choice is not permitted in this world.");
                    return false;
                }
                if (!currentdata.WorldData.containsKey(currentworld4)) {
                    currentdata.WorldData.put(currentworld4, Static.Config.getDefault().KeepItems);
                }
                currentdata.WorldData.put(currentworld4, currentdata.WorldData.get(currentworld4) == false);
                sender.sendMessage("Keep Inventory for world \"" + currentworld4 + "\" is now " + Utils.FriendlyBool(currentdata.WorldData.get(currentworld4)) + " for " + Utils.SafeGetNameOrUUID(currentdata.Player));
                Static.Plugin.WritePlayerData();
                return true;
            }
            sender.sendMessage("Default Keep Inventory?:");
            currentworld2 = Static.Config.WorldSettings.keySet().iterator();
        }
        catch (Exception e) {
            Utils.SendError(sender, "ERROR! - " + e.getMessage());
            return true;
        }
        while (currentworld2.hasNext()) {
            String k = currentworld2.next();
            World w = Bukkit.getWorld((String)k);
            if (w == null && !k.equals("default")) continue;
            try {
                sender.sendMessage("World " + k + ": " + Utils.FriendlyBool(Static.Config.WorldSettings.get((Object)k).KeepItems));
            }
            catch (Exception e) {
                sender.sendMessage("World " + k + ": " + Utils.FriendlyBool(Static.Config.WorldSettings.get((Object)k).KeepItems));
            }
        }
        return true;
    }
}

