/*
 * Decompiled with CFR 0.152.
 */
package net.tarantel.chickenroost.handler;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.SlotItemHandler;
import net.tarantel.chickenroost.ChickenRoostMod;
import net.tarantel.chickenroost.block.blocks.ModBlocks;
import net.tarantel.chickenroost.block.tile.Roost_Tile;
import net.tarantel.chickenroost.handler.ItemCapabilityMenuHelper;
import net.tarantel.chickenroost.handler.ModHandlers;
import net.tarantel.chickenroost.item.base.ChickenItemBase;

public class Roost_Handler
extends AbstractContainerMenu {
    public static final HashMap<String, Object> guistate = new HashMap();
    public final Roost_Tile blockEntity;
    public final Level level;
    private final ContainerData data;
    public int x;
    public int y;
    public int z;
    private final Map<Integer, Slot> customSlots = new HashMap<Integer, Slot>();
    private boolean bound = false;
    private static final int HOTBAR_SLOT_COUNT = 9;
    private static final int PLAYER_INVENTORY_ROW_COUNT = 3;
    private static final int PLAYER_INVENTORY_COLUMN_COUNT = 9;
    private static final int PLAYER_INVENTORY_SLOT_COUNT = 27;
    private static final int VANILLA_SLOT_COUNT = 36;
    private static final int VANILLA_FIRST_SLOT_INDEX = 0;
    private static final int TE_INVENTORY_FIRST_SLOT_INDEX = 36;
    private static final int TE_INVENTORY_SLOT_COUNT = 3;

    public Roost_Handler(int id, Inventory inv, FriendlyByteBuf extraData) {
        this(id, inv, inv.player.level().getBlockEntity(extraData.readBlockPos()), (ContainerData)new SimpleContainerData(2));
    }

    public Roost_Handler(int id, Inventory inv, BlockEntity entity, ContainerData data) {
        super(ModHandlers.ROOST_MENU_V1.get(), id);
        Roost_Handler.checkContainerSize((Container)inv, (int)3);
        this.blockEntity = (Roost_Tile)entity;
        this.level = inv.player.level();
        this.data = data;
        this.addPlayerInventory(inv);
        this.addPlayerHotbar(inv);
        ItemCapabilityMenuHelper.getCapabilityItemHandler(this.level, this.blockEntity).ifPresent(itemHandler -> {
            this.addSlot((Slot)new SlotItemHandler(this, (IItemHandler)itemHandler, 0, 11, 15){

                public boolean mayPlace(ItemStack stack) {
                    return stack.is(ItemTags.create((ResourceLocation)ChickenRoostMod.commonsource("seeds/tiered")));
                }
            });
            this.addSlot((Slot)new SlotItemHandler(this, (IItemHandler)itemHandler, 1, 29, 38){

                public boolean mayPlace(ItemStack stack) {
                    return stack.getItem() instanceof ChickenItemBase;
                }
            });
            this.addSlot((Slot)new SlotItemHandler(this, (IItemHandler)itemHandler, 2, 111, 38){

                public boolean mayPlace(ItemStack stack) {
                    return false;
                }
            });
        });
        this.addDataSlots(this.data);
    }

    public boolean isCrafting() {
        return this.data.get(0) > 0;
    }

    public int getScaledProgress() {
        int progress = this.data.get(0);
        int maxProgress = this.data.get(1);
        int progressArrowSize = 40;
        return maxProgress != 0 && progress != 0 ? progress * progressArrowSize / maxProgress : 0;
    }

    public ItemStack quickMoveStack(Player playerIn, int index) {
        Slot sourceSlot = (Slot)this.slots.get(index);
        if (sourceSlot == null || !sourceSlot.hasItem()) {
            return ItemStack.EMPTY;
        }
        ItemStack sourceStack = sourceSlot.getItem();
        ItemStack copyOfSourceStack = sourceStack.copy();
        if (index < 36) {
            if (!this.moveItemStackTo(sourceStack, 36, 39, false)) {
                return ItemStack.EMPTY;
            }
        } else if (index < 39) {
            if (!this.moveItemStackTo(sourceStack, 0, 36, false)) {
                return ItemStack.EMPTY;
            }
        } else {
            System.out.println("Invalid slotIndex:" + index);
            return ItemStack.EMPTY;
        }
        if (sourceStack.getCount() == 0) {
            sourceSlot.set(ItemStack.EMPTY);
        } else {
            sourceSlot.setChanged();
        }
        sourceSlot.onTake(playerIn, sourceStack);
        return copyOfSourceStack;
    }

    public boolean stillValid(Player player) {
        return Roost_Handler.stillValid((ContainerLevelAccess)ContainerLevelAccess.create((Level)this.level, (BlockPos)this.blockEntity.getBlockPos()), (Player)player, (Block)((Block)ModBlocks.ROOST.get()));
    }

    private void addPlayerInventory(Inventory playerInventory) {
        for (int i = 0; i < 3; ++i) {
            for (int l = 0; l < 9; ++l) {
                this.addSlot(new Slot((Container)playerInventory, l + i * 9 + 9, 8 + l * 18, 84 + i * 18));
            }
        }
    }

    private void addPlayerHotbar(Inventory playerInventory) {
        for (int i = 0; i < 9; ++i) {
            this.addSlot(new Slot((Container)playerInventory, i, 8 + i * 18, 142));
        }
    }

    public BlockEntity getBlockEntity() {
        return this.blockEntity;
    }
}

