/*
 * Decompiled with CFR 0.152.
 */
package net.tarantel.chickenroost.block.tile;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemContainerContents;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.tarantel.chickenroost.block.blocks.ModBlocks;
import net.tarantel.chickenroost.block.tile.InputOutputItemHandler;
import net.tarantel.chickenroost.block.tile.ModBlockEntities;
import net.tarantel.chickenroost.handler.Roost_Handler;
import net.tarantel.chickenroost.item.base.ChickenItemBase;
import net.tarantel.chickenroost.item.base.ChickenSeedBase;
import net.tarantel.chickenroost.recipes.ModRecipes;
import net.tarantel.chickenroost.recipes.Roost_Recipe;
import net.tarantel.chickenroost.util.Config;
import net.tarantel.chickenroost.util.ModDataComponents;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Roost_Tile
extends BlockEntity
implements MenuProvider {
    public final ItemStackHandler itemHandler = new ItemStackHandler(3){

        protected void onContentsChanged(int slot) {
            Roost_Tile.this.setChanged();
            if (slot == 1) {
                Roost_Tile.this.resetProgress();
            }
        }

        public int getSlotLimit(int slot) {
            if (slot == 0) {
                return 64;
            }
            if (slot == 1) {
                return 1;
            }
            if (slot == 2) {
                return 64;
            }
            return 0;
        }

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            return switch (slot) {
                case 0 -> stack.getItem() instanceof ChickenSeedBase;
                case 1 -> stack.getItem() instanceof ChickenItemBase;
                case 2 -> false;
                default -> super.isItemValid(slot, stack);
            };
        }
    };
    protected final ContainerData data;
    public int progress = 0;
    public int maxProgress = (Integer)Config.roost_speed_tick.get() * 20;
    public final int[] LevelList;
    public final int[] XPList;
    public final int[] XPAmountList;
    private final IItemHandler itemHandlerSided = new InputOutputItemHandler((IItemHandlerModifiable)this.itemHandler, (i, stack) -> i == 0 || i == 1, i -> i == 2);
    public static ItemStack ChickenItem;
    public static ChickenSeedBase FoodItem;
    public static ChickenItemBase MyChicken;

    public ItemStack getRenderStack() {
        ItemStack stack = !this.itemHandler.getStackInSlot(1).isEmpty() ? this.itemHandler.getStackInSlot(1) : ItemStack.EMPTY;
        return stack;
    }

    public void setChanged() {
        if (this.level != null) {
            Roost_Tile.setChanged((Level)this.level, (BlockPos)this.worldPosition, (BlockState)this.getBlockState());
            this.getRenderStack();
        }
    }

    public void setHandler(ItemStackHandler itemStackHandler) {
        for (int i = 0; i < itemStackHandler.getSlots(); ++i) {
            this.itemHandler.setStackInSlot(i, itemStackHandler.getStackInSlot(i));
        }
    }

    public int getScaledProgress() {
        int progresss = this.progress;
        int maxProgresss = this.maxProgress;
        int progressArrowSize = 200;
        return maxProgresss != 0 && progresss != 0 ? progresss * progressArrowSize / maxProgresss : 0;
    }

    public Roost_Tile(BlockPos pos, BlockState state) {
        super(ModBlockEntities.ROOST.get(), pos, state);
        this.LevelList = new int[]{Objects.requireNonNullElse((Integer)Config.maxlevel_tier_1.get(), 128), Objects.requireNonNullElse((Integer)Config.maxlevel_tier_2.get(), 128), Objects.requireNonNullElse((Integer)Config.maxlevel_tier_3.get(), 128), Objects.requireNonNullElse((Integer)Config.maxlevel_tier_4.get(), 128), Objects.requireNonNullElse((Integer)Config.maxlevel_tier_5.get(), 128), Objects.requireNonNullElse((Integer)Config.maxlevel_tier_6.get(), 128), Objects.requireNonNullElse((Integer)Config.maxlevel_tier_7.get(), 128), Objects.requireNonNullElse((Integer)Config.maxlevel_tier_8.get(), 128), Objects.requireNonNullElse((Integer)Config.maxlevel_tier_9.get(), 128)};
        this.XPList = new int[]{Objects.requireNonNullElse(Integer.valueOf((Integer)Config.xp_tier_1.get()), 50), Objects.requireNonNullElse(Integer.valueOf((Integer)Config.xp_tier_2.get()), 250), Objects.requireNonNullElse(Integer.valueOf((Integer)Config.xp_tier_3.get()), 1250), Objects.requireNonNullElse(Integer.valueOf((Integer)Config.xp_tier_4.get()), 6250), Objects.requireNonNullElse(Integer.valueOf((Integer)Config.xp_tier_5.get()), 12500), Objects.requireNonNullElse(Integer.valueOf((Integer)Config.xp_tier_6.get()), 25000), Objects.requireNonNullElse(Integer.valueOf((Integer)Config.xp_tier_7.get()), 32500), Objects.requireNonNullElse(Integer.valueOf((Integer)Config.xp_tier_8.get()), 40000), Objects.requireNonNullElse(Integer.valueOf((Integer)Config.xp_tier_9.get()), 50000)};
        this.XPAmountList = new int[]{Objects.requireNonNullElse(Integer.valueOf((Integer)Config.food_xp_tier_1.get()), 50), Objects.requireNonNullElse(Integer.valueOf((Integer)Config.food_xp_tier_2.get()), 200), Objects.requireNonNullElse(Integer.valueOf((Integer)Config.food_xp_tier_3.get()), 300), Objects.requireNonNullElse(Integer.valueOf((Integer)Config.food_xp_tier_4.get()), 500), Objects.requireNonNullElse(Integer.valueOf((Integer)Config.food_xp_tier_5.get()), 700), Objects.requireNonNullElse(Integer.valueOf((Integer)Config.food_xp_tier_6.get()), 1000), Objects.requireNonNullElse(Integer.valueOf((Integer)Config.food_xp_tier_7.get()), 1500), Objects.requireNonNullElse(Integer.valueOf((Integer)Config.food_xp_tier_8.get()), 2500), Objects.requireNonNullElse(Integer.valueOf((Integer)Config.food_xp_tier_9.get()), 5000)};
        this.data = new ContainerData(){

            public int get(int index) {
                return switch (index) {
                    case 0 -> Roost_Tile.this.progress;
                    case 1 -> Roost_Tile.this.maxProgress;
                    default -> 0;
                };
            }

            public void set(int index, int value) {
                switch (index) {
                    case 0: {
                        Roost_Tile.this.progress = value;
                        break;
                    }
                    case 1: {
                        Roost_Tile.this.maxProgress = value;
                    }
                }
            }

            public int getCount() {
                return 2;
            }
        };
    }

    @NotNull
    public Component getDisplayName() {
        return Component.translatable((String)"");
    }

    @Nullable
    public AbstractContainerMenu createMenu(int id, @NotNull Inventory inventory, @NotNull Player player) {
        return new Roost_Handler(id, inventory, this, this.data);
    }

    @Nullable
    public IItemHandler getItemHandlerCapability(@Nullable Direction side) {
        if (side == null) {
            return this.itemHandler;
        }
        return this.itemHandlerSided;
    }

    public void onLoad() {
        super.onLoad();
        this.setChanged();
        this.getRenderStack();
    }

    public void saveAdditional(CompoundTag nbt, HolderLookup.Provider lookup) {
        nbt.put("inventory", (Tag)this.itemHandler.serializeNBT(lookup));
        nbt.putInt("roost.progress", this.progress);
        super.saveAdditional(nbt, lookup);
    }

    public void loadAdditional(CompoundTag nbt, HolderLookup.Provider lookup) {
        super.loadAdditional(nbt, lookup);
        this.itemHandler.deserializeNBT(lookup, nbt.getCompound("inventory"));
        this.progress = nbt.getInt("roost.progress");
    }

    public void drops() {
        SimpleContainer inventory = new SimpleContainer(this.itemHandler.getSlots());
        SimpleContainer block = new SimpleContainer(1);
        ItemStack itemStack = new ItemStack((ItemLike)ModBlocks.ROOST.get());
        NonNullList items = inventory.getItems();
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            items.set(i, (Object)this.itemHandler.getStackInSlot(i));
        }
        itemStack.set(DataComponents.CONTAINER, (Object)ItemContainerContents.fromItems((List)inventory.getItems()));
        block.setItem(0, itemStack.copy());
        Containers.dropContents((Level)Objects.requireNonNull(this.level), (BlockPos)this.worldPosition, (Container)block);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, Roost_Tile pEntity) {
        if (level.isClientSide()) {
            return;
        }
        Roost_Tile.setChanged((Level)level, (BlockPos)pos, (BlockState)state);
        if (Roost_Tile.hasRecipe(pEntity)) {
            ++pEntity.progress;
            if (pEntity.progress >= pEntity.maxProgress) {
                Roost_Tile.craftItem(pEntity);
            }
        } else {
            pEntity.resetProgress();
            Roost_Tile.setChanged((Level)level, (BlockPos)pos, (BlockState)state);
        }
    }

    private void resetProgress() {
        this.progress = 0;
    }

    public static RecipeInput getRecipeInput(final SimpleContainer inventory) {
        return new RecipeInput(){

            public ItemStack getItem(int index) {
                return inventory.getItem(index).copy();
            }

            public int size() {
                return inventory.getContainerSize();
            }
        };
    }

    private static void craftItem(Roost_Tile pEntity) {
        MyChicken = (ChickenItemBase)pEntity.itemHandler.getStackInSlot(1).getItem().getDefaultInstance().getItem();
        ChickenItem = pEntity.itemHandler.getStackInSlot(1);
        FoodItem = (ChickenSeedBase)pEntity.itemHandler.getStackInSlot(0).getItem().getDefaultInstance().getItem();
        Level level = pEntity.level;
        SimpleContainer inventory = new SimpleContainer(pEntity.itemHandler.getSlots());
        for (int i = 0; i < pEntity.itemHandler.getSlots(); ++i) {
            inventory.setItem(i, pEntity.itemHandler.getStackInSlot(i));
        }
        Optional recipe = Optional.empty();
        if (level != null) {
            recipe = level.getRecipeManager().getRecipeFor(ModRecipes.ROOST_TYPE.get(), Roost_Tile.getRecipeInput(inventory), level);
        }
        RecipeHolder recipeholder = (RecipeHolder)recipe.get();
        Roost_Recipe craftingrecipe = (Roost_Recipe)recipeholder.value();
        if (Roost_Tile.hasRecipe(pEntity)) {
            int ChickenXP;
            int ChickenLevel;
            if (ChickenItem.has(ModDataComponents.CHICKENLEVEL) && ChickenItem.has(ModDataComponents.CHICKENXP)) {
                ChickenLevel = (Integer)ChickenItem.get((DataComponentType)ModDataComponents.CHICKENLEVEL.value()) / 2 + ((Roost_Recipe)((RecipeHolder)recipe.get()).value()).output.getCount();
                ChickenXP = (Integer)ChickenItem.get((DataComponentType)ModDataComponents.CHICKENXP.value());
            } else {
                ChickenLevel = 0;
                ChickenXP = 0;
                ChickenItem.set((DataComponentType)ModDataComponents.CHICKENLEVEL.value(), (Object)ChickenLevel);
                ChickenItem.set((DataComponentType)ModDataComponents.CHICKENXP.value(), (Object)ChickenXP);
            }
            ItemStack itemstack1 = ((Roost_Recipe)((RecipeHolder)recipe.get()).value()).assemble(Roost_Tile.getRecipeInput(inventory), (HolderLookup.Provider)level.registryAccess());
            itemstack1.setCount(pEntity.itemHandler.getStackInSlot(2).getCount() + ChickenLevel);
            if (pEntity.itemHandler.getStackInSlot(1).getItem() instanceof ChickenItemBase) {
                if ((Integer)ChickenItem.get((DataComponentType)ModDataComponents.CHICKENLEVEL.value()) < pEntity.LevelList[Roost_Tile.MyChicken.currentchickena]) {
                    if (pEntity.itemHandler.getStackInSlot(0).getItem() instanceof ChickenSeedBase) {
                        if ((float)ChickenXP + (float)pEntity.XPAmountList[ChickenSeedBase.currentmaxxpp] * ((Float)Config.roostxp.get()).floatValue() >= (float)pEntity.XPList[Roost_Tile.MyChicken.currentchickena]) {
                            ChickenItem.set((DataComponentType)ModDataComponents.CHICKENLEVEL.value(), (Object)((Integer)ChickenItem.get((DataComponentType)ModDataComponents.CHICKENLEVEL.value()) + 1));
                            ChickenItem.set((DataComponentType)ModDataComponents.CHICKENXP.value(), (Object)0);
                        } else {
                            ChickenItem.set((DataComponentType)ModDataComponents.CHICKENXP.value(), (Object)((int)((float)ChickenXP + (float)pEntity.XPAmountList[ChickenSeedBase.currentmaxxpp] * ((Float)Config.roostxp.get()).floatValue())));
                        }
                    }
                    pEntity.itemHandler.extractItem(0, 1, false);
                    pEntity.itemHandler.extractItem(1, 0, true);
                    pEntity.itemHandler.setStackInSlot(1, ChickenItem);
                    pEntity.itemHandler.setStackInSlot(2, itemstack1.copy());
                    pEntity.resetProgress();
                } else {
                    pEntity.itemHandler.extractItem(0, 1, false);
                    pEntity.itemHandler.extractItem(1, 0, true);
                    pEntity.itemHandler.setStackInSlot(2, itemstack1.copy());
                    pEntity.resetProgress();
                }
            }
        }
    }

    private static boolean hasRecipe(Roost_Tile entity) {
        Level level = entity.level;
        SimpleContainer inventory = new SimpleContainer(entity.itemHandler.getSlots());
        for (int i = 0; i < entity.itemHandler.getSlots(); ++i) {
            inventory.setItem(i, entity.itemHandler.getStackInSlot(i));
        }
        Optional recipe = Optional.empty();
        if (level != null && (recipe = level.getRecipeManager().getRecipeFor(ModRecipes.ROOST_TYPE.get(), Roost_Tile.getRecipeInput(inventory), level)).isPresent()) {
            entity.maxProgress = (Integer)Config.roost_speed_tick.get() * ((Roost_Recipe)((RecipeHolder)recipe.get()).value()).time;
        }
        return recipe.isPresent() && Roost_Tile.canInsertAmountIntoOutputSlot(inventory) && Roost_Tile.canInsertItemIntoOutputSlot(inventory, ((Roost_Recipe)((RecipeHolder)recipe.get()).value()).output.copy().getItem().getDefaultInstance());
    }

    private static boolean canInsertItemIntoOutputSlot(SimpleContainer inventory, ItemStack stack) {
        return inventory.getItem(2).getItem() == stack.getItem() || inventory.getItem(2).isEmpty();
    }

    private static boolean canInsertAmountIntoOutputSlot(SimpleContainer inventory) {
        return inventory.getItem(2).getMaxStackSize() > inventory.getItem(2).getCount();
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider prov) {
        return this.saveWithFullMetadata(prov);
    }
}

