/*
 * Decompiled with CFR 0.152.
 */
package net.tarantel.chickenroost.handler;

import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.common.extensions.IMenuTypeExtension;
import net.neoforged.neoforge.network.IContainerFactory;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.tarantel.chickenroost.handler.Breeder_Handler;
import net.tarantel.chickenroost.handler.Guide_Handler;
import net.tarantel.chickenroost.handler.Roost_Handler;
import net.tarantel.chickenroost.handler.SoulBreeder_Handler;
import net.tarantel.chickenroost.handler.SoulExtractor_Handler;
import net.tarantel.chickenroost.handler.Trainer_Handler;

public class ModHandlers {
    public static final DeferredRegister<MenuType<?>> MENU_TYPES = DeferredRegister.create((ResourceKey)Registries.MENU, (String)"chicken_roost");
    public static final Supplier<MenuType<SoulBreeder_Handler>> SOUL_BREEDER_MENU = ModHandlers.registerMenuType(SoulBreeder_Handler::new, "new_soul_breeder_menu");
    public static final Supplier<MenuType<Breeder_Handler>> BREEDER_MENU = ModHandlers.registerMenuType(Breeder_Handler::new, "breeder_menu");
    public static final Supplier<MenuType<SoulExtractor_Handler>> SOUL_EXTRACTOR_MENU = ModHandlers.registerMenuType(SoulExtractor_Handler::new, "soul_extractor_menu");
    public static final Supplier<MenuType<Roost_Handler>> ROOST_MENU_V1 = ModHandlers.registerMenuType(Roost_Handler::new, "roost_menu_v1");
    public static final Supplier<MenuType<Trainer_Handler>> TRAINER = ModHandlers.registerMenuType(Trainer_Handler::new, "trainer");
    public static final Supplier<MenuType<Guide_Handler>> GUIDE = ModHandlers.registerMenuType(Guide_Handler::new, "guide");

    private static <T extends AbstractContainerMenu> Supplier<MenuType<T>> registerMenuType(IContainerFactory<T> factory, String name) {
        return MENU_TYPES.register(name, () -> IMenuTypeExtension.create((IContainerFactory)factory));
    }

    public static void register(IEventBus eventBus) {
        MENU_TYPES.register(eventBus);
    }
}

