/*
 * Decompiled with CFR 0.152.
 */
package net.tarantel.chickenroost.item.base;

import de.cech12.bucketlib.api.item.UniversalBucketItem;
import de.cech12.bucketlib.platform.Services;
import de.cech12.bucketlib.util.BucketLibUtil;
import de.cech12.bucketlib.util.RegistryUtil;
import de.cech12.bucketlib.util.WorldInteractionUtil;
import java.util.Arrays;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponents;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.util.Tuple;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.animal.Bucketable;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.tarantel.chickenroost.util.CustomWorldInteractionUtil;

public class myownbucket
extends UniversalBucketItem {
    private DataComponentMap components;

    public myownbucket(UniversalBucketItem.Properties properties) {
        super(properties);
    }

    public int getMaxStackSize(ItemStack stack) {
        return 64;
    }

    @Nonnull
    public InteractionResultHolder<ItemStack> use(@Nonnull Level level, @Nonnull Player player, @Nonnull InteractionHand interactionHand) {
        ItemStack itemstack = player.getItemInHand(interactionHand);
        boolean isEmpty = BucketLibUtil.isEmpty((ItemStack)itemstack);
        BlockHitResult blockHitResult = myownbucket.getPlayerPOVHitResult((Level)level, (Player)player, (ClipContext.Fluid)(isEmpty ? ClipContext.Fluid.SOURCE_ONLY : ClipContext.Fluid.NONE));
        if (blockHitResult.getType() == HitResult.Type.BLOCK) {
            ServerLevel serverLevel;
            BlockPos hitBlockPos = blockHitResult.getBlockPos();
            BlockState hitBlockState = level.getBlockState(hitBlockPos);
            Direction hitDirection = blockHitResult.getDirection();
            BlockPos relativeBlockPos = hitBlockPos.relative(hitDirection);
            ServerLevel serverLevel2 = serverLevel = level instanceof ServerLevel ? (ServerLevel)level : null;
            if (isEmpty) {
                InteractionResultHolder<ItemStack> caldronInteractionResult = CustomWorldInteractionUtil.tryPickupFromCauldron(level, player, interactionHand, blockHitResult);
                if (caldronInteractionResult.getResult().consumesAction()) {
                    return caldronInteractionResult;
                }
                Tuple result = Services.FLUID.tryPickUpFluid(BucketLibUtil.removeEntityType((ItemStack)itemstack, (ServerLevel)serverLevel, (Player)player, (boolean)false), player, level, interactionHand, hitBlockPos, hitDirection);
                if (((Boolean)result.getA()).booleanValue()) {
                    itemstack.shrink(1);
                    return InteractionResultHolder.sidedSuccess((Object)itemstack, (boolean)level.isClientSide());
                }
                RegistryUtil.BucketBlock bucketBlock = RegistryUtil.getBucketBlock((Block)hitBlockState.getBlock());
                if (bucketBlock != null && this.canHoldBlock(bucketBlock.block())) {
                    ItemStack fakeStack = new ItemStack((ItemLike)Items.BUCKET);
                    player.getItemInHand(interactionHand).shrink(1);
                    InteractionResultHolder interactionResult = fakeStack.use(level, player, interactionHand);
                    player.getItemInHand(interactionHand).shrink(1);
                    if (interactionResult.getResult().consumesAction()) {
                        itemstack.shrink(1);
                        return InteractionResultHolder.sidedSuccess((Object)itemstack, (boolean)level.isClientSide());
                    }
                }
            } else {
                InteractionResultHolder<ItemStack> caldronInteractionResult = CustomWorldInteractionUtil.tryPlaceIntoCauldron(level, player, interactionHand, blockHitResult);
                if (caldronInteractionResult.getResult().consumesAction()) {
                    return caldronInteractionResult;
                }
                if (BucketLibUtil.containsFluid((ItemStack)itemstack)) {
                    for (BlockPos pos : Arrays.asList(hitBlockPos, relativeBlockPos)) {
                        Tuple result = Services.FLUID.tryPlaceFluid(itemstack, player, level, interactionHand, pos);
                        if (!((Boolean)result.getA()).booleanValue()) continue;
                        if (BucketLibUtil.containsEntityType((ItemStack)itemstack)) {
                            this.spawnEntityFromBucket(player, level, itemstack, pos, false);
                        }
                        itemstack.shrink(1);
                        return InteractionResultHolder.sidedSuccess((Object)itemstack, (boolean)level.isClientSide());
                    }
                } else {
                    if (BucketLibUtil.containsEntityType((ItemStack)itemstack)) {
                        ItemStack emptyBucket = this.spawnEntityFromBucket(player, level, itemstack, relativeBlockPos, true);
                        return InteractionResultHolder.sidedSuccess((Object)ItemStack.EMPTY, (boolean)level.isClientSide());
                    }
                    if (BucketLibUtil.containsBlock((ItemStack)itemstack)) {
                        ItemStack fakeStack;
                        InteractionResult interactionResult;
                        Block block = BucketLibUtil.getBlock((ItemStack)itemstack);
                        RegistryUtil.BucketBlock bucketBlock = RegistryUtil.getBucketBlock((Block)block);
                        if (block != null && bucketBlock != null && (interactionResult = (fakeStack = new ItemStack((ItemLike)bucketBlock.bucketItem())).useOn(new UseOnContext(player, interactionHand, blockHitResult))).consumesAction()) {
                            return new InteractionResultHolder(interactionResult, (Object)ItemStack.EMPTY);
                        }
                    }
                }
            }
        }
        return BucketLibUtil.containsMilk((ItemStack)itemstack) ? ItemUtils.startUsingInstantly((Level)level, (Player)player, (InteractionHand)interactionHand) : InteractionResultHolder.pass((Object)itemstack);
    }

    public ItemStack spawnEntityFromBucket(@Nullable Player player, Level level, ItemStack itemStack, BlockPos pos, boolean damage) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            EntityType entityType = BucketLibUtil.getEntityType((ItemStack)itemStack);
            if (entityType != null) {
                Entity entity = entityType.spawn(serverLevel, itemStack, (Player)null, pos, MobSpawnType.BUCKET, true, false);
                if (entity instanceof Bucketable) {
                    Bucketable bucketable = (Bucketable)entity;
                    CustomData customdata = (CustomData)itemStack.getOrDefault(DataComponents.BUCKET_ENTITY_DATA, (Object)CustomData.EMPTY);
                    bucketable.loadFromBucketTag(customdata.copyTag());
                    bucketable.setFromBucket(true);
                }
                if (player != null) {
                    serverLevel.gameEvent((Entity)player, (Holder)GameEvent.ENTITY_PLACE, pos);
                }
                return BucketLibUtil.removeEntityType((ItemStack)itemStack, (ServerLevel)serverLevel, (Player)player, (boolean)damage);
            }
        }
        return itemStack.copy();
    }

    public void inventoryTick(@Nonnull ItemStack itemStack, Level level, Entity entity, int position, boolean selected) {
    }

    @Nonnull
    public InteractionResult interactLivingEntity(@Nonnull ItemStack itemStack, @Nonnull Player player, @Nonnull LivingEntity entity, @Nonnull InteractionHand interactionHand) {
        InteractionResult result;
        if (entity instanceof Bucketable && !BucketLibUtil.containsEntityType((ItemStack)itemStack) && this.canHoldEntity(entity.getType()) && (result = this.pickupEntityWithBucket(player, interactionHand, (LivingEntity)((Bucketable)entity))).consumesAction()) {
            return result;
        }
        return this.canMilkEntities() && BucketLibUtil.isEmpty((ItemStack)itemStack) ? WorldInteractionUtil.tryMilkLivingEntity((ItemStack)itemStack, (LivingEntity)entity, (Player)player, (InteractionHand)interactionHand) : super.interactLivingEntity(itemStack, player, entity, interactionHand);
    }

    private <T extends LivingEntity> InteractionResult pickupEntityWithBucket(Player player, InteractionHand interactionHand, LivingEntity entity) {
        ItemStack itemStack = player.getItemInHand(interactionHand).copy();
        Fluid containedFluid = Services.FLUID.getContainedFluid(itemStack);
        Fluid entityBucketFluid = Services.BUCKET.getFluidOfBucketItem((BucketItem)((Bucketable)entity).getBucketItemStack().getItem());
        if (itemStack.getItem() instanceof UniversalBucketItem && entity.isAlive() && entityBucketFluid == containedFluid) {
            entity.playSound(((Bucketable)entity).getPickupSound(), 1.0f, 1.0f);
            ItemStack filledItemStack = BucketLibUtil.addEntityType((ItemStack)itemStack, (EntityType)entity.getType());
            ((Bucketable)entity).saveToBucketTag(filledItemStack);
            Level level = entity.level();
            ItemStack handItemStack = ItemUtils.createFilledResult((ItemStack)itemStack, (Player)player, (ItemStack)filledItemStack, (boolean)false);
            player.setItemInHand(interactionHand, handItemStack);
            if (!level.isClientSide) {
                CriteriaTriggers.FILLED_BUCKET.trigger((ServerPlayer)player, new ItemStack((ItemLike)((Bucketable)entity).getBucketItemStack().getItem()));
            }
            entity.discard();
            return InteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        return InteractionResult.PASS;
    }

    @Nonnull
    public ItemStack finishUsingItem(@Nonnull ItemStack itemStack, @Nonnull Level level, @Nonnull LivingEntity player) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            CriteriaTriggers.CONSUME_ITEM.trigger(serverPlayer, new ItemStack((ItemLike)Items.MILK_BUCKET));
            serverPlayer.awardStat(Stats.ITEM_USED.get((Object)Items.MILK_BUCKET));
        }
        if (!level.isClientSide) {
            Services.FLUID.curePotionEffects(player, new ItemStack((ItemLike)Items.MILK_BUCKET));
            if (BucketLibUtil.notCreative((Entity)player)) {
                return BucketLibUtil.removeMilk((ItemStack)itemStack, (ServerLevel)((ServerLevel)level), (Player)(player instanceof Player ? (Player)player : null));
            }
        }
        return itemStack;
    }
}

