/*
 * Decompiled with CFR 0.152.
 */
package net.tarantel.chickenroost.block.tile;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemContainerContents;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.tarantel.chickenroost.ChickenRoostMod;
import net.tarantel.chickenroost.block.blocks.ModBlocks;
import net.tarantel.chickenroost.block.tile.InputOutputItemHandler;
import net.tarantel.chickenroost.block.tile.ModBlockEntities;
import net.tarantel.chickenroost.handler.Breeder_Handler;
import net.tarantel.chickenroost.item.base.ChickenItemBase;
import net.tarantel.chickenroost.item.base.ChickenSeedBase;
import net.tarantel.chickenroost.recipes.Breeder_Recipe;
import net.tarantel.chickenroost.recipes.ModRecipes;
import net.tarantel.chickenroost.util.Config;
import net.tarantel.chickenroost.util.NumberIncrementer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Breeder_Tile
extends BlockEntity
implements MenuProvider {
    public static int x;
    public static int y;
    public static int z;
    public int progress = 0;
    public int maxProgress = (Integer)Config.breed_speed_tick.get() * 20;
    public final ItemStackHandler itemHandler = new ItemStackHandler(11){

        protected void onContentsChanged(int slot) {
            Breeder_Tile.this.setChanged();
            if (slot == 0 || slot == 2) {
                Breeder_Tile.this.resetProgress();
            }
            if (!Breeder_Tile.this.level.isClientSide()) {
                Breeder_Tile.this.level.sendBlockUpdated(Breeder_Tile.this.getBlockPos(), Breeder_Tile.this.getBlockState(), Breeder_Tile.this.getBlockState(), 3);
            }
        }

        public int getSlotLimit(int slot) {
            if (slot == 1) {
                return 64;
            }
            if (slot == 0) {
                return 1;
            }
            if (slot == 2) {
                return 1;
            }
            if (slot == 3) {
                return 1;
            }
            if (slot == 4) {
                return 1;
            }
            if (slot == 5) {
                return 1;
            }
            if (slot == 6) {
                return 1;
            }
            if (slot == 7) {
                return 1;
            }
            if (slot == 8) {
                return 1;
            }
            if (slot == 9) {
                return 1;
            }
            if (slot == 10) {
                return 1;
            }
            return 0;
        }

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            return switch (slot) {
                case 0 -> stack.getItem() instanceof ChickenItemBase;
                case 2 -> stack.getItem() instanceof ChickenItemBase;
                case 1 -> stack.getItem() instanceof ChickenSeedBase;
                case 3 -> false;
                case 4 -> false;
                case 5 -> false;
                case 6 -> false;
                case 7 -> false;
                case 8 -> false;
                case 9 -> false;
                case 10 -> false;
                default -> super.isItemValid(slot, stack);
            };
        }
    };
    protected final ContainerData data;
    private final IItemHandler itemHandlerSided = new InputOutputItemHandler((IItemHandlerModifiable)this.itemHandler, (i, stack) -> i == 0 || i == 1 || i == 2, i -> i == 3 || i == 4 || i == 5 || i == 6 || i == 7 || i == 8 || i == 9 || i == 10);
    static ItemStack ChickenOutput;

    public ItemStack getRenderStack1() {
        ItemStack stack = !this.itemHandler.getStackInSlot(0).isEmpty() ? this.itemHandler.getStackInSlot(0) : ItemStack.EMPTY;
        return stack;
    }

    public ItemStack getRenderStack2() {
        ItemStack stack = !this.itemHandler.getStackInSlot(2).isEmpty() ? this.itemHandler.getStackInSlot(2) : ItemStack.EMPTY;
        return stack;
    }

    public ItemStack getRenderStack3() {
        ItemStack stack = !this.itemHandler.getStackInSlot(1).isEmpty() ? this.itemHandler.getStackInSlot(1) : ItemStack.EMPTY;
        return stack;
    }

    public void setHandler(ItemStackHandler itemStackHandler) {
        for (int i = 0; i < itemStackHandler.getSlots(); ++i) {
            this.itemHandler.setStackInSlot(i, itemStackHandler.getStackInSlot(i));
        }
    }

    public int getScaledProgress() {
        int progresss = this.progress;
        int maxProgresss = this.maxProgress;
        int progressArrowSize = 200;
        return maxProgresss != 0 && progresss != 0 ? progresss * progressArrowSize / maxProgresss : 0;
    }

    public Breeder_Tile(BlockPos pos, BlockState state) {
        super(ModBlockEntities.BREEDER.get(), pos, state);
        x = pos.getX();
        y = pos.getY();
        z = pos.getZ();
        this.data = new ContainerData(){

            public int get(int index) {
                return switch (index) {
                    case 0 -> Breeder_Tile.this.progress;
                    case 1 -> Breeder_Tile.this.maxProgress;
                    default -> 0;
                };
            }

            public void set(int index, int value) {
                switch (index) {
                    case 0: {
                        Breeder_Tile.this.progress = value;
                        break;
                    }
                    case 1: {
                        Breeder_Tile.this.maxProgress = value;
                    }
                }
            }

            public int getCount() {
                return 2;
            }
        };
    }

    @NotNull
    public Component getDisplayName() {
        return Component.translatable((String)"");
    }

    @Nullable
    public AbstractContainerMenu createMenu(int id, @NotNull Inventory inventory, @NotNull Player player) {
        return new Breeder_Handler(id, inventory, this, this.data);
    }

    @Nullable
    public IItemHandler getItemHandlerCapability(@Nullable Direction side) {
        if (side == null) {
            return this.itemHandler;
        }
        return this.itemHandlerSided;
    }

    public void onLoad() {
        super.onLoad();
        this.setChanged();
    }

    public void saveAdditional(CompoundTag nbt, HolderLookup.Provider lookup) {
        nbt.put("inventory", (Tag)this.itemHandler.serializeNBT(lookup));
        nbt.putInt("breeder.progress", this.progress);
        super.saveAdditional(nbt, lookup);
    }

    public void loadAdditional(CompoundTag nbt, HolderLookup.Provider lookup) {
        super.loadAdditional(nbt, lookup);
        this.itemHandler.deserializeNBT(lookup, nbt.getCompound("inventory"));
        this.progress = nbt.getInt("breeder.progress");
    }

    public void drops() {
        SimpleContainer inventory = new SimpleContainer(this.itemHandler.getSlots());
        SimpleContainer block = new SimpleContainer(1);
        ItemStack itemStack = new ItemStack((ItemLike)ModBlocks.BREEDER.get());
        NonNullList items = inventory.getItems();
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            items.set(i, (Object)this.itemHandler.getStackInSlot(i));
        }
        itemStack.set(DataComponents.CONTAINER, (Object)ItemContainerContents.fromItems((List)inventory.getItems()));
        block.setItem(0, itemStack.copy());
        Containers.dropContents((Level)Objects.requireNonNull(this.level), (BlockPos)this.worldPosition, (Container)block);
    }

    public static void tick(Level levelL, BlockPos pos, BlockState state, Breeder_Tile pEntity) {
        if (levelL.isClientSide()) {
            return;
        }
        Breeder_Tile.setChanged((Level)levelL, (BlockPos)pos, (BlockState)state);
        if (Breeder_Tile.hasRecipe(pEntity) && (pEntity.itemHandler.getStackInSlot(3) == ItemStack.EMPTY || pEntity.itemHandler.getStackInSlot(4) == ItemStack.EMPTY || pEntity.itemHandler.getStackInSlot(5) == ItemStack.EMPTY || pEntity.itemHandler.getStackInSlot(6) == ItemStack.EMPTY || pEntity.itemHandler.getStackInSlot(7) == ItemStack.EMPTY || pEntity.itemHandler.getStackInSlot(8) == ItemStack.EMPTY || pEntity.itemHandler.getStackInSlot(9) == ItemStack.EMPTY || pEntity.itemHandler.getStackInSlot(10) == ItemStack.EMPTY)) {
            ++pEntity.progress;
            if (pEntity.progress >= pEntity.maxProgress) {
                Breeder_Tile.craftItem(pEntity);
            }
        } else {
            pEntity.resetProgress();
            Breeder_Tile.setChanged((Level)levelL, (BlockPos)pos, (BlockState)state);
        }
    }

    private void resetProgress() {
        this.progress = 0;
    }

    private static void craftItem(Breeder_Tile pEntity) {
        Level level = pEntity.level;
        SimpleContainer inventory = new SimpleContainer(pEntity.itemHandler.getSlots());
        for (int i = 0; i < pEntity.itemHandler.getSlots(); ++i) {
            inventory.setItem(i, pEntity.itemHandler.getStackInSlot(i));
        }
        List recipe = level.getRecipeManager().getRecipesFor((RecipeType)Breeder_Recipe.Type.INSTANCE, Breeder_Tile.getRecipeInput(inventory), level);
        try {
            if (Breeder_Tile.hasRecipe(pEntity)) {
                Random ran = new Random();
                int RandomOutputs = ran.nextInt(recipe.size());
                ChickenOutput = new ItemStack((ItemLike)((Breeder_Recipe)((RecipeHolder)recipe.get((int)RandomOutputs)).value()).output.getItem());
                if (pEntity.itemHandler.getStackInSlot(3) == ItemStack.EMPTY) {
                    pEntity.itemHandler.extractItem(0, 0, true);
                    pEntity.itemHandler.extractItem(2, 0, true);
                    pEntity.itemHandler.extractItem(1, 1, false);
                    pEntity.itemHandler.setStackInSlot(3, ChickenOutput);
                    pEntity.resetProgress();
                } else if (pEntity.itemHandler.getStackInSlot(4) == ItemStack.EMPTY) {
                    pEntity.itemHandler.extractItem(2, 0, true);
                    pEntity.itemHandler.extractItem(0, 0, true);
                    pEntity.itemHandler.extractItem(1, 1, false);
                    pEntity.itemHandler.setStackInSlot(4, ChickenOutput);
                    pEntity.resetProgress();
                } else if (pEntity.itemHandler.getStackInSlot(5) == ItemStack.EMPTY) {
                    pEntity.itemHandler.extractItem(0, 0, true);
                    pEntity.itemHandler.extractItem(2, 0, true);
                    pEntity.itemHandler.extractItem(1, 1, false);
                    pEntity.itemHandler.setStackInSlot(5, ChickenOutput);
                    pEntity.resetProgress();
                } else if (pEntity.itemHandler.getStackInSlot(6) == ItemStack.EMPTY) {
                    pEntity.itemHandler.extractItem(0, 0, true);
                    pEntity.itemHandler.extractItem(2, 0, true);
                    pEntity.itemHandler.extractItem(1, 1, false);
                    pEntity.itemHandler.setStackInSlot(6, ChickenOutput);
                    pEntity.resetProgress();
                } else if (pEntity.itemHandler.getStackInSlot(7) == ItemStack.EMPTY) {
                    pEntity.itemHandler.extractItem(0, 0, true);
                    pEntity.itemHandler.extractItem(2, 0, true);
                    pEntity.itemHandler.extractItem(1, 1, false);
                    pEntity.itemHandler.setStackInSlot(7, ChickenOutput);
                    pEntity.resetProgress();
                } else if (pEntity.itemHandler.getStackInSlot(8) == ItemStack.EMPTY) {
                    pEntity.itemHandler.extractItem(0, 0, true);
                    pEntity.itemHandler.extractItem(2, 0, true);
                    pEntity.itemHandler.extractItem(1, 1, false);
                    pEntity.itemHandler.setStackInSlot(8, ChickenOutput);
                    pEntity.resetProgress();
                } else if (pEntity.itemHandler.getStackInSlot(9) == ItemStack.EMPTY) {
                    pEntity.itemHandler.extractItem(0, 0, true);
                    pEntity.itemHandler.extractItem(2, 0, true);
                    pEntity.itemHandler.extractItem(1, 1, false);
                    pEntity.itemHandler.setStackInSlot(9, ChickenOutput);
                    pEntity.resetProgress();
                } else if (pEntity.itemHandler.getStackInSlot(10) == ItemStack.EMPTY) {
                    pEntity.itemHandler.extractItem(0, 0, true);
                    pEntity.itemHandler.extractItem(2, 0, true);
                    pEntity.itemHandler.extractItem(1, 1, false);
                    pEntity.itemHandler.setStackInSlot(10, ChickenOutput);
                    pEntity.resetProgress();
                } else {
                    pEntity.resetProgress();
                }
            } else {
                pEntity.resetProgress();
            }
            try {
                NumberIncrementer.sendChickenCounter(1);
            }
            catch (IOException e) {
                ChickenRoostMod.LOGGER.error("Failed to send startup counter to server: {}", (Object)e.getMessage());
                ChickenRoostMod.LOGGER.debug("Stack trace:", (Throwable)e);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static boolean hasRecipe(Breeder_Tile entity) {
        Level level = entity.level;
        SimpleContainer inventory = new SimpleContainer(entity.itemHandler.getSlots());
        for (int i = 0; i < entity.itemHandler.getSlots(); ++i) {
            inventory.setItem(i, entity.itemHandler.getStackInSlot(i));
        }
        Optional recipe = Optional.empty();
        if (level != null && (recipe = level.getRecipeManager().getRecipeFor(ModRecipes.BASIC_BREEDING_TYPE.get(), Breeder_Tile.getRecipeInput(inventory), level)).isPresent()) {
            entity.maxProgress = (Integer)Config.breed_speed_tick.get() * ((Breeder_Recipe)((RecipeHolder)recipe.get()).value()).time;
        }
        return recipe.isPresent();
    }

    public static RecipeInput getRecipeInput(final SimpleContainer inventory) {
        return new RecipeInput(){

            public ItemStack getItem(int index) {
                return inventory.getItem(index).copy();
            }

            public int size() {
                return inventory.getContainerSize();
            }
        };
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider prov) {
        return this.saveWithFullMetadata(prov);
    }

    static {
        ChickenOutput = ItemStack.EMPTY;
    }
}

