/*
 * Decompiled with CFR 0.152.
 */
package net.tarantel.chickenroost.block.tile;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemContainerContents;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.tarantel.chickenroost.ChickenRoostMod;
import net.tarantel.chickenroost.block.blocks.ModBlocks;
import net.tarantel.chickenroost.block.tile.InputOutputItemHandler;
import net.tarantel.chickenroost.block.tile.ModBlockEntities;
import net.tarantel.chickenroost.handler.SoulBreeder_Handler;
import net.tarantel.chickenroost.item.base.ChickenItemBase;
import net.tarantel.chickenroost.recipes.ModRecipes;
import net.tarantel.chickenroost.recipes.Soul_Breeder_Recipe;
import net.tarantel.chickenroost.util.Config;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoBlockEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.Animation;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;
import software.bernie.geckolib.util.RenderUtil;

public class Soul_Breeder_Tile
extends BlockEntity
implements MenuProvider,
GeoBlockEntity {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    public final ItemStackHandler itemHandler = new ItemStackHandler(3){

        protected void onContentsChanged(int slot) {
            Soul_Breeder_Tile.this.setChanged();
            if (slot == 1) {
                Soul_Breeder_Tile.this.resetProgress();
            }
            if (!Soul_Breeder_Tile.this.level.isClientSide()) {
                Soul_Breeder_Tile.this.level.sendBlockUpdated(Soul_Breeder_Tile.this.getBlockPos(), Soul_Breeder_Tile.this.getBlockState(), Soul_Breeder_Tile.this.getBlockState(), 3);
            }
        }

        public int getSlotLimit(int slot) {
            if (slot == 0) {
                return 64;
            }
            if (slot == 1) {
                return 1;
            }
            if (slot == 2) {
                return 64;
            }
            return 0;
        }

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            return switch (slot) {
                case 0 -> stack.is(ItemTags.create((ResourceLocation)ChickenRoostMod.commonsource("roost/souls")));
                case 1 -> stack.getItem() instanceof ChickenItemBase;
                case 2 -> false;
                default -> super.isItemValid(slot, stack);
            };
        }
    };
    protected final ContainerData data;
    public int progress = 0;
    private int crafttimer = 20;
    private boolean startcraft = false;
    public int maxProgress = (Integer)Config.soulbreed_speedtimer.get() * 20;
    private final IItemHandler itemHandlerSided = new InputOutputItemHandler((IItemHandlerModifiable)this.itemHandler, (i, stack) -> i == 0 || i == 1, i -> i == 2);
    private static final RawAnimation CRAFTING = RawAnimation.begin().then("crafting.idle", Animation.LoopType.LOOP);
    private static final RawAnimation IDLE = RawAnimation.begin().then("normal.idle", Animation.LoopType.LOOP);
    private static final RawAnimation FINISH = RawAnimation.begin().then("crafting.finish2", Animation.LoopType.PLAY_ONCE);

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public double getTick(Object blockEntity) {
        return RenderUtil.getCurrentTick();
    }

    public ItemStack getRenderStack() {
        ItemStack stack = !this.itemHandler.getStackInSlot(1).isEmpty() ? this.itemHandler.getStackInSlot(1) : ItemStack.EMPTY;
        return stack;
    }

    public ItemStack getRenderStackInput() {
        ItemStack stack = !this.itemHandler.getStackInSlot(0).isEmpty() ? this.itemHandler.getStackInSlot(0) : ItemStack.EMPTY;
        return stack;
    }

    public void setHandler(ItemStackHandler itemStackHandler) {
        for (int i = 0; i < itemStackHandler.getSlots(); ++i) {
            this.itemHandler.setStackInSlot(i, itemStackHandler.getStackInSlot(i));
        }
    }

    public int getScaledProgress() {
        int progresss = this.progress;
        int maxProgresss = this.maxProgress;
        int progressArrowSize = 200;
        return maxProgresss != 0 && progresss != 0 ? progresss * progressArrowSize / maxProgresss : 0;
    }

    public Soul_Breeder_Tile(BlockPos pos, BlockState state) {
        super(ModBlockEntities.SOUL_BREEDER.get(), pos, state);
        this.data = new ContainerData(){

            public int get(int index) {
                return switch (index) {
                    case 0 -> Soul_Breeder_Tile.this.progress;
                    case 1 -> Soul_Breeder_Tile.this.maxProgress;
                    default -> 0;
                };
            }

            public void set(int index, int value) {
                switch (index) {
                    case 0: {
                        Soul_Breeder_Tile.this.progress = value;
                        break;
                    }
                    case 1: {
                        Soul_Breeder_Tile.this.maxProgress = value;
                    }
                }
            }

            public int getCount() {
                return 2;
            }
        };
    }

    public Component getDisplayName() {
        return Component.translatable((String)"name.chicken_roost.soul_breeder");
    }

    @Nullable
    public AbstractContainerMenu createMenu(int id, @NotNull Inventory inventory, @NotNull Player player) {
        return new SoulBreeder_Handler(id, inventory, this, this.data);
    }

    @Nullable
    public IItemHandler getItemHandlerCapability(@Nullable Direction side) {
        if (side == null) {
            return this.itemHandler;
        }
        return this.itemHandlerSided;
    }

    public void onLoad() {
        super.onLoad();
        this.setChanged();
        if (!this.level.isClientSide()) {
            this.level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 3);
        }
    }

    public void saveAdditional(CompoundTag nbt, HolderLookup.Provider lookup) {
        nbt.put("inventory", (Tag)this.itemHandler.serializeNBT(lookup));
        nbt.putInt("soul_breeder.progress", this.progress);
        super.saveAdditional(nbt, lookup);
    }

    public void loadAdditional(CompoundTag nbt, HolderLookup.Provider lookup) {
        super.loadAdditional(nbt, lookup);
        this.itemHandler.deserializeNBT(lookup, nbt.getCompound("inventory"));
        this.progress = nbt.getInt("soul_breeder.progress");
        this.setChanged();
        this.getRenderStack();
    }

    public void drops() {
        SimpleContainer inventory = new SimpleContainer(this.itemHandler.getSlots());
        SimpleContainer block = new SimpleContainer(1);
        ItemStack itemStack = new ItemStack((ItemLike)ModBlocks.SOUL_BREEDER.get());
        NonNullList items = inventory.getItems();
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            items.set(i, (Object)this.itemHandler.getStackInSlot(i));
        }
        itemStack.set(DataComponents.CONTAINER, (Object)ItemContainerContents.fromItems((List)inventory.getItems()));
        block.setItem(0, itemStack.copy());
        Containers.dropContents((Level)Objects.requireNonNull(this.level), (BlockPos)this.worldPosition, (Container)block);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, Soul_Breeder_Tile pEntity) {
        if (level.isClientSide()) {
            return;
        }
        if (pEntity.startcraft) {
            --pEntity.crafttimer;
        }
        if (pEntity.crafttimer <= 0) {
            pEntity.crafttimer = 20;
            pEntity.startcraft = false;
        }
        Soul_Breeder_Tile.setChanged((Level)level, (BlockPos)pos, (BlockState)state);
        if (Soul_Breeder_Tile.hasRecipe(pEntity) && !pEntity.startcraft) {
            ++pEntity.progress;
            pEntity.triggerAnim("controller", "craft");
            if (pEntity.progress >= pEntity.maxProgress) {
                pEntity.startcraft = true;
                Soul_Breeder_Tile.craftItem(pEntity);
            }
        }
        if (!Soul_Breeder_Tile.hasRecipe(pEntity) && !pEntity.startcraft) {
            pEntity.resetProgress();
            pEntity.triggerAnim("controller", "idle");
            Soul_Breeder_Tile.setChanged((Level)level, (BlockPos)pos, (BlockState)state);
        }
        if (Soul_Breeder_Tile.hasRecipe(pEntity) && pEntity.startcraft) {
            pEntity.triggerAnim("controller", "finish");
        }
    }

    private void resetProgress() {
        this.progress = 0;
    }

    private static void craftItem(Soul_Breeder_Tile pEntity) {
        Level level = pEntity.level;
        SimpleContainer inventory = new SimpleContainer(pEntity.itemHandler.getSlots());
        for (int i = 0; i < pEntity.itemHandler.getSlots(); ++i) {
            inventory.setItem(i, pEntity.itemHandler.getStackInSlot(i));
        }
        Optional recipe = Optional.empty();
        if (level != null) {
            recipe = level.getRecipeManager().getRecipeFor(ModRecipes.SOUL_BREEDING_TYPE.get(), Soul_Breeder_Tile.getRecipeInput(inventory), level);
        }
        ItemStack MyChicken = ((Soul_Breeder_Recipe)((RecipeHolder)recipe.get()).value()).output.copy().getItem().getDefaultInstance();
        MyChicken.setCount(pEntity.itemHandler.getStackInSlot(2).getCount() + 1);
        if (Soul_Breeder_Tile.hasRecipe(pEntity)) {
            pEntity.itemHandler.extractItem(0, 1, false);
            pEntity.itemHandler.extractItem(1, 0, true);
            pEntity.itemHandler.setStackInSlot(2, MyChicken);
            pEntity.resetProgress();
        }
    }

    private static boolean hasRecipe(Soul_Breeder_Tile entity) {
        Level level = entity.level;
        SimpleContainer inventory = new SimpleContainer(entity.itemHandler.getSlots());
        for (int i = 0; i < entity.itemHandler.getSlots(); ++i) {
            inventory.setItem(i, entity.itemHandler.getStackInSlot(i));
        }
        Optional recipe = Optional.empty();
        if (level != null && (recipe = level.getRecipeManager().getRecipeFor(ModRecipes.SOUL_BREEDING_TYPE.get(), Soul_Breeder_Tile.getRecipeInput(inventory), level)).isPresent()) {
            entity.maxProgress = (Integer)Config.soulbreed_speedtimer.get() * ((Soul_Breeder_Recipe)((RecipeHolder)recipe.get()).value()).time;
        }
        return recipe.isPresent() && Soul_Breeder_Tile.canInsertAmountIntoOutputSlot(inventory) && Soul_Breeder_Tile.canInsertItemIntoOutputSlot(inventory, ((Soul_Breeder_Recipe)((RecipeHolder)recipe.get()).value()).output.copy().getItem().getDefaultInstance());
    }

    public static RecipeInput getRecipeInput(final SimpleContainer inventory) {
        return new RecipeInput(){

            public ItemStack getItem(int index) {
                return inventory.getItem(index).copy();
            }

            public int size() {
                return inventory.getContainerSize();
            }
        };
    }

    private static boolean canInsertItemIntoOutputSlot(SimpleContainer inventory, ItemStack stack) {
        return inventory.getItem(2).getItem() == stack.getItem() || inventory.getItem(2).isEmpty();
    }

    private static boolean canInsertAmountIntoOutputSlot(SimpleContainer inventory) {
        return inventory.getItem(2).getMaxStackSize() > inventory.getItem(2).getCount();
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController((GeoAnimatable)this, "controller", 0, this::predicate));
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider prov) {
        return this.saveWithFullMetadata(prov);
    }

    private PlayState predicate(AnimationState<GeoAnimatable> state) {
        AnimationController controller = state.getController();
        controller.triggerableAnim("craft", CRAFTING);
        controller.triggerableAnim("idle", IDLE);
        controller.triggerableAnim("finish", FINISH);
        return PlayState.CONTINUE;
    }
}

