/*
 * Decompiled with CFR 0.152.
 */
package net.tarantel.chickenroost.item.base;

import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;
import net.tarantel.chickenroost.item.base.ChickenItemBase;
import net.tarantel.chickenroost.item.renderer.AnimatedChickenRenderer_5;
import net.tarantel.chickenroost.util.Config;
import net.tarantel.chickenroost.util.ModDataComponents;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.Animation;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;
import software.bernie.geckolib.util.RenderUtil;

public class AnimatedChicken_5
extends ChickenItemBase
implements GeoItem {
    private String localpath;
    public int currentchickena;
    private AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public AnimatedChicken_5(Item.Properties properties, String path, int currentchicken) {
        super(properties, currentchicken);
        this.localpath = path;
        this.currentchickena = currentchicken;
    }

    public String getLocalpath() {
        return this.localpath;
    }

    public static BlockPos rightposi(BlockPos blockPos, Direction direction) {
        int[] XSide = new int[]{0, 0, 0, 0, -1, 1};
        int[] YSide = new int[]{-1, 1, 0, 0, 0, 0};
        int[] ZSide = new int[]{0, 0, -1, 1, 0, 0};
        int X = blockPos.getX() + XSide[direction.ordinal()];
        int Y = blockPos.getY() + YSide[direction.ordinal()];
        int Z = blockPos.getZ() + ZSide[direction.ordinal()];
        return new BlockPos(X, Y, Z);
    }

    public InteractionResult useOn(UseOnContext context) {
        Item item = context.getItemInHand().getItem();
        Level level = context.getLevel();
        if (!(level instanceof ServerLevel)) {
            return InteractionResult.SUCCESS;
        }
        ItemStack itemstack = context.getItemInHand();
        BlockPos blockpos = AnimatedChicken_5.rightposi(context.getClickedPos(), context.getClickedFace());
        Direction direction = context.getClickedFace();
        BlockState blockstate = level.getBlockState(blockpos);
        if (blockstate.getCollisionShape((BlockGetter)level, blockpos).isEmpty()) {
            BlockPos blockpos1 = blockpos;
        } else {
            BlockPos blockpos1 = blockpos.relative(direction);
        }
        if (item instanceof ChickenItemBase && !BuiltInRegistries.ITEM.getKey((Object)item).equals((Object)ResourceLocation.fromNamespaceAndPath((String)"chicken_roost", (String)"c_vanilla"))) {
            EntityType entitytype = (EntityType)BuiltInRegistries.ENTITY_TYPE.get(ResourceLocation.parse((String)context.getItemInHand().getItem().getDefaultInstance().getItemHolder().getRegisteredName().toString()));
            Entity entity = entitytype.spawn((ServerLevel)level, itemstack, context.getPlayer(), blockpos, MobSpawnType.SPAWN_EGG, false, false);
            if (entity == null) {
                return InteractionResult.PASS;
            }
            if (itemstack.has(ModDataComponents.CHICKENLEVEL)) {
                entity.getPersistentData().putInt("chickenlevel", ((Integer)itemstack.get((DataComponentType)ModDataComponents.CHICKENLEVEL.value())).intValue());
            }
            if (itemstack.has(ModDataComponents.CHICKENXP)) {
                entity.getPersistentData().putInt("chickenxp", ((Integer)itemstack.get((DataComponentType)ModDataComponents.CHICKENXP.value())).intValue());
            }
            itemstack.consume(1, (LivingEntity)context.getPlayer());
            context.getPlayer().awardStat(Stats.ITEM_USED.get((Object)this));
            level.gameEvent((Entity)context.getPlayer(), (Holder)GameEvent.ENTITY_PLACE, blockpos);
        } else {
            EntityType entitytype = (EntityType)BuiltInRegistries.ENTITY_TYPE.get(ResourceLocation.parse((String)"minecraft:chicken"));
            Entity entity = entitytype.spawn((ServerLevel)level, itemstack, context.getPlayer(), blockpos, MobSpawnType.SPAWN_EGG, false, false);
            if (entity == null) {
                return InteractionResult.PASS;
            }
            if (itemstack.has(ModDataComponents.CHICKENLEVEL)) {
                entity.getPersistentData().putInt("chickenlevel", ((Integer)itemstack.get((DataComponentType)ModDataComponents.CHICKENLEVEL.value())).intValue());
            }
            if (itemstack.has(ModDataComponents.CHICKENXP)) {
                entity.getPersistentData().putInt("chickenxp", ((Integer)itemstack.get((DataComponentType)ModDataComponents.CHICKENXP.value())).intValue());
            }
            itemstack.consume(1, (LivingEntity)context.getPlayer());
            context.getPlayer().awardStat(Stats.ITEM_USED.get((Object)this));
            level.gameEvent((Entity)context.getPlayer(), (Holder)GameEvent.ENTITY_PLACE, blockpos);
        }
        return InteractionResult.CONSUME;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        Item item = player.getItemInHand(hand).getItem();
        ItemStack itemstack = player.getItemInHand(hand);
        BlockHitResult blockhitresult = AnimatedChicken_5.getPlayerPOVHitResult((Level)level, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.SOURCE_ONLY);
        if (blockhitresult.getType() != HitResult.Type.BLOCK) {
            return InteractionResultHolder.pass((Object)itemstack);
        }
        if (!(level instanceof ServerLevel)) {
            return InteractionResultHolder.success((Object)itemstack);
        }
        BlockPos blockpos = blockhitresult.getBlockPos();
        if (!(level.getBlockState(blockpos).getBlock() instanceof LiquidBlock)) {
            return InteractionResultHolder.pass((Object)itemstack);
        }
        if (level.mayInteract(player, blockpos) && player.mayUseItemAt(blockpos, blockhitresult.getDirection(), itemstack)) {
            if (item instanceof ChickenItemBase && !BuiltInRegistries.ITEM.getKey((Object)item).equals((Object)ResourceLocation.fromNamespaceAndPath((String)"chicken_roost", (String)"c_vanilla"))) {
                EntityType entitytype = (EntityType)BuiltInRegistries.ENTITY_TYPE.get(ResourceLocation.parse((String)player.getItemInHand(hand).getItem().getDefaultInstance().getItemHolder().getRegisteredName().toString()));
                Entity entity = entitytype.spawn((ServerLevel)level, itemstack, player, blockpos, MobSpawnType.SPAWN_EGG, false, false);
                if (entity == null) {
                    return InteractionResultHolder.pass((Object)itemstack);
                }
                if (itemstack.has(ModDataComponents.CHICKENLEVEL)) {
                    entity.getPersistentData().putInt("chickenlevel", ((Integer)itemstack.get((DataComponentType)ModDataComponents.CHICKENLEVEL.value())).intValue());
                }
                if (itemstack.has(ModDataComponents.CHICKENXP)) {
                    entity.getPersistentData().putInt("chickenxp", ((Integer)itemstack.get((DataComponentType)ModDataComponents.CHICKENXP.value())).intValue());
                }
                itemstack.consume(1, (LivingEntity)player);
                player.awardStat(Stats.ITEM_USED.get((Object)this));
                level.gameEvent((Entity)player, (Holder)GameEvent.ENTITY_PLACE, entity.position());
                return InteractionResultHolder.consume((Object)itemstack);
            }
            EntityType entitytype = (EntityType)BuiltInRegistries.ENTITY_TYPE.get(ResourceLocation.parse((String)"minecraft:chicken"));
            Entity entity = entitytype.spawn((ServerLevel)level, itemstack, player, blockpos, MobSpawnType.SPAWN_EGG, false, false);
            if (entity == null) {
                return InteractionResultHolder.pass((Object)itemstack);
            }
            if (itemstack.has(ModDataComponents.CHICKENLEVEL)) {
                entity.getPersistentData().putInt("chickenlevel", ((Integer)itemstack.get((DataComponentType)ModDataComponents.CHICKENLEVEL.value())).intValue());
            }
            if (itemstack.has(ModDataComponents.CHICKENXP)) {
                entity.getPersistentData().putInt("chickenxp", ((Integer)itemstack.get((DataComponentType)ModDataComponents.CHICKENXP.value())).intValue());
            }
            itemstack.consume(1, (LivingEntity)player);
            player.awardStat(Stats.ITEM_USED.get((Object)this));
            level.gameEvent((Entity)player, (Holder)GameEvent.ENTITY_PLACE, entity.position());
            return InteractionResultHolder.consume((Object)itemstack);
        }
        return InteractionResultHolder.fail((Object)itemstack);
    }

    public void appendHoverText(ItemStack itemstack, Item.TooltipContext context, List<Component> list, TooltipFlag flag) {
        super.appendHoverText(itemstack, context, list, flag);
        int level = 0;
        int xp = 0;
        if (itemstack.has(ModDataComponents.CHICKENLEVEL)) {
            level = (Integer)itemstack.get((DataComponentType)ModDataComponents.CHICKENLEVEL.value());
        }
        if (itemstack.has(ModDataComponents.CHICKENXP)) {
            xp = (Integer)itemstack.get((DataComponentType)ModDataComponents.CHICKENXP.value());
        }
        list.add(Component.nullToEmpty((String)"\u00a71Tier: \u00a795"));
        list.add(Component.nullToEmpty((String)("\u00a7eLevel: \u00a79" + level + "/" + (Integer)Config.maxlevel_tier_5.get())));
        list.add(Component.nullToEmpty((String)("\u00a7aXP: \u00a79" + xp + "/" + (Integer)Config.xp_tier_5.get())));
        list.add(Component.nullToEmpty((String)"\u00a71 Roost Ultimate"));
    }

    private PlayState predicate(AnimationState animationState) {
        animationState.getController().setAnimation(RawAnimation.begin().then("idle", Animation.LoopType.LOOP));
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController((GeoAnimatable)this, "controller", 0, this::predicate));
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public double getTick(Object itemStack) {
        return RenderUtil.getCurrentTick();
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(this){
            private AnimatedChickenRenderer_5 renderer;

            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                if (this.renderer == null) {
                    this.renderer = new AnimatedChickenRenderer_5();
                }
                return this.renderer;
            }
        });
    }

    public float getDestroySpeed(ItemStack par1ItemStack, BlockState par2Block) {
        return 0.0f;
    }
}

