/*
 * Decompiled with CFR 0.152.
 */
package net.tarantel.chickenroost.block.tile;

import java.util.List;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemContainerContents;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.tarantel.chickenroost.block.blocks.ModBlocks;
import net.tarantel.chickenroost.block.tile.InputOutputItemHandler;
import net.tarantel.chickenroost.block.tile.ModBlockEntities;
import net.tarantel.chickenroost.handler.Trainer_Handler;
import net.tarantel.chickenroost.item.base.ChickenItemBase;
import net.tarantel.chickenroost.item.base.ChickenSeedBase;
import net.tarantel.chickenroost.util.Config;
import net.tarantel.chickenroost.util.ModDataComponents;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoBlockEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.Animation;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;
import software.bernie.geckolib.util.RenderUtil;

public class Trainer_Tile
extends BlockEntity
implements MenuProvider,
GeoBlockEntity {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    public final ItemStackHandler itemHandler = new ItemStackHandler(2){

        protected void onContentsChanged(int slot) {
            Trainer_Tile.this.setChanged();
            if (slot == 0) {
                Trainer_Tile.this.resetProgress();
            }
            if (!Trainer_Tile.this.level.isClientSide()) {
                Trainer_Tile.this.level.sendBlockUpdated(Trainer_Tile.this.getBlockPos(), Trainer_Tile.this.getBlockState(), Trainer_Tile.this.getBlockState(), 3);
            }
        }

        public int getSlotLimit(int slot) {
            if (slot == 0) {
                return 1;
            }
            if (slot == 1) {
                return 64;
            }
            return 0;
        }

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            return switch (slot) {
                case 0 -> stack.getItem() instanceof ChickenItemBase;
                case 1 -> stack.getItem() instanceof ChickenSeedBase;
                default -> super.isItemValid(slot, stack);
            };
        }
    };
    private static final RawAnimation CRAFTING = RawAnimation.begin().then("training", Animation.LoopType.LOOP);
    private static final RawAnimation IDLE = RawAnimation.begin().then("idle", Animation.LoopType.LOOP);
    protected final ContainerData data;
    public int progress = 0;
    public int maxProgress = (Integer)Config.training_speed_tick.get() * 20;
    public final int[] LevelList;
    public final int[] XPList;
    public final int[] XPAmountList;
    private final IItemHandler itemHandlerSided = new InputOutputItemHandler((IItemHandlerModifiable)this.itemHandler, (i, stack) -> i == 0 || i == 1, i -> i == 0);
    public static ItemStack MyChicken;
    public static ChickenSeedBase FoodItem;
    public static ChickenItemBase ChickenItem;

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public double getTick(Object blockEntity) {
        return RenderUtil.getCurrentTick();
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController((GeoAnimatable)this, "controller", 0, this::predicate));
    }

    private PlayState predicate(AnimationState<GeoAnimatable> state) {
        AnimationController controller = state.getController();
        controller.triggerableAnim("craft", CRAFTING);
        controller.triggerableAnim("idle", IDLE);
        return PlayState.CONTINUE;
    }

    public ItemStack getRenderStack() {
        ItemStack stack = !this.itemHandler.getStackInSlot(0).isEmpty() ? this.itemHandler.getStackInSlot(0) : ItemStack.EMPTY;
        return stack;
    }

    public void setHandler(ItemStackHandler itemStackHandler) {
        for (int i = 0; i < itemStackHandler.getSlots(); ++i) {
            this.itemHandler.setStackInSlot(i, itemStackHandler.getStackInSlot(i));
        }
    }

    public int getScaledProgress() {
        int progresss = this.progress;
        int maxProgresss = this.maxProgress;
        int progressArrowSize = 200;
        return maxProgresss != 0 && progresss != 0 ? progresss * progressArrowSize / maxProgresss : 0;
    }

    public Trainer_Tile(BlockPos pos, BlockState state) {
        super(ModBlockEntities.TRAINER.get(), pos, state);
        this.LevelList = new int[]{Objects.requireNonNullElse((Integer)Config.maxlevel_tier_1.get(), 128), Objects.requireNonNullElse((Integer)Config.maxlevel_tier_2.get(), 128), Objects.requireNonNullElse((Integer)Config.maxlevel_tier_3.get(), 128), Objects.requireNonNullElse((Integer)Config.maxlevel_tier_4.get(), 128), Objects.requireNonNullElse((Integer)Config.maxlevel_tier_5.get(), 128), Objects.requireNonNullElse((Integer)Config.maxlevel_tier_6.get(), 128), Objects.requireNonNullElse((Integer)Config.maxlevel_tier_7.get(), 128), Objects.requireNonNullElse((Integer)Config.maxlevel_tier_8.get(), 128), Objects.requireNonNullElse((Integer)Config.maxlevel_tier_9.get(), 128)};
        this.XPList = new int[]{Objects.requireNonNullElse(Integer.valueOf((Integer)Config.xp_tier_1.get()), 50), Objects.requireNonNullElse(Integer.valueOf((Integer)Config.xp_tier_2.get()), 250), Objects.requireNonNullElse(Integer.valueOf((Integer)Config.xp_tier_3.get()), 1250), Objects.requireNonNullElse(Integer.valueOf((Integer)Config.xp_tier_4.get()), 6250), Objects.requireNonNullElse(Integer.valueOf((Integer)Config.xp_tier_5.get()), 12500), Objects.requireNonNullElse(Integer.valueOf((Integer)Config.xp_tier_6.get()), 25000), Objects.requireNonNullElse(Integer.valueOf((Integer)Config.xp_tier_7.get()), 32500), Objects.requireNonNullElse(Integer.valueOf((Integer)Config.xp_tier_8.get()), 40000), Objects.requireNonNullElse(Integer.valueOf((Integer)Config.xp_tier_9.get()), 50000)};
        this.XPAmountList = new int[]{Objects.requireNonNullElse(Integer.valueOf((Integer)Config.food_xp_tier_1.get()), 50), Objects.requireNonNullElse(Integer.valueOf((Integer)Config.food_xp_tier_2.get()), 200), Objects.requireNonNullElse(Integer.valueOf((Integer)Config.food_xp_tier_3.get()), 300), Objects.requireNonNullElse(Integer.valueOf((Integer)Config.food_xp_tier_4.get()), 500), Objects.requireNonNullElse(Integer.valueOf((Integer)Config.food_xp_tier_5.get()), 700), Objects.requireNonNullElse(Integer.valueOf((Integer)Config.food_xp_tier_6.get()), 1000), Objects.requireNonNullElse(Integer.valueOf((Integer)Config.food_xp_tier_7.get()), 1500), Objects.requireNonNullElse(Integer.valueOf((Integer)Config.food_xp_tier_8.get()), 2500), Objects.requireNonNullElse(Integer.valueOf((Integer)Config.food_xp_tier_9.get()), 5000)};
        this.data = new ContainerData(){

            public int get(int index) {
                return switch (index) {
                    case 0 -> Trainer_Tile.this.progress;
                    case 1 -> Trainer_Tile.this.maxProgress;
                    default -> 0;
                };
            }

            public void set(int index, int value) {
                switch (index) {
                    case 0: {
                        Trainer_Tile.this.progress = value;
                        break;
                    }
                    case 1: {
                        Trainer_Tile.this.maxProgress = value;
                    }
                }
            }

            public int getCount() {
                return 2;
            }
        };
    }

    public Component getDisplayName() {
        return Component.translatable((String)"name.chicken_roost.trainer");
    }

    @Nullable
    public AbstractContainerMenu createMenu(int id, @NotNull Inventory inventory, @NotNull Player player) {
        return new Trainer_Handler(id, inventory, this, this.data);
    }

    @Nullable
    public IItemHandler getItemHandlerCapability(@Nullable Direction side) {
        if (side == null) {
            return this.itemHandler;
        }
        return this.itemHandlerSided;
    }

    public void onLoad() {
        super.onLoad();
        this.setChanged();
    }

    public void saveAdditional(CompoundTag nbt, HolderLookup.Provider lookup) {
        nbt.put("inventory", (Tag)this.itemHandler.serializeNBT(lookup));
        nbt.putInt("trainer.progress", this.progress);
        super.saveAdditional(nbt, lookup);
    }

    public void loadAdditional(CompoundTag nbt, HolderLookup.Provider lookup) {
        super.loadAdditional(nbt, lookup);
        this.itemHandler.deserializeNBT(lookup, nbt.getCompound("inventory"));
        this.progress = nbt.getInt("trainer.progress");
    }

    public void drops() {
        SimpleContainer inventory = new SimpleContainer(this.itemHandler.getSlots());
        SimpleContainer block = new SimpleContainer(1);
        ItemStack itemStack = new ItemStack((ItemLike)ModBlocks.TRAINER.get());
        NonNullList items = inventory.getItems();
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            items.set(i, (Object)this.itemHandler.getStackInSlot(i));
        }
        itemStack.set(DataComponents.CONTAINER, (Object)ItemContainerContents.fromItems((List)inventory.getItems()));
        block.setItem(0, itemStack.copy());
        Containers.dropContents((Level)Objects.requireNonNull(this.level), (BlockPos)this.worldPosition, (Container)block);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, Trainer_Tile pEntity) {
        if (level.isClientSide()) {
            return;
        }
        if (pEntity.itemHandler.getStackInSlot(0).getItem().asItem() instanceof ChickenItemBase && pEntity.itemHandler.getStackInSlot(1).getItem().asItem() instanceof ChickenSeedBase) {
            ChickenItem = (ChickenItemBase)pEntity.itemHandler.getStackInSlot(0).getItem();
            MyChicken = pEntity.itemHandler.getStackInSlot(0);
            FoodItem = (ChickenSeedBase)pEntity.itemHandler.getStackInSlot(1).getItem().getDefaultInstance().getItem();
            int ChickenLevel = (Integer)MyChicken.get(ModDataComponents.CHICKENLEVEL);
            if (ChickenLevel < pEntity.LevelList[Trainer_Tile.ChickenItem.currentchickena]) {
                ++pEntity.progress;
                pEntity.triggerAnim("controller", "craft");
                if (pEntity.progress >= pEntity.maxProgress) {
                    Trainer_Tile.craftItem(pEntity);
                }
            }
        } else {
            pEntity.resetProgress();
            pEntity.triggerAnim("controller", "idle");
            Trainer_Tile.setChanged((Level)level, (BlockPos)pos, (BlockState)state);
        }
    }

    private void resetProgress() {
        this.progress = 0;
    }

    public final void setChanged() {
        this.setChanged(true);
    }

    protected void setChanged(boolean updateComparator) {
    }

    private static void craftItem(Trainer_Tile pEntity) {
        int ChickenXP;
        ChickenItem = (ChickenItemBase)pEntity.itemHandler.getStackInSlot(0).getItem();
        MyChicken = pEntity.itemHandler.getStackInSlot(0);
        FoodItem = (ChickenSeedBase)pEntity.itemHandler.getStackInSlot(1).getItem().getDefaultInstance().getItem();
        Level level = pEntity.level;
        SimpleContainer inventory = new SimpleContainer(pEntity.itemHandler.getSlots());
        for (int i = 0; i < pEntity.itemHandler.getSlots(); ++i) {
            inventory.setItem(i, pEntity.itemHandler.getStackInSlot(i));
        }
        if (MyChicken.has(ModDataComponents.CHICKENLEVEL) && MyChicken.has(ModDataComponents.CHICKENXP)) {
            ChickenXP = (Integer)MyChicken.get((DataComponentType)ModDataComponents.CHICKENXP.value());
        } else {
            int ChickenLevel = 0;
            ChickenXP = 0;
            MyChicken.set((DataComponentType)ModDataComponents.CHICKENLEVEL.value(), (Object)ChickenLevel);
            MyChicken.set((DataComponentType)ModDataComponents.CHICKENXP.value(), (Object)ChickenXP);
        }
        if (pEntity.itemHandler.getStackInSlot(0).getItem() instanceof ChickenItemBase) {
            if ((Integer)MyChicken.get((DataComponentType)ModDataComponents.CHICKENLEVEL.value()) < pEntity.LevelList[Trainer_Tile.ChickenItem.currentchickena]) {
                if (pEntity.itemHandler.getStackInSlot(1).getItem() instanceof ChickenSeedBase) {
                    if (ChickenXP + pEntity.XPAmountList[FoodItem.getCurrentMaxXp()] / 10 >= pEntity.XPList[Trainer_Tile.ChickenItem.currentchickena]) {
                        MyChicken.set((DataComponentType)ModDataComponents.CHICKENLEVEL.value(), (Object)((Integer)MyChicken.get((DataComponentType)ModDataComponents.CHICKENLEVEL.value()) + 1));
                        MyChicken.set((DataComponentType)ModDataComponents.CHICKENXP.value(), (Object)0);
                    } else {
                        MyChicken.set((DataComponentType)ModDataComponents.CHICKENXP.value(), (Object)(ChickenXP + pEntity.XPAmountList[FoodItem.getCurrentMaxXp()]));
                    }
                }
                pEntity.itemHandler.extractItem(1, 1, false);
                pEntity.itemHandler.extractItem(0, 0, false);
                pEntity.itemHandler.setStackInSlot(0, MyChicken);
                pEntity.resetProgress();
            } else {
                pEntity.resetProgress();
            }
        }
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider prov) {
        return this.saveWithFullMetadata(prov);
    }
}

