/*
 * Decompiled with CFR 0.152.
 */
package net.tarantel.chickenroost.networking;

import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;
import net.tarantel.chickenroost.block.tile.Collector_Tile;
import net.tarantel.chickenroost.block.tile.Roost_Tile;
import net.tarantel.chickenroost.networking.SetCollectorRangePayload;
import net.tarantel.chickenroost.networking.SetCollectorRoostActivePayload;
import net.tarantel.chickenroost.networking.SetRoostNamePayload;

public final class ModNetworking {
    private ModNetworking() {
    }

    @SubscribeEvent
    public static void onRegisterPayloadHandlers(RegisterPayloadHandlersEvent event) {
        PayloadRegistrar registrar = event.registrar("1");
        registrar.playToServer(SetCollectorRoostActivePayload.TYPE, SetCollectorRoostActivePayload.STREAM_CODEC, ModNetworking::handleSetCollectorRoostActive);
        registrar.playToServer(SetCollectorRangePayload.TYPE, SetCollectorRangePayload.STREAM_CODEC, ModNetworking::handleSetCollectorRange);
        registrar.playToServer(SetRoostNamePayload.TYPE, SetRoostNamePayload.STREAM_CODEC, ModNetworking::handleSetRoostName);
    }

    private static void handleSetCollectorRoostActive(SetCollectorRoostActivePayload msg, IPayloadContext ctx) {
        ctx.enqueueWork(() -> {
            ServerPlayer player = (ServerPlayer)ctx.player();
            if (player == null) {
                return;
            }
            ServerLevel level = player.serverLevel();
            BlockEntity be = level.getBlockEntity(msg.collectorPos());
            if (be instanceof Collector_Tile) {
                Collector_Tile ct = (Collector_Tile)be;
                ct.setRoostActive(msg.roostPos(), msg.active());
            }
        });
    }

    private static void handleSetCollectorRange(SetCollectorRangePayload msg, IPayloadContext ctx) {
        ctx.enqueueWork(() -> {
            ServerPlayer player = (ServerPlayer)ctx.player();
            if (player == null) {
                return;
            }
            ServerLevel level = player.serverLevel();
            BlockEntity be = level.getBlockEntity(msg.collectorPos());
            if (be instanceof Collector_Tile) {
                Collector_Tile ct = (Collector_Tile)be;
                ct.setCollectRange(msg.range());
            }
        });
    }

    private static void handleSetRoostName(SetRoostNamePayload msg, IPayloadContext ctx) {
        ctx.enqueueWork(() -> {
            ServerPlayer player = (ServerPlayer)ctx.player();
            if (player == null) {
                return;
            }
            ServerLevel level = player.serverLevel();
            BlockEntity be = level.getBlockEntity(msg.pos());
            if (be instanceof Roost_Tile) {
                Roost_Tile roost = (Roost_Tile)be;
                roost.setCustomName(msg.name());
            }
        });
    }
}

