/*
 * Decompiled with CFR 0.152.
 */
package net.tarantel.chickenroost.recipes;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.tarantel.chickenroost.ChickenRoostMod;
import net.tarantel.chickenroost.recipes.CodecFix;

public class ThrowEggRecipe
implements Recipe<RecipeInput> {
    public final ItemStack output;
    public final Ingredient ingredient0;

    public ThrowEggRecipe(ItemStack output, Ingredient ingredient0) {
        this.output = output;
        this.ingredient0 = ingredient0;
    }

    public ItemStack assemble(RecipeInput container, HolderLookup.Provider registries) {
        return this.output;
    }

    public ResourceLocation getId() {
        return ChickenRoostMod.ownresource("throwegg");
    }

    public ItemStack getResultItem(HolderLookup.Provider registries) {
        return this.output.copy();
    }

    public ItemStack getResultEmi() {
        return this.output.copy();
    }

    public boolean matches(RecipeInput pContainer, Level pLevel) {
        if (pLevel.isClientSide()) {
            return false;
        }
        return this.ingredient0.test(pContainer.getItem(0));
    }

    public boolean isSpecial() {
        return true;
    }

    public NonNullList<Ingredient> getIngredients() {
        NonNullList ingredients = NonNullList.createWithCapacity((int)1);
        ingredients.add(0, (Object)this.ingredient0);
        return ingredients;
    }

    public boolean canCraftInDimensions(int pWidth, int pHeight) {
        return true;
    }

    public String getGroup() {
        return "throwegg";
    }

    public RecipeSerializer<?> getSerializer() {
        return Serializer.INSTANCE;
    }

    public RecipeType<?> getType() {
        return Type.INSTANCE;
    }

    public static final class Serializer
    implements RecipeSerializer<ThrowEggRecipe> {
        public static final Serializer INSTANCE = new Serializer();
        public static final ResourceLocation ID = ChickenRoostMod.ownresource("throwegg");
        private final MapCodec<ThrowEggRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)CodecFix.ITEM_STACK_CODEC.fieldOf("output").forGetter(recipe -> recipe.output), (App)Ingredient.CODEC_NONEMPTY.fieldOf("egg").forGetter(recipe -> recipe.ingredient0)).apply((Applicative)instance, ThrowEggRecipe::new));
        private final StreamCodec<RegistryFriendlyByteBuf, ThrowEggRecipe> STREAM_CODEC = StreamCodec.of(Serializer::write, Serializer::read);

        private Serializer() {
        }

        public MapCodec<ThrowEggRecipe> codec() {
            return this.CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, ThrowEggRecipe> streamCodec() {
            return this.STREAM_CODEC;
        }

        private static ThrowEggRecipe read(RegistryFriendlyByteBuf buffer) {
            Ingredient input0 = (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buffer);
            ItemStack output = (ItemStack)ItemStack.OPTIONAL_STREAM_CODEC.decode((Object)buffer);
            return new ThrowEggRecipe(output, input0);
        }

        private static void write(RegistryFriendlyByteBuf buffer, ThrowEggRecipe recipe) {
            Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buffer, (Object)recipe.ingredient0);
            ItemStack.OPTIONAL_STREAM_CODEC.encode((Object)buffer, (Object)recipe.output);
        }
    }

    public static final class Type
    implements RecipeType<ThrowEggRecipe> {
        public static final Type INSTANCE = new Type();
        public static final String ID = "throwegg";

        private Type() {
        }
    }
}

