/*
 * Decompiled with CFR 0.152.
 */
package net.tarantel.chickenroost.client.renderer;

import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.tarantel.chickenroost.client.renderer.BaseChickenRenderer;
import net.tarantel.chickenroost.entity.ModEntities;
import net.tarantel.chickenroost.util.ChickenData;
import net.tarantel.chickenroost.util.GsonChickenReader;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class ModEntityRenderers {
    @SubscribeEvent
    public static void registerEntityRenderers(EntityRenderersEvent.RegisterRenderers event) {
        List<ChickenData> readItems = GsonChickenReader.readItemsFromFile();
        if (!readItems.isEmpty()) {
            for (ChickenData etherItem : readItems) {
                String id = etherItem.getId();
                String mobtexture = etherItem.getMobtexture();
                ResourceLocation resourceLocation = ResourceLocation.fromNamespaceAndPath((String)"chicken_roost", (String)id);
                EntityType entityType = EntityType.byString((String)resourceLocation.toString()).orElse(EntityType.CHICKEN);
                event.registerEntityRenderer(entityType, context -> new BaseChickenRenderer(context, mobtexture));
            }
        }
        event.registerEntityRenderer((EntityType)ModEntities.A_CHICKEN_LAVA.get(), context -> new BaseChickenRenderer(context, "lavachicken"));
        event.registerEntityRenderer((EntityType)ModEntities.A_CHICKEN_WATER.get(), context -> new BaseChickenRenderer(context, "waterchicken"));
    }
}

