/*
 * Decompiled with CFR 0.152.
 */
package net.tarantel.chickenroost.recipes;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.tarantel.chickenroost.ChickenRoostMod;
import net.tarantel.chickenroost.recipes.CodecFix;

public class Soul_Extractor_Recipe
implements Recipe<RecipeInput> {
    public final ItemStack output;
    public final Ingredient ingredient0;
    public final int time;

    public Soul_Extractor_Recipe(ItemStack output, Ingredient ingredient0, int time) {
        this.output = output;
        this.ingredient0 = ingredient0;
        this.time = time;
    }

    public ItemStack assemble(RecipeInput container, HolderLookup.Provider registries) {
        return this.output;
    }

    public ResourceLocation getId() {
        return ChickenRoostMod.ownresource("soul_extraction");
    }

    public ItemStack getResultItem(HolderLookup.Provider registries) {
        return this.output.copy();
    }

    public ItemStack getResultEmi() {
        return this.output.copy();
    }

    public boolean matches(RecipeInput pContainer, Level pLevel) {
        if (pLevel.isClientSide()) {
            return false;
        }
        return this.ingredient0.test(pContainer.getItem(0));
    }

    public boolean isSpecial() {
        return true;
    }

    public NonNullList<Ingredient> getIngredients() {
        NonNullList ingredients = NonNullList.createWithCapacity((int)1);
        ingredients.add(0, (Object)this.ingredient0);
        return ingredients;
    }

    public boolean canCraftInDimensions(int pWidth, int pHeight) {
        return true;
    }

    public String getGroup() {
        return "soul_extraction";
    }

    public RecipeSerializer<?> getSerializer() {
        return Serializer.INSTANCE;
    }

    public RecipeType<?> getType() {
        return Type.INSTANCE;
    }

    public static final class Serializer
    implements RecipeSerializer<Soul_Extractor_Recipe> {
        public static final Serializer INSTANCE = new Serializer();
        public static final ResourceLocation ID = ChickenRoostMod.ownresource("soul_extraction");
        private final MapCodec<Soul_Extractor_Recipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)CodecFix.ITEM_STACK_CODEC.fieldOf("output").forGetter(recipe -> recipe.output), (App)Ingredient.CODEC_NONEMPTY.fieldOf("chicken").forGetter(recipe -> recipe.ingredient0), (App)Codec.INT.fieldOf("time").orElse((Object)20).forGetter(recipe -> recipe.time)).apply((Applicative)instance, Soul_Extractor_Recipe::new));
        private final StreamCodec<RegistryFriendlyByteBuf, Soul_Extractor_Recipe> STREAM_CODEC = StreamCodec.of(Serializer::write, Serializer::read);

        private Serializer() {
        }

        public MapCodec<Soul_Extractor_Recipe> codec() {
            return this.CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, Soul_Extractor_Recipe> streamCodec() {
            return this.STREAM_CODEC;
        }

        private static Soul_Extractor_Recipe read(RegistryFriendlyByteBuf buffer) {
            Ingredient input0 = (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buffer);
            ItemStack output = (ItemStack)ItemStack.OPTIONAL_STREAM_CODEC.decode((Object)buffer);
            int time = buffer.readVarInt();
            return new Soul_Extractor_Recipe(output, input0, time);
        }

        private static void write(RegistryFriendlyByteBuf buffer, Soul_Extractor_Recipe recipe) {
            Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buffer, (Object)recipe.ingredient0);
            ItemStack.OPTIONAL_STREAM_CODEC.encode((Object)buffer, (Object)recipe.output);
            buffer.writeVarInt(recipe.time);
        }
    }

    public static final class Type
    implements RecipeType<Soul_Extractor_Recipe> {
        public static final Type INSTANCE = new Type();
        public static final String ID = "soul_extraction";

        private Type() {
        }
    }
}

