/*
 * Decompiled with CFR 0.152.
 */
package net.tarantel.chickenroost.api.jei;

import java.util.List;
import java.util.Objects;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.ItemLike;
import net.tarantel.chickenroost.api.jei.BreederRecipeCategory;
import net.tarantel.chickenroost.api.jei.EggRecipeCategory;
import net.tarantel.chickenroost.api.jei.RoostRecipeCategory;
import net.tarantel.chickenroost.api.jei.SoulBreedingRecipeCategory;
import net.tarantel.chickenroost.api.jei.SoulExtractionRecipeCategory;
import net.tarantel.chickenroost.api.jei.TrainerRecipeCategory;
import net.tarantel.chickenroost.block.blocks.ModBlocks;
import net.tarantel.chickenroost.item.ModItems;
import net.tarantel.chickenroost.recipes.Breeder_Recipe;
import net.tarantel.chickenroost.recipes.Roost_Recipe;
import net.tarantel.chickenroost.recipes.Soul_Breeder_Recipe;
import net.tarantel.chickenroost.recipes.Soul_Extractor_Recipe;
import net.tarantel.chickenroost.recipes.ThrowEggRecipe;
import net.tarantel.chickenroost.recipes.Trainer_Recipe;
import net.tarantel.chickenroost.screen.Breeder_Screen;
import net.tarantel.chickenroost.screen.Roost_Screen;
import net.tarantel.chickenroost.screen.Soul_Breeder_Screen;
import net.tarantel.chickenroost.screen.Soul_Extractor_Screen;
import net.tarantel.chickenroost.screen.Trainer_Screen;

@JeiPlugin
public class JEIPlugin
implements IModPlugin {
    public static RecipeType<ThrowEggRecipe> EGG_TYPE = new RecipeType(EggRecipeCategory.UID, ThrowEggRecipe.class);
    public static RecipeType<Soul_Breeder_Recipe> BREEDING_TYPE = new RecipeType(SoulBreedingRecipeCategory.UID, Soul_Breeder_Recipe.class);
    public static RecipeType<Breeder_Recipe> BASIC_BREEDING_TYPE = new RecipeType(BreederRecipeCategory.UID, Breeder_Recipe.class);
    public static RecipeType<Soul_Extractor_Recipe> SOUL_EXTRACTION_TYPE = new RecipeType(SoulExtractionRecipeCategory.UID, Soul_Extractor_Recipe.class);
    public static RecipeType<Roost_Recipe> ROOST_TYPE = new RecipeType(RoostRecipeCategory.UID, Roost_Recipe.class);
    public static RecipeType<Trainer_Recipe> TRAINER_TYPE = new RecipeType(TrainerRecipeCategory.UID, Trainer_Recipe.class);

    public ResourceLocation getPluginUid() {
        return new ResourceLocation("chicken_roost", "jei_plugin");
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        IJeiHelpers jeiHelpers = registration.getJeiHelpers();
        registration.addRecipeCategories(new IRecipeCategory[]{new EggRecipeCategory(jeiHelpers.getGuiHelper())});
        registration.addRecipeCategories(new IRecipeCategory[]{new SoulBreedingRecipeCategory(jeiHelpers.getGuiHelper())});
        registration.addRecipeCategories(new IRecipeCategory[]{new BreederRecipeCategory(jeiHelpers.getGuiHelper())});
        registration.addRecipeCategories(new IRecipeCategory[]{new SoulExtractionRecipeCategory(jeiHelpers.getGuiHelper())});
        registration.addRecipeCategories(new IRecipeCategory[]{new RoostRecipeCategory(jeiHelpers.getGuiHelper())});
        registration.addRecipeCategories(new IRecipeCategory[]{new TrainerRecipeCategory(jeiHelpers.getGuiHelper())});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        RecipeManager rm = Objects.requireNonNull(Minecraft.m_91087_().f_91073_).m_7465_();
        List recipesSoulBreeding = rm.m_44013_((net.minecraft.world.item.crafting.RecipeType)Soul_Breeder_Recipe.Type.INSTANCE);
        registration.addRecipes(BREEDING_TYPE, recipesSoulBreeding);
        List recipesBasicBreeding = rm.m_44013_((net.minecraft.world.item.crafting.RecipeType)Breeder_Recipe.Type.INSTANCE);
        registration.addRecipes(BASIC_BREEDING_TYPE, recipesBasicBreeding);
        List recipesBasicBreedingNew = rm.m_44013_((net.minecraft.world.item.crafting.RecipeType)ThrowEggRecipe.Type.INSTANCE);
        registration.addRecipes(EGG_TYPE, recipesBasicBreedingNew);
        List recipesSoulExtraction = rm.m_44013_((net.minecraft.world.item.crafting.RecipeType)Soul_Extractor_Recipe.Type.INSTANCE);
        registration.addRecipes(SOUL_EXTRACTION_TYPE, recipesSoulExtraction);
        List recipesRoost = rm.m_44013_((net.minecraft.world.item.crafting.RecipeType)Roost_Recipe.Type.INSTANCE);
        registration.addRecipes(ROOST_TYPE, recipesRoost);
        List recipesTrainer = rm.m_44013_((net.minecraft.world.item.crafting.RecipeType)Trainer_Recipe.Type.INSTANCE);
        registration.addRecipes(TRAINER_TYPE, recipesTrainer);
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        ItemStack egg = new ItemStack((ItemLike)ModItems.CHICKEN_STICK.get());
        registration.addRecipeCatalyst(egg, new RecipeType[]{EggRecipeCategory.RECIPE_TYPE});
        ItemStack soulbreeder = new ItemStack((ItemLike)ModBlocks.SOUL_BREEDER.get());
        registration.addRecipeCatalyst(soulbreeder, new RecipeType[]{SoulBreedingRecipeCategory.RECIPE_TYPE});
        ItemStack basicbreeder = new ItemStack((ItemLike)ModBlocks.BREEDER.get());
        registration.addRecipeCatalyst(basicbreeder, new RecipeType[]{BreederRecipeCategory.RECIPE_TYPE});
        ItemStack soulextractor = new ItemStack((ItemLike)ModBlocks.SOUL_EXTRACTOR.get());
        registration.addRecipeCatalyst(soulextractor, new RecipeType[]{SoulExtractionRecipeCategory.RECIPE_TYPE});
        ItemStack roostyv1 = new ItemStack((ItemLike)ModBlocks.ROOST.get());
        registration.addRecipeCatalyst(roostyv1, new RecipeType[]{RoostRecipeCategory.RECIPE_TYPE});
        ItemStack trainer = new ItemStack((ItemLike)ModBlocks.TRAINER.get());
        registration.addRecipeCatalyst(trainer, new RecipeType[]{TrainerRecipeCategory.RECIPE_TYPE});
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registration) {
        registration.addRecipeClickArea(Soul_Breeder_Screen.class, 59, 41, 40, 10, new RecipeType[]{BREEDING_TYPE});
        registration.addRecipeClickArea(Breeder_Screen.class, 53, 30, 40, 10, new RecipeType[]{BASIC_BREEDING_TYPE});
        registration.addRecipeClickArea(Soul_Extractor_Screen.class, 59, 41, 40, 10, new RecipeType[]{SOUL_EXTRACTION_TYPE});
        registration.addRecipeClickArea(Trainer_Screen.class, 59, 41, 40, 10, new RecipeType[]{TRAINER_TYPE});
        registration.addRecipeClickArea(Roost_Screen.class, 59, 41, 40, 10, new RecipeType[]{ROOST_TYPE});
    }
}

