/*
 * Decompiled with CFR 0.152.
 */
package net.tarantel.chickenroost.block.tile;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.tarantel.chickenroost.block.blocks.Breeder_Block;
import net.tarantel.chickenroost.block.blocks.ModBlocks;
import net.tarantel.chickenroost.block.tile.ModBlockEntities;
import net.tarantel.chickenroost.handler.Breeder_Handler;
import net.tarantel.chickenroost.item.base.ChickenItemBase;
import net.tarantel.chickenroost.network.BreederItemStackSyncS2CPacket;
import net.tarantel.chickenroost.network.ModMessages;
import net.tarantel.chickenroost.recipes.Breeder_Recipe;
import net.tarantel.chickenroost.recipes.ModRecipes;
import net.tarantel.chickenroost.util.Config;
import net.tarantel.chickenroost.util.WrappedHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Breeder_Tile
extends BlockEntity
implements MenuProvider {
    public static int x;
    public static int y;
    public static int z;
    public int progress = 0;
    public int maxProgress = (Integer)Config.breed_speed_tick.get() * 20;
    public final ItemStackHandler itemHandler = new ItemStackHandler(11){

        protected void onContentsChanged(int slot) {
            Breeder_Tile.this.m_6596_();
            if (!Breeder_Tile.this.f_58857_.m_5776_()) {
                Breeder_Tile.this.f_58857_.m_7260_(Breeder_Tile.this.m_58899_(), Breeder_Tile.this.m_58900_(), Breeder_Tile.this.m_58900_(), 3);
            }
        }

        public int getSlotLimit(int slot) {
            if (slot == 1) {
                return 64;
            }
            return 1;
        }

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            return switch (slot) {
                case 0 -> stack.m_41720_() instanceof ChickenItemBase;
                case 2 -> stack.m_41720_() instanceof ChickenItemBase;
                case 1 -> stack.m_204117_(ItemTags.create((ResourceLocation)new ResourceLocation("c:seeds/tiered")));
                default -> false;
            };
        }
    };
    private LazyOptional<IItemHandler> lazyItemHandler = LazyOptional.empty();
    protected final ContainerData data;
    private int blabla = 0;
    private final Map<Direction, LazyOptional<WrappedHandler>> directionWrappedHandlerMap = new HashMap<Direction, LazyOptional<WrappedHandler>>();
    static ItemStack ChickenOutput;
    static String outpit;

    public ItemStack getRenderStack1() {
        ItemStack stack = !this.itemHandler.getStackInSlot(0).m_41619_() ? this.itemHandler.getStackInSlot(0) : ItemStack.f_41583_;
        return stack;
    }

    public ItemStack getRenderStack2() {
        ItemStack stack = !this.itemHandler.getStackInSlot(2).m_41619_() ? this.itemHandler.getStackInSlot(2) : ItemStack.f_41583_;
        return stack;
    }

    public ItemStack getRenderStack3() {
        ItemStack stack = !this.itemHandler.getStackInSlot(1).m_41619_() ? this.itemHandler.getStackInSlot(1) : ItemStack.f_41583_;
        return stack;
    }

    public void setHandler(ItemStackHandler itemStackHandler) {
        for (int i = 0; i < itemStackHandler.getSlots(); ++i) {
            this.itemHandler.setStackInSlot(i, itemStackHandler.getStackInSlot(i));
        }
    }

    public int getScaledProgress() {
        int progresss = this.progress;
        int maxProgresss = this.maxProgress;
        int progressArrowSize = 200;
        return maxProgresss != 0 && progresss != 0 ? progresss * progressArrowSize / maxProgresss : 0;
    }

    public Breeder_Tile(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.BREEDER.get(), pos, state);
        x = pos.m_123341_();
        y = pos.m_123342_();
        z = pos.m_123343_();
        this.data = new ContainerData(){

            public int m_6413_(int index) {
                return switch (index) {
                    case 0 -> Breeder_Tile.this.progress;
                    case 1 -> Breeder_Tile.this.maxProgress;
                    default -> 0;
                };
            }

            public void m_8050_(int index, int value) {
                switch (index) {
                    case 0: {
                        Breeder_Tile.this.progress = value;
                        break;
                    }
                    case 1: {
                        Breeder_Tile.this.maxProgress = value;
                    }
                }
            }

            public int m_6499_() {
                return 2;
            }
        };
    }

    @NotNull
    public Component m_5446_() {
        return Component.m_237115_((String)"");
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int id, @NotNull Inventory inventory, @NotNull Player player) {
        return new Breeder_Handler(id, inventory, this, this.data);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            if (side == null) {
                return this.lazyItemHandler.cast();
            }
            for (Direction direction : Arrays.asList(Direction.DOWN, Direction.UP, Direction.NORTH, Direction.EAST, Direction.WEST, Direction.SOUTH)) {
                this.directionWrappedHandlerMap.put(direction, (LazyOptional<WrappedHandler>)LazyOptional.of(() -> new WrappedHandler((IItemHandlerModifiable)this.itemHandler, i -> i == 3 || i == 4 || i == 5 || i == 6 || i == 7 || i == 8 || i == 9 || i == 10, (i, s) -> false)));
            }
            for (Direction direction : Arrays.asList(Direction.DOWN, Direction.WEST, Direction.EAST, Direction.NORTH, Direction.SOUTH, Direction.UP)) {
                this.directionWrappedHandlerMap.put(direction, (LazyOptional<WrappedHandler>)LazyOptional.of(() -> new WrappedHandler((IItemHandlerModifiable)this.itemHandler, index -> index == 3 || index == 4 || index == 5 || index == 6 || index == 7 || index == 8 || index == 9 || index == 10, (index, stack) -> this.itemHandler.isItemValid(0, stack) || this.itemHandler.isItemValid(1, stack) || this.itemHandler.isItemValid(2, stack))));
            }
            if (this.directionWrappedHandlerMap.containsKey(side)) {
                Direction localDir = (Direction)this.m_58900_().m_61143_((Property)Breeder_Block.FACING);
                if (side == Direction.UP || side == Direction.DOWN) {
                    return this.directionWrappedHandlerMap.get(side).cast();
                }
                return switch (localDir) {
                    default -> this.directionWrappedHandlerMap.get(side.m_122424_()).cast();
                    case Direction.EAST -> this.directionWrappedHandlerMap.get(side.m_122427_()).cast();
                    case Direction.SOUTH -> this.directionWrappedHandlerMap.get(side).cast();
                    case Direction.WEST -> this.directionWrappedHandlerMap.get(side.m_122428_()).cast();
                };
            }
        }
        return super.getCapability(cap, side);
    }

    public void onLoad() {
        super.onLoad();
        this.lazyItemHandler = LazyOptional.of(() -> this.itemHandler);
        if (!this.f_58857_.m_5776_()) {
            ModMessages.sendToClients(new BreederItemStackSyncS2CPacket(this.itemHandler, this.f_58858_));
        }
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.lazyItemHandler.invalidate();
    }

    protected void m_183515_(@NotNull CompoundTag nbt) {
        nbt.m_128365_("inventory", (Tag)this.itemHandler.serializeNBT());
        nbt.m_128405_("breeder.progress", this.progress);
        super.m_183515_(nbt);
    }

    public void m_142466_(@NotNull CompoundTag nbt) {
        super.m_142466_(nbt);
        this.itemHandler.deserializeNBT(nbt.m_128469_("inventory"));
        this.progress = nbt.m_128451_("breeder.progress");
    }

    public void drops() {
        SimpleContainer inventory = new SimpleContainer(this.itemHandler.getSlots());
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            inventory.m_6836_(i, this.itemHandler.getStackInSlot(i));
        }
        ItemStack itemStack = new ItemStack((ItemLike)ModBlocks.BREEDER.get());
        CompoundTag nbt = new CompoundTag();
        ListTag itemsTag = new ListTag();
        for (int i = 0; i < inventory.m_6643_(); ++i) {
            ItemStack stack = inventory.m_8020_(i);
            if (stack.m_41619_()) continue;
            CompoundTag itemTag = new CompoundTag();
            itemTag.m_128405_("Slot", i);
            stack.m_41739_(itemTag);
            itemsTag.add((Object)itemTag);
        }
        nbt.m_128365_("Items", (Tag)itemsTag);
        itemStack.m_41751_(nbt);
        SimpleContainer block = new SimpleContainer(1);
        block.m_6836_(0, itemStack.m_41777_());
        Containers.m_19002_((Level)Objects.requireNonNull(this.f_58857_), (BlockPos)this.f_58858_, (Container)block);
    }

    public static void tick(Level levelL, BlockPos pos, BlockState state, Breeder_Tile pEntity) {
        if (levelL.m_5776_()) {
            return;
        }
        Breeder_Tile.m_155232_((Level)levelL, (BlockPos)pos, (BlockState)state);
        if (Breeder_Tile.hasRecipe(pEntity) && (pEntity.itemHandler.getStackInSlot(3) == ItemStack.f_41583_ || pEntity.itemHandler.getStackInSlot(4) == ItemStack.f_41583_ || pEntity.itemHandler.getStackInSlot(5) == ItemStack.f_41583_ || pEntity.itemHandler.getStackInSlot(6) == ItemStack.f_41583_ || pEntity.itemHandler.getStackInSlot(7) == ItemStack.f_41583_ || pEntity.itemHandler.getStackInSlot(8) == ItemStack.f_41583_ || pEntity.itemHandler.getStackInSlot(9) == ItemStack.f_41583_ || pEntity.itemHandler.getStackInSlot(10) == ItemStack.f_41583_)) {
            ++pEntity.progress;
            if (pEntity.progress >= pEntity.maxProgress) {
                Breeder_Tile.craftItem(pEntity);
            }
        } else {
            pEntity.resetProgress();
            Breeder_Tile.m_155232_((Level)levelL, (BlockPos)pos, (BlockState)state);
        }
    }

    private void resetProgress() {
        this.progress = 0;
    }

    private static void craftItem(Breeder_Tile pEntity) {
        Level level = pEntity.f_58857_;
        SimpleContainer inventory = new SimpleContainer(pEntity.itemHandler.getSlots());
        for (int i = 0; i < pEntity.itemHandler.getSlots(); ++i) {
            inventory.m_6836_(i, pEntity.itemHandler.getStackInSlot(i));
        }
        List recipe = pEntity.m_58904_().m_7465_().m_44056_((RecipeType)Breeder_Recipe.Type.INSTANCE, (Container)inventory, pEntity.m_58904_());
        if (level != null) {
            if (Breeder_Tile.hasRecipe(pEntity)) {
                Random ran = new Random();
                int RandomOutputs = ran.nextInt(recipe.size());
                ChickenOutput = new ItemStack((ItemLike)((Breeder_Recipe)recipe.get((int)RandomOutputs)).output.m_41720_());
                if (pEntity.itemHandler.getStackInSlot(3) == ItemStack.f_41583_) {
                    pEntity.itemHandler.extractItem(0, 0, true);
                    pEntity.itemHandler.extractItem(2, 0, true);
                    pEntity.itemHandler.extractItem(1, 1, false);
                    pEntity.itemHandler.setStackInSlot(3, ChickenOutput);
                    pEntity.resetProgress();
                } else if (pEntity.itemHandler.getStackInSlot(4) == ItemStack.f_41583_) {
                    pEntity.itemHandler.extractItem(2, 0, true);
                    pEntity.itemHandler.extractItem(0, 0, true);
                    pEntity.itemHandler.extractItem(1, 1, false);
                    pEntity.itemHandler.setStackInSlot(4, ChickenOutput);
                    pEntity.resetProgress();
                } else if (pEntity.itemHandler.getStackInSlot(5) == ItemStack.f_41583_) {
                    pEntity.itemHandler.extractItem(0, 0, true);
                    pEntity.itemHandler.extractItem(2, 0, true);
                    pEntity.itemHandler.extractItem(1, 1, false);
                    pEntity.itemHandler.setStackInSlot(5, ChickenOutput);
                    pEntity.resetProgress();
                } else if (pEntity.itemHandler.getStackInSlot(6) == ItemStack.f_41583_) {
                    pEntity.itemHandler.extractItem(0, 0, true);
                    pEntity.itemHandler.extractItem(2, 0, true);
                    pEntity.itemHandler.extractItem(1, 1, false);
                    pEntity.itemHandler.setStackInSlot(6, ChickenOutput);
                    pEntity.resetProgress();
                } else if (pEntity.itemHandler.getStackInSlot(7) == ItemStack.f_41583_) {
                    pEntity.itemHandler.extractItem(0, 0, true);
                    pEntity.itemHandler.extractItem(2, 0, true);
                    pEntity.itemHandler.extractItem(1, 1, false);
                    pEntity.itemHandler.setStackInSlot(7, ChickenOutput);
                    pEntity.resetProgress();
                } else if (pEntity.itemHandler.getStackInSlot(8) == ItemStack.f_41583_) {
                    pEntity.itemHandler.extractItem(0, 0, true);
                    pEntity.itemHandler.extractItem(2, 0, true);
                    pEntity.itemHandler.extractItem(1, 1, false);
                    pEntity.itemHandler.setStackInSlot(8, ChickenOutput);
                    pEntity.resetProgress();
                } else if (pEntity.itemHandler.getStackInSlot(9) == ItemStack.f_41583_) {
                    pEntity.itemHandler.extractItem(0, 0, true);
                    pEntity.itemHandler.extractItem(2, 0, true);
                    pEntity.itemHandler.extractItem(1, 1, false);
                    pEntity.itemHandler.setStackInSlot(9, ChickenOutput);
                    pEntity.resetProgress();
                } else if (pEntity.itemHandler.getStackInSlot(10) == ItemStack.f_41583_) {
                    pEntity.itemHandler.extractItem(0, 0, true);
                    pEntity.itemHandler.extractItem(2, 0, true);
                    pEntity.itemHandler.extractItem(1, 1, false);
                    pEntity.itemHandler.setStackInSlot(10, ChickenOutput);
                    pEntity.resetProgress();
                } else {
                    pEntity.resetProgress();
                }
            } else {
                pEntity.resetProgress();
            }
        }
    }

    private static boolean hasRecipe(Breeder_Tile entity) {
        RecipeManager recipeManager;
        Level level = entity.f_58857_;
        SimpleContainer inventory = new SimpleContainer(entity.itemHandler.getSlots());
        for (int i = 0; i < entity.itemHandler.getSlots(); ++i) {
            inventory.m_6836_(i, entity.itemHandler.getStackInSlot(i));
        }
        Optional recipe = Optional.empty();
        if (level != null && (recipe = (recipeManager = level.m_7465_()).m_44015_((RecipeType)ModRecipes.BASIC_BREEDING_TYPE.get(), (Container)inventory, level)).isPresent()) {
            entity.maxProgress = (Integer)Config.breed_speed_tick.get() * ((Breeder_Recipe)recipe.get()).getTime();
        }
        return recipe.isPresent();
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    static {
        ChickenOutput = ItemStack.f_41583_;
    }
}

