/*
 * Decompiled with CFR 0.152.
 */
package net.tarantel.chickenroost.block.tile;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.tarantel.chickenroost.block.blocks.ModBlocks;
import net.tarantel.chickenroost.block.blocks.Roost_Block;
import net.tarantel.chickenroost.block.tile.ModBlockEntities;
import net.tarantel.chickenroost.handler.SoulBreeder_Handler;
import net.tarantel.chickenroost.item.base.AnimatedChicken_1;
import net.tarantel.chickenroost.item.base.AnimatedChicken_2;
import net.tarantel.chickenroost.item.base.AnimatedChicken_3;
import net.tarantel.chickenroost.item.base.AnimatedChicken_4;
import net.tarantel.chickenroost.item.base.AnimatedChicken_5;
import net.tarantel.chickenroost.item.base.AnimatedChicken_6;
import net.tarantel.chickenroost.item.base.AnimatedChicken_7;
import net.tarantel.chickenroost.item.base.AnimatedChicken_8;
import net.tarantel.chickenroost.item.base.AnimatedChicken_9;
import net.tarantel.chickenroost.network.ModMessages;
import net.tarantel.chickenroost.network.SoulBreederStackSyncS2CPacket;
import net.tarantel.chickenroost.recipes.Soul_Breeder_Recipe;
import net.tarantel.chickenroost.util.Config;
import net.tarantel.chickenroost.util.WrappedHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoBlockEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;
import software.bernie.geckolib.util.RenderUtils;

public class Soul_Breeder_Tile
extends BlockEntity
implements MenuProvider,
GeoBlockEntity {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    public final ItemStackHandler itemHandler = new ItemStackHandler(3){

        protected void onContentsChanged(int slot) {
            Soul_Breeder_Tile.this.m_6596_();
        }

        public int getSlotLimit(int slot) {
            if (slot == 0) {
                return 64;
            }
            if (slot == 1) {
                return 1;
            }
            if (slot == 2) {
                return 64;
            }
            return 0;
        }

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            return switch (slot) {
                case 0 -> stack.m_204117_(ItemTags.create((ResourceLocation)new ResourceLocation("forge:roost/souls")));
                case 1 -> {
                    if (stack.m_41720_() instanceof AnimatedChicken_1 || stack.m_41720_() instanceof AnimatedChicken_2 || stack.m_41720_() instanceof AnimatedChicken_3 || stack.m_41720_() instanceof AnimatedChicken_4 || stack.m_41720_() instanceof AnimatedChicken_5 || stack.m_41720_() instanceof AnimatedChicken_6 || stack.m_41720_() instanceof AnimatedChicken_7 || stack.m_41720_() instanceof AnimatedChicken_8 || stack.m_41720_() instanceof AnimatedChicken_9) {
                        yield true;
                    }
                    yield false;
                }
                case 2 -> false;
                default -> super.isItemValid(slot, stack);
            };
        }
    };
    private LazyOptional<IItemHandler> lazyItemHandler = LazyOptional.empty();
    protected final ContainerData data;
    public int progress = 0;
    private int crafttimer = 20;
    private boolean startcraft = false;
    public int maxProgress = (Integer)Config.soulbreed_speedtimer.get() * 20;
    private final Map<Direction, LazyOptional<WrappedHandler>> directionWrappedHandlerMap = new HashMap<Direction, LazyOptional<WrappedHandler>>();
    private static final RawAnimation CRAFTING = RawAnimation.begin().then("crafting.idle", Animation.LoopType.LOOP);
    private static final RawAnimation IDLE = RawAnimation.begin().then("normal.idle", Animation.LoopType.LOOP);
    private static final RawAnimation FINISH = RawAnimation.begin().then("crafting.finish2", Animation.LoopType.PLAY_ONCE);

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public double getTick(Object blockEntity) {
        return RenderUtils.getCurrentTick();
    }

    public ItemStack getRenderStack() {
        ItemStack stack = !this.itemHandler.getStackInSlot(1).m_41619_() ? this.itemHandler.getStackInSlot(1) : ItemStack.f_41583_;
        return stack;
    }

    public ItemStack getRenderStackInput() {
        ItemStack stack = !this.itemHandler.getStackInSlot(0).m_41619_() ? this.itemHandler.getStackInSlot(0) : ItemStack.f_41583_;
        return stack;
    }

    public void setHandler(ItemStackHandler itemStackHandler) {
        for (int i = 0; i < itemStackHandler.getSlots(); ++i) {
            this.itemHandler.setStackInSlot(i, itemStackHandler.getStackInSlot(i));
        }
    }

    public int getScaledProgress() {
        int progresss = this.progress;
        int maxProgresss = this.maxProgress;
        int progressArrowSize = 200;
        return maxProgresss != 0 && progresss != 0 ? progresss * progressArrowSize / maxProgresss : 0;
    }

    public Soul_Breeder_Tile(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.SOUL_BREEDER.get(), pos, state);
        this.data = new ContainerData(){

            public int m_6413_(int index) {
                return switch (index) {
                    case 0 -> Soul_Breeder_Tile.this.progress;
                    case 1 -> Soul_Breeder_Tile.this.maxProgress;
                    default -> 0;
                };
            }

            public void m_8050_(int index, int value) {
                switch (index) {
                    case 0: {
                        Soul_Breeder_Tile.this.progress = value;
                        break;
                    }
                    case 1: {
                        Soul_Breeder_Tile.this.maxProgress = value;
                    }
                }
            }

            public int m_6499_() {
                return 2;
            }
        };
    }

    public Component m_5446_() {
        return Component.m_237115_((String)"name.chicken_roost.soul_breeder");
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int id, @NotNull Inventory inventory, @NotNull Player player) {
        return new SoulBreeder_Handler(id, inventory, this, this.data);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            if (side == null) {
                return this.lazyItemHandler.cast();
            }
            for (Direction direction : Arrays.asList(Direction.DOWN, Direction.UP, Direction.NORTH, Direction.EAST, Direction.WEST, Direction.SOUTH)) {
                this.directionWrappedHandlerMap.put(direction, (LazyOptional<WrappedHandler>)LazyOptional.of(() -> new WrappedHandler((IItemHandlerModifiable)this.itemHandler, i -> i == 2, (i, s) -> false)));
            }
            for (Direction direction : Arrays.asList(Direction.DOWN, Direction.WEST, Direction.EAST, Direction.NORTH, Direction.SOUTH, Direction.UP)) {
                this.directionWrappedHandlerMap.put(direction, (LazyOptional<WrappedHandler>)LazyOptional.of(() -> new WrappedHandler((IItemHandlerModifiable)this.itemHandler, index -> index == 2, (index, stack) -> this.itemHandler.isItemValid(0, stack) || this.itemHandler.isItemValid(1, stack))));
            }
            if (this.directionWrappedHandlerMap.containsKey(side)) {
                Direction localDir = (Direction)this.m_58900_().m_61143_((Property)Roost_Block.FACING);
                if (side == Direction.UP || side == Direction.DOWN) {
                    return this.directionWrappedHandlerMap.get(side).cast();
                }
                return switch (localDir) {
                    default -> this.directionWrappedHandlerMap.get(side.m_122424_()).cast();
                    case Direction.EAST -> this.directionWrappedHandlerMap.get(side.m_122427_()).cast();
                    case Direction.SOUTH -> this.directionWrappedHandlerMap.get(side).cast();
                    case Direction.WEST -> this.directionWrappedHandlerMap.get(side.m_122428_()).cast();
                };
            }
        }
        return super.getCapability(cap, side);
    }

    public void onLoad() {
        super.onLoad();
        this.lazyItemHandler = LazyOptional.of(() -> this.itemHandler);
        if (!this.f_58857_.m_5776_()) {
            ModMessages.sendToClients(new SoulBreederStackSyncS2CPacket(this.itemHandler, this.f_58858_));
        }
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.lazyItemHandler.invalidate();
    }

    protected void m_183515_(@NotNull CompoundTag nbt) {
        nbt.m_128365_("inventory", (Tag)this.itemHandler.serializeNBT());
        nbt.m_128405_("soul_breeder.progress", this.progress);
        super.m_183515_(nbt);
    }

    public void m_142466_(@NotNull CompoundTag nbt) {
        super.m_142466_(nbt);
        this.itemHandler.deserializeNBT(nbt.m_128469_("inventory"));
        this.progress = nbt.m_128451_("soul_breeder.progress");
    }

    public void drops() {
        SimpleContainer inventory = new SimpleContainer(this.itemHandler.getSlots());
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            inventory.m_6836_(i, this.itemHandler.getStackInSlot(i));
        }
        ItemStack itemStack = new ItemStack((ItemLike)ModBlocks.SOUL_BREEDER.get());
        CompoundTag nbt = new CompoundTag();
        ListTag itemsTag = new ListTag();
        for (int i = 0; i < inventory.m_6643_(); ++i) {
            ItemStack stack = inventory.m_8020_(i);
            if (stack.m_41619_()) continue;
            CompoundTag itemTag = new CompoundTag();
            itemTag.m_128405_("Slot", i);
            stack.m_41739_(itemTag);
            itemsTag.add((Object)itemTag);
        }
        nbt.m_128365_("Items", (Tag)itemsTag);
        itemStack.m_41751_(nbt);
        SimpleContainer block = new SimpleContainer(1);
        block.m_6836_(0, itemStack.m_41777_());
        Containers.m_19002_((Level)Objects.requireNonNull(this.f_58857_), (BlockPos)this.f_58858_, (Container)block);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, Soul_Breeder_Tile pEntity) {
        BlockPos blockPos = pos;
        if (level.m_5776_()) {
            return;
        }
        if (pEntity.startcraft) {
            --pEntity.crafttimer;
        }
        if (pEntity.crafttimer <= 0) {
            pEntity.crafttimer = 20;
            pEntity.startcraft = false;
        }
        Soul_Breeder_Tile.m_155232_((Level)level, (BlockPos)pos, (BlockState)state);
        ModMessages.sendToClients(new SoulBreederStackSyncS2CPacket(pEntity.itemHandler, pEntity.f_58858_));
        if (Soul_Breeder_Tile.hasRecipe(pEntity) && !pEntity.startcraft) {
            ++pEntity.progress;
            pEntity.triggerAnim("controller", "craft");
            if (pEntity.progress >= pEntity.maxProgress) {
                pEntity.startcraft = true;
                Soul_Breeder_Tile.craftItem(pEntity);
            }
        }
        if (!Soul_Breeder_Tile.hasRecipe(pEntity) && !pEntity.startcraft) {
            pEntity.resetProgress();
            pEntity.triggerAnim("controller", "idle");
            Soul_Breeder_Tile.m_155232_((Level)level, (BlockPos)pos, (BlockState)state);
        }
        if (Soul_Breeder_Tile.hasRecipe(pEntity) && pEntity.startcraft) {
            pEntity.triggerAnim("controller", "finish");
        }
    }

    private void resetProgress() {
        this.progress = 0;
    }

    private static void craftItem(Soul_Breeder_Tile pEntity) {
        Level level = pEntity.f_58857_;
        SimpleContainer inventory = new SimpleContainer(pEntity.itemHandler.getSlots());
        for (int i = 0; i < pEntity.itemHandler.getSlots(); ++i) {
            inventory.m_6836_(i, pEntity.itemHandler.getStackInSlot(i));
        }
        Optional recipe = level.m_7465_().m_44015_((RecipeType)Soul_Breeder_Recipe.Type.INSTANCE, (Container)inventory, level);
        ItemStack MyChicken = ((Soul_Breeder_Recipe)recipe.get()).output.m_41720_().m_7968_();
        MyChicken.m_41764_(pEntity.itemHandler.getStackInSlot(2).m_41613_() + 1);
        if (Soul_Breeder_Tile.hasRecipe(pEntity)) {
            pEntity.itemHandler.extractItem(0, 1, false);
            pEntity.itemHandler.extractItem(1, 0, true);
            pEntity.itemHandler.setStackInSlot(2, MyChicken);
            pEntity.resetProgress();
        }
    }

    private static boolean hasRecipe(Soul_Breeder_Tile entity) {
        Level level = entity.f_58857_;
        SimpleContainer inventory = new SimpleContainer(entity.itemHandler.getSlots());
        for (int i = 0; i < entity.itemHandler.getSlots(); ++i) {
            inventory.m_6836_(i, entity.itemHandler.getStackInSlot(i));
        }
        Optional recipe = level.m_7465_().m_44015_((RecipeType)Soul_Breeder_Recipe.Type.INSTANCE, (Container)inventory, level);
        if (recipe.isPresent()) {
            entity.maxProgress = (Integer)Config.soulbreed_speedtimer.get() * ((Soul_Breeder_Recipe)recipe.get()).time;
        }
        return recipe.isPresent() && Soul_Breeder_Tile.canInsertAmountIntoOutputSlot(inventory) && Soul_Breeder_Tile.canInsertItemIntoOutputSlot(inventory, ((Soul_Breeder_Recipe)recipe.get()).output.m_41720_().m_7968_());
    }

    private static boolean canInsertItemIntoOutputSlot(SimpleContainer inventory, ItemStack stack) {
        return inventory.m_8020_(2).m_41720_() == stack.m_41720_() || inventory.m_8020_(2).m_41619_();
    }

    private static boolean canInsertAmountIntoOutputSlot(SimpleContainer inventory) {
        return inventory.m_8020_(2).m_41741_() > inventory.m_8020_(2).m_41613_();
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 0, this::predicate)});
    }

    private PlayState predicate(AnimationState<GeoAnimatable> state) {
        AnimationController controller = state.getController();
        controller.triggerableAnim("craft", CRAFTING);
        controller.triggerableAnim("idle", IDLE);
        controller.triggerableAnim("finish", FINISH);
        return PlayState.CONTINUE;
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }
}

