/*
 * Decompiled with CFR 0.152.
 */
package net.tarantel.chickenroost.entity;

import java.util.List;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;
import net.tarantel.chickenroost.entity.BaseChickenEntity;
import net.tarantel.chickenroost.item.ModItems;
import net.tarantel.chickenroost.util.ChickenConfig;
import net.tarantel.chickenroost.util.ChickenData;
import net.tarantel.chickenroost.util.GsonChickenReader;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class ModEntities {
    public static final DeferredRegister<EntityType<?>> REGISTRY = DeferredRegister.create((ResourceKey)Registries.f_256939_, (String)"chicken_roost");
    public static final RegistryObject<EntityType<BaseChickenEntity>> A_CHICKEN_LAVA = ModEntities.registerMonster("c_lava", BaseChickenEntity::new, 0.4f, 0.7f, 3154457, 0xACACAC);
    public static final RegistryObject<EntityType<BaseChickenEntity>> A_CHICKEN_WATER = ModEntities.registerMob("c_water", BaseChickenEntity::new, 0.4f, 0.7f, 3154457, 0xACACAC);

    private static <T extends Entity> RegistryObject<EntityType<T>> registerMob(String name, EntityType.EntityFactory<T> factory, float width, float height, int primaryColor, int secondaryColor) {
        return REGISTRY.register(name, () -> EntityType.Builder.m_20704_((EntityType.EntityFactory)factory, (MobCategory)MobCategory.CREATURE).m_20699_(0.4f, 0.7f).m_20702_(8).m_20712_(name));
    }

    private static <T extends Entity> RegistryObject<EntityType<T>> registerMonster(String name, EntityType.EntityFactory<T> factory, float width, float height, int primaryColor, int secondaryColor) {
        return REGISTRY.register(name, () -> EntityType.Builder.m_20704_((EntityType.EntityFactory)factory, (MobCategory)MobCategory.MONSTER).m_20699_(0.4f, 0.7f).m_20702_(8).m_20712_(name));
    }

    private static <T extends Entity> RegistryObject<EntityType<T>> registerMobFireImmun(String name, EntityType.EntityFactory<T> factory, float width, float height, int primaryColor, int secondaryColor) {
        return REGISTRY.register(name, () -> EntityType.Builder.m_20704_((EntityType.EntityFactory)factory, (MobCategory)MobCategory.CREATURE).m_20699_(0.4f, 0.7f).m_20702_(8).m_20719_().m_20712_(name));
    }

    private static <T extends Entity> RegistryObject<EntityType<T>> registerMonsterFireImmun(String name, EntityType.EntityFactory<T> factory, float width, float height, int primaryColor, int secondaryColor) {
        return REGISTRY.register(name, () -> EntityType.Builder.m_20704_((EntityType.EntityFactory)factory, (MobCategory)MobCategory.MONSTER).m_20699_(0.4f, 0.7f).m_20702_(8).m_20719_().m_20712_(name));
    }

    public static void readthis() {
        List<ChickenData> readItems = GsonChickenReader.readItemsFromFile();
        if (!readItems.isEmpty()) {
            for (ChickenData etherItem : readItems) {
                String id = etherItem.getId();
                String mobormonster = etherItem.getMobOrMonster();
                Boolean IS_FIRE = etherItem.getIsFire();
                ModEntities.extrachickens(id, mobormonster, IS_FIRE);
            }
        }
    }

    private static RegistryObject<EntityType<BaseChickenEntity>> extrachickens(String idd, String mobormonster, Boolean IS_FIRE) {
        if (mobormonster.equals("Mob")) {
            if (IS_FIRE.booleanValue()) {
                return ModEntities.registerMob(idd, BaseChickenEntity::new, 0.4f, 0.7f, 3154457, 0xACACAC);
            }
            return ModEntities.registerMobFireImmun(idd, BaseChickenEntity::new, 0.4f, 0.7f, 3154457, 0xACACAC);
        }
        if (IS_FIRE.booleanValue()) {
            return ModEntities.registerMonster(idd, BaseChickenEntity::new, 0.4f, 0.7f, 3154457, 0xACACAC);
        }
        return ModEntities.registerMonsterFireImmun(idd, BaseChickenEntity::new, 0.4f, 0.7f, 3154457, 0xACACAC);
    }

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> BaseChickenEntity.init());
    }

    public static void initChickenConfig() {
        ItemStack lavaegg = new ItemStack((ItemLike)ModItems.LAVA_EGG.get());
        ItemStack wateregg = new ItemStack((ItemLike)ModItems.WATER_EGG.get());
        CompoundTag fluidTagLava = new CompoundTag();
        CompoundTag fluidTagWater = new CompoundTag();
        fluidTagLava.m_128359_("FluidName", "minecraft:lava");
        fluidTagLava.m_128405_("Amount", 1000);
        fluidTagWater.m_128359_("FluidName", "minecraft:water");
        fluidTagWater.m_128405_("Amount", 1000);
        CompoundTag nbtDataLava = new CompoundTag();
        CompoundTag nbtDataWater = new CompoundTag();
        nbtDataLava.m_128365_("Fluid", (Tag)fluidTagLava);
        nbtDataWater.m_128365_("Fluid", (Tag)fluidTagWater);
        lavaegg.m_41751_(nbtDataLava);
        wateregg.m_41751_(nbtDataWater);
        List<ChickenData> readItems = GsonChickenReader.readItemsFromFile();
        if (!readItems.isEmpty()) {
            for (ChickenData etherItem : readItems) {
                String id = etherItem.getId();
                String dropitem = etherItem.getDropitem();
                int eggtime = etherItem.getEggtime();
                boolean IS_FIRE = etherItem.getIsFire();
                boolean IS_PROJECTILE = etherItem.getIsProjectile();
                boolean IS_EXPLOSION = etherItem.getIsExplosion();
                boolean IS_FALL = etherItem.getIsFall();
                boolean IS_DROWNING = etherItem.getIsDrowning();
                boolean IS_FREEZING = etherItem.getIsFreezing();
                boolean IS_LIGHTNING = etherItem.getIsLightning();
                boolean IS_WITHER = etherItem.getIsWither();
                ResourceLocation resourceLocation = new ResourceLocation("chicken_roost", id);
                EntityType entityType = EntityType.m_20632_((String)resourceLocation.toString()).orElse(EntityType.f_20555_);
                ChickenConfig.setDropStack(entityType, new ItemStack((ItemLike)ForgeRegistries.ITEMS.getValue(new ResourceLocation(dropitem))));
                ChickenConfig.setEggTime(entityType, eggtime);
                ChickenConfig.setIsFire(entityType, IS_FIRE);
                ChickenConfig.setIsProjectile(entityType, IS_PROJECTILE);
                ChickenConfig.setIsExplosion(entityType, IS_EXPLOSION);
                ChickenConfig.setIsFall(entityType, IS_FALL);
                ChickenConfig.setIsDrowning(entityType, IS_DROWNING);
                ChickenConfig.setIsFreezing(entityType, IS_FREEZING);
                ChickenConfig.setIsLightning(entityType, IS_LIGHTNING);
                ChickenConfig.setIsWither(entityType, IS_WITHER);
            }
        }
        ChickenConfig.setDropStack((EntityType)A_CHICKEN_LAVA.get(), lavaegg);
        ChickenConfig.setEggTime((EntityType)A_CHICKEN_LAVA.get(), 600);
        ChickenConfig.setDropStack((EntityType)A_CHICKEN_WATER.get(), wateregg);
        ChickenConfig.setEggTime((EntityType)A_CHICKEN_WATER.get(), 600);
    }

    @SubscribeEvent
    public static void registerAttributes(EntityAttributeCreationEvent event) {
        List<ChickenData> readItems = GsonChickenReader.readItemsFromFile();
        if (!readItems.isEmpty()) {
            for (ChickenData etherItem : readItems) {
                String id = etherItem.getId();
                ResourceLocation resourceLocation = new ResourceLocation("chicken_roost", id);
                EntityType entityType = EntityType.m_20632_((String)resourceLocation.toString()).orElse(EntityType.f_20555_);
                event.put(entityType, BaseChickenEntity.m_28263_().m_22265_());
            }
        }
        event.put((EntityType)A_CHICKEN_LAVA.get(), BaseChickenEntity.m_28263_().m_22265_());
        event.put((EntityType)A_CHICKEN_WATER.get(), BaseChickenEntity.m_28263_().m_22265_());
    }

    public static void register(IEventBus eventBus) {
        ModEntities.readthis();
        REGISTRY.register(eventBus);
    }
}

