/*
 * Decompiled with CFR 0.152.
 */
package net.tarantel.chickenroost.recipes;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.tarantel.chickenroost.recipes.ModRecipes;

public class Soul_Breeder_Recipe
implements Recipe<SimpleContainer> {
    public final ResourceLocation recipeId;
    public final ItemStack output;
    public final Ingredient ingredient0;
    public final Ingredient ingredient1;
    public final int time;

    public Soul_Breeder_Recipe(ResourceLocation recipeId, ItemStack output, Ingredient ingredient0, Ingredient ingredient1, int time) {
        this.recipeId = recipeId;
        this.output = output;
        this.ingredient0 = ingredient0;
        this.ingredient1 = ingredient1;
        this.time = time;
    }

    public ItemStack assemble(SimpleContainer container, RegistryAccess registryAccess) {
        return this.output.m_41777_();
    }

    public ResourceLocation m_6423_() {
        return this.recipeId;
    }

    public ItemStack m_8043_(RegistryAccess registryAccess) {
        return this.output.m_41777_();
    }

    public boolean matches(SimpleContainer container, Level level) {
        if (level.m_5776_()) {
            return false;
        }
        return this.ingredient0.test(container.m_8020_(0)) && this.ingredient1.test(container.m_8020_(1));
    }

    public boolean m_5598_() {
        return true;
    }

    public NonNullList<Ingredient> m_7527_() {
        NonNullList ingredients = NonNullList.m_182647_((int)2);
        ingredients.add(0, (Object)this.ingredient0);
        ingredients.add(1, (Object)this.ingredient1);
        return ingredients;
    }

    public boolean m_8004_(int width, int height) {
        return true;
    }

    public String m_6076_() {
        return "soul_breeding";
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ModRecipes.SOUL_BREEDING_SERIALIZER.get();
    }

    public RecipeType<?> m_6671_() {
        return (RecipeType)ModRecipes.SOUL_BREEDING_TYPE.get();
    }

    public static final class Serializer
    implements RecipeSerializer<Soul_Breeder_Recipe> {
        public static final Serializer INSTANCE = new Serializer();
        public static final ResourceLocation ID = new ResourceLocation("chicken_roost", "soul_breeding");

        private Serializer() {
        }

        public Soul_Breeder_Recipe fromJson(ResourceLocation recipeId, JsonObject json) {
            ItemStack output = CraftingHelper.getItemStack((JsonObject)json.getAsJsonObject("output"), (boolean)true);
            Ingredient ingredient0 = Ingredient.m_43917_((JsonElement)json.getAsJsonObject("soul"));
            Ingredient ingredient1 = Ingredient.m_43917_((JsonElement)json.getAsJsonObject("chicken"));
            int time = !json.has("time") ? 20 : json.get("time").getAsInt();
            return new Soul_Breeder_Recipe(recipeId, output, ingredient0, ingredient1, time);
        }

        public Soul_Breeder_Recipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            Ingredient input0 = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            Ingredient input1 = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            ItemStack output = buffer.m_130267_();
            int time = buffer.m_130242_();
            return new Soul_Breeder_Recipe(recipeId, output, input0, input1, time);
        }

        public void toNetwork(FriendlyByteBuf buffer, Soul_Breeder_Recipe recipe) {
            recipe.ingredient0.m_43923_(buffer);
            recipe.ingredient1.m_43923_(buffer);
            buffer.m_130055_(recipe.output);
            buffer.m_130130_(recipe.time);
        }
    }

    public static final class Type
    implements RecipeType<Soul_Breeder_Recipe> {
        public static final Type INSTANCE = new Type();
        public static final String ID = "soul_breeding";

        private Type() {
        }
    }
}

