/*
 * Decompiled with CFR 0.152.
 */
package net.tarantel.chickenroost.api.emi;

import dev.emi.emi.api.EmiEntrypoint;
import dev.emi.emi.api.EmiPlugin;
import dev.emi.emi.api.EmiRegistry;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.render.EmiRenderable;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import net.tarantel.chickenroost.api.emi.EmiBreederRecipe;
import net.tarantel.chickenroost.api.emi.EmiEggRecipe;
import net.tarantel.chickenroost.api.emi.EmiRoostRecipe;
import net.tarantel.chickenroost.api.emi.EmiSoulBreederRecipe;
import net.tarantel.chickenroost.api.emi.EmiSoulExtractorRecipe;
import net.tarantel.chickenroost.api.emi.EmiTrainerRecipe;
import net.tarantel.chickenroost.block.blocks.ModBlocks;
import net.tarantel.chickenroost.item.ModItems;
import net.tarantel.chickenroost.recipes.BreederRecipe;
import net.tarantel.chickenroost.recipes.ModRecipes;
import net.tarantel.chickenroost.recipes.RoostRecipe;
import net.tarantel.chickenroost.recipes.SoulBreederRecipe;
import net.tarantel.chickenroost.recipes.SoulExtractorRecipe;
import net.tarantel.chickenroost.recipes.ThrowEggRecipe;
import net.tarantel.chickenroost.recipes.TrainerRecipe;

@EmiEntrypoint
public class EmiRoostPlugin
implements EmiPlugin {
    public static final EmiStack EGG_WORKSTATION = EmiStack.of(ModItems.CHICKEN_STICK);
    public static final EmiStack BREEDER_WORKSTATION = EmiStack.of(ModBlocks.BREEDER);
    public static final EmiStack ROOST_WORKSTATION = EmiStack.of(ModBlocks.ROOST);
    public static final EmiStack TRAINER_WORKSTATION = EmiStack.of(ModBlocks.TRAINER);
    public static final EmiStack SOUL_EXTRACTOR_WORKSTATION = EmiStack.of(ModBlocks.SOUL_EXTRACTOR);
    public static final EmiStack SOUL_BREEDER_WORKSTATION = EmiStack.of(ModBlocks.SOUL_BREEDER);
    public static final EmiRecipeCategory EGG_CATEGORY = new EmiRecipeCategory(EGG_WORKSTATION.getId(), (EmiRenderable)EGG_WORKSTATION);
    public static final EmiRecipeCategory BREEDER_CATEGORY = new EmiRecipeCategory(BREEDER_WORKSTATION.getId(), (EmiRenderable)BREEDER_WORKSTATION);
    public static final EmiRecipeCategory ROOST_CATEGORY = new EmiRecipeCategory(ROOST_WORKSTATION.getId(), (EmiRenderable)ROOST_WORKSTATION);
    public static final EmiRecipeCategory TRAINER_CATEGORY = new EmiRecipeCategory(TRAINER_WORKSTATION.getId(), (EmiRenderable)TRAINER_WORKSTATION);
    public static final EmiRecipeCategory SOUL_EXTRACTOR_CATEGORY = new EmiRecipeCategory(SOUL_EXTRACTOR_WORKSTATION.getId(), (EmiRenderable)SOUL_EXTRACTOR_WORKSTATION);
    public static final EmiRecipeCategory SOUL_BREEDER_CATEGORY = new EmiRecipeCategory(SOUL_BREEDER_WORKSTATION.getId(), (EmiRenderable)SOUL_BREEDER_WORKSTATION);

    public void register(EmiRegistry registry) {
        registry.addCategory(EGG_CATEGORY);
        registry.addCategory(BREEDER_CATEGORY);
        registry.addCategory(ROOST_CATEGORY);
        registry.addCategory(TRAINER_CATEGORY);
        registry.addCategory(SOUL_EXTRACTOR_CATEGORY);
        registry.addCategory(SOUL_BREEDER_CATEGORY);
        registry.addWorkstation(EGG_CATEGORY, (EmiIngredient)EGG_WORKSTATION);
        registry.addWorkstation(BREEDER_CATEGORY, (EmiIngredient)BREEDER_WORKSTATION);
        registry.addWorkstation(ROOST_CATEGORY, (EmiIngredient)ROOST_WORKSTATION);
        registry.addWorkstation(TRAINER_CATEGORY, (EmiIngredient)TRAINER_WORKSTATION);
        registry.addWorkstation(SOUL_EXTRACTOR_CATEGORY, (EmiIngredient)SOUL_EXTRACTOR_WORKSTATION);
        registry.addWorkstation(SOUL_BREEDER_CATEGORY, (EmiIngredient)SOUL_BREEDER_WORKSTATION);
        RecipeManager manager = registry.getRecipeManager();
        for (RecipeHolder egg : manager.getAllRecipesFor(ModRecipes.THROW_EGG_TYPE.get())) {
            registry.addRecipe((EmiRecipe)new EmiEggRecipe((ThrowEggRecipe)egg.value()));
        }
        for (RecipeHolder breeder : manager.getAllRecipesFor(ModRecipes.BASIC_BREEDING_TYPE.get())) {
            registry.addRecipe((EmiRecipe)new EmiBreederRecipe((BreederRecipe)breeder.value()));
        }
        for (RecipeHolder roost : manager.getAllRecipesFor(ModRecipes.ROOST_TYPE.get())) {
            registry.addRecipe((EmiRecipe)new EmiRoostRecipe((RoostRecipe)roost.value()));
        }
        for (RecipeHolder trainer : manager.getAllRecipesFor(ModRecipes.TRAINER_TYPE.get())) {
            registry.addRecipe((EmiRecipe)new EmiTrainerRecipe((TrainerRecipe)trainer.value()));
        }
        for (RecipeHolder soul : manager.getAllRecipesFor(ModRecipes.SOUL_EXTRACTION_TYPE.get())) {
            registry.addRecipe((EmiRecipe)new EmiSoulExtractorRecipe((SoulExtractorRecipe)soul.value()));
        }
        for (RecipeHolder soulbreed : manager.getAllRecipesFor(ModRecipes.SOUL_BREEDING_TYPE.get())) {
            registry.addRecipe((EmiRecipe)new EmiSoulBreederRecipe((SoulBreederRecipe)soulbreed.value()));
        }
    }
}

