/*
 * Decompiled with CFR 0.152.
 */
package net.tarantel.chickenroost.api.jade.components;

import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec2;
import net.tarantel.chickenroost.api.jade.JadePlugin;
import net.tarantel.chickenroost.block.tile.SoulBreederTile;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.IServerDataProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.JadeIds;
import snownee.jade.api.config.IPluginConfig;
import snownee.jade.api.ui.IElement;
import snownee.jade.api.ui.IElementHelper;

public enum SoulBreederComponentProvider implements IBlockComponentProvider,
IServerDataProvider<BlockAccessor>
{
    INSTANCE;


    public void appendTooltip(ITooltip tooltip, BlockAccessor accessor, IPluginConfig config) {
        CompoundTag data = accessor.getServerData();
        BlockEntity blockEntity = accessor.getBlockEntity();
        if (blockEntity instanceof SoulBreederTile) {
            SoulBreederTile breederBlockEntity = (SoulBreederTile)blockEntity;
            BlockState breederBlockState = breederBlockEntity.getBlockState();
            if (breederBlockState == null) {
                return;
            }
            int progress = data.getInt("progress");
            ListTag furnaceItems = data.getList("furnace", 10);
            NonNullList inventory = NonNullList.withSize((int)3, (Object)ItemStack.EMPTY);
            for (int i = 0; i < furnaceItems.size(); ++i) {
                inventory.set(i, (Object)ItemStack.parseOptional((HolderLookup.Provider)accessor.getLevel().registryAccess(), (CompoundTag)furnaceItems.getCompound(i)));
            }
            int total = data.getInt("total");
            IElementHelper helper = IElementHelper.get();
            IElementHelper helper2 = IElementHelper.get();
            tooltip.add(helper.item((ItemStack)inventory.get(0)).align(IElement.Align.LEFT));
            tooltip.append(helper.item((ItemStack)inventory.get(1)).align(IElement.Align.LEFT));
            tooltip.append(helper.spacer(4, 0).align(IElement.Align.LEFT));
            tooltip.append(helper.progress((float)progress / (float)total).translate(new Vec2(-2.0f, 0.0f)).align(IElement.Align.LEFT));
            tooltip.append(helper.item((ItemStack)inventory.get(2)).align(IElement.Align.LEFT));
            tooltip.add(helper2.text((Component)Component.literal((String)"\u00a7o\u00a71Roost Ultimate")).align(IElement.Align.LEFT));
            tooltip.remove(JadeIds.UNIVERSAL_ITEM_STORAGE);
            tooltip.remove(JadeIds.CORE_MOD_NAME);
            tooltip.remove(JadeIds.UNIVERSAL_ITEM_STORAGE_ITEMS_PER_LINE);
        }
    }

    public int getDefaultPriority() {
        return 10000;
    }

    public void appendServerData(CompoundTag data, BlockAccessor accessor) {
        SoulBreederTile breeder = (SoulBreederTile)accessor.getBlockEntity();
        if (breeder instanceof SoulBreederTile) {
            SoulBreederTile furnace = breeder;
            ListTag items = new ListTag();
            for (int i = 0; i < 3; ++i) {
                items.add((Object)furnace.itemHandler.getStackInSlot(i).saveOptional((HolderLookup.Provider)accessor.getLevel().registryAccess()));
            }
            data.put("furnace", (Tag)items);
            data.putInt("progress", breeder.progress);
            data.putInt("total", breeder.maxProgress);
        }
    }

    public ResourceLocation getUid() {
        return JadePlugin.SOULBREEDER_PROGRESS;
    }
}

