/*
 * Decompiled with CFR 0.152.
 */
package net.tarantel.chickenroost.block.tile;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemContainerContents;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.tarantel.chickenroost.block.blocks.ModBlocks;
import net.tarantel.chickenroost.block.blocks.RoostBlock;
import net.tarantel.chickenroost.block.tile.ModBlockEntities;
import net.tarantel.chickenroost.block.tile.RoostTile;
import net.tarantel.chickenroost.handler.CollectorHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CollectorTile
extends BlockEntity
implements MenuProvider {
    public final ItemStackHandler itemHandler = new ItemStackHandler(54){

        protected void onContentsChanged(int slot) {
            CollectorTile.this.setChanged();
            assert (CollectorTile.this.level != null);
            if (!((CollectorTile)CollectorTile.this).level.isClientSide) {
                CollectorTile.this.level.sendBlockUpdated(CollectorTile.this.getBlockPos(), CollectorTile.this.getBlockState(), CollectorTile.this.getBlockState(), 3);
            }
        }
    };
    private final Set<BlockPos> activeRoosts = new HashSet<BlockPos>();
    private int collectRange = 10;
    private int _roostValidationTicker = 0;

    public CollectorTile(BlockPos pos, BlockState state) {
        super(ModBlockEntities.COLLECTOR.get(), pos, state);
    }

    public Set<BlockPos> getActiveRoosts() {
        return Collections.unmodifiableSet(this.activeRoosts);
    }

    public void setRoostActive(BlockPos pos, boolean active) {
        if (active) {
            this.activeRoosts.add(pos);
        } else {
            this.activeRoosts.remove(pos);
        }
        this.setChanged();
        if (this.level != null && !this.level.isClientSide) {
            this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 3);
        }
    }

    public int getCollectRange() {
        return this.collectRange;
    }

    public void setCollectRange(int r) {
        int nr = Math.max(5, Math.min(30, r));
        if (nr != this.collectRange) {
            this.collectRange = nr;
            this.setChanged();
            if (this.level != null && !this.level.isClientSide) {
                this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 3);
            }
        }
    }

    private boolean isValidRoost(BlockPos pos) {
        if (this.level == null || pos == null) {
            return false;
        }
        BlockEntity be = this.level.getBlockEntity(pos);
        if (!(be instanceof RoostTile)) {
            return false;
        }
        BlockState state = this.level.getBlockState(pos);
        return state.getBlock() instanceof RoostBlock;
    }

    private void pruneMissingRoosts() {
        if (this.level == null || this.activeRoosts == null || this.activeRoosts.isEmpty()) {
            return;
        }
        this.activeRoosts.removeIf(pos -> !this.isValidRoost((BlockPos)pos));
    }

    private void maybePruneRoostsPeriodic() {
        if (++this._roostValidationTicker % 20 == 0) {
            this.pruneMissingRoosts();
        }
    }

    public void saveAdditional(CompoundTag nbt, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider lookup) {
        nbt.put("inventory", (Tag)this.itemHandler.serializeNBT(lookup));
        long[] arr = this.activeRoosts.stream().mapToLong(BlockPos::asLong).toArray();
        nbt.putLongArray("collector.roosts", arr);
        nbt.putInt("collector.range", this.collectRange);
        super.saveAdditional(nbt, lookup);
    }

    public void loadAdditional(@NotNull CompoundTag nbt, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider lookup) {
        long[] arr;
        super.loadAdditional(nbt, lookup);
        this.itemHandler.deserializeNBT(lookup, nbt.getCompound("inventory"));
        this.activeRoosts.clear();
        for (long l : arr = nbt.getLongArray("collector.roosts")) {
            this.activeRoosts.add(BlockPos.of((long)l));
        }
        this.collectRange = Math.max(5, Math.min(30, nbt.getInt("collector.range")));
        this.pruneMissingRoosts();
    }

    private static void moveOneStack(IItemHandler from, IItemHandler to) {
        ItemStack stack = from.getStackInSlot(2);
        if (stack.isEmpty()) {
            return;
        }
        ItemStack moving = stack.copy();
        for (int i = 0; i < to.getSlots() && !moving.isEmpty(); ++i) {
            moving = to.insertItem(i, moving, false);
        }
        int moved = stack.getCount() - (moving.isEmpty() ? 0 : moving.getCount());
        if (moved > 0) {
            from.extractItem(2, moved, false);
        }
    }

    private static void collectFromActiveRoosts(Level level, CollectorTile self) {
        if (self.activeRoosts.isEmpty()) {
            return;
        }
        int r = self.getCollectRange();
        int maxDist2 = r * r;
        for (BlockPos rpos : new HashSet<BlockPos>(self.activeRoosts)) {
            IItemHandler roostInv;
            BlockEntity be;
            if (rpos.distSqr((Vec3i)self.getBlockPos()) > (double)(maxDist2 * 3) || !((be = level.getBlockEntity(rpos)) instanceof RoostTile) || (roostInv = (IItemHandler)level.getCapability(Capabilities.ItemHandler.BLOCK, rpos, (Object)null)) == null) continue;
            CollectorTile.moveOneStack(roostInv, (IItemHandler)self.itemHandler);
        }
    }

    @Nullable
    public IItemHandler getItemHandlerCapability(@Nullable Direction side) {
        return this.itemHandler;
    }

    public void drops() {
        SimpleContainer inventory = new SimpleContainer(this.itemHandler.getSlots());
        SimpleContainer block = new SimpleContainer(1);
        ItemStack itemStack = new ItemStack((ItemLike)ModBlocks.COLLECTOR.get());
        NonNullList items = inventory.getItems();
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            items.set(i, (Object)this.itemHandler.getStackInSlot(i));
        }
        itemStack.set(DataComponents.CONTAINER, (Object)ItemContainerContents.fromItems((List)inventory.getItems()));
        block.setItem(0, itemStack.copy());
        Containers.dropContents((Level)Objects.requireNonNull(this.level), (BlockPos)this.worldPosition, (Container)block);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, CollectorTile tile) {
        if (level.isClientSide()) {
            return;
        }
        tile.maybePruneRoostsPeriodic();
        CollectorTile.collectFromActiveRoosts(level, tile);
        CollectorTile.setChanged((Level)level, (BlockPos)pos, (BlockState)state);
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    @NotNull
    public CompoundTag getUpdateTag(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider prov) {
        return this.saveWithFullMetadata(prov);
    }

    @NotNull
    public Component getDisplayName() {
        return Component.translatable((String)"block.chicken_roost.collector");
    }

    @Nullable
    public AbstractContainerMenu createMenu(int id, @NotNull Inventory inv, @NotNull Player player) {
        return new CollectorHandler(id, inv, this);
    }
}

