/*
 * Decompiled with CFR 0.152.
 */
package net.tarantel.chickenroost.handler;

import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.common.extensions.IMenuTypeExtension;
import net.neoforged.neoforge.network.IContainerFactory;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.tarantel.chickenroost.handler.BreederHandler;
import net.tarantel.chickenroost.handler.CollectorHandler;
import net.tarantel.chickenroost.handler.FeederHandler;
import net.tarantel.chickenroost.handler.RoostHandler;
import net.tarantel.chickenroost.handler.SoulBreederHandler;
import net.tarantel.chickenroost.handler.SoulExtractorHandler;
import net.tarantel.chickenroost.handler.TrainerHandler;

public class ModHandlers {
    public static final DeferredRegister<MenuType<?>> MENU_TYPES = DeferredRegister.create((ResourceKey)Registries.MENU, (String)"chicken_roost");
    public static final Supplier<MenuType<SoulBreederHandler>> SOUL_BREEDER_MENU = ModHandlers.registerMenuType(SoulBreederHandler::new, "new_soul_breeder_menu");
    public static final Supplier<MenuType<BreederHandler>> BREEDER_MENU = ModHandlers.registerMenuType(BreederHandler::new, "breeder_menu");
    public static final Supplier<MenuType<SoulExtractorHandler>> SOUL_EXTRACTOR_MENU = ModHandlers.registerMenuType(SoulExtractorHandler::new, "soul_extractor_menu");
    public static final Supplier<MenuType<RoostHandler>> ROOST_MENU_V1 = ModHandlers.registerMenuType(RoostHandler::new, "roost_menu_v1");
    public static final Supplier<MenuType<TrainerHandler>> TRAINER = ModHandlers.registerMenuType(TrainerHandler::new, "trainer");
    public static final Supplier<MenuType<CollectorHandler>> COLLECTOR_MENU = ModHandlers.registerMenuType(CollectorHandler::new, "collector_menu");
    public static final Supplier<MenuType<FeederHandler>> FEEDER_MENU = ModHandlers.registerMenuType(FeederHandler::new, "feeder_menu");

    private static <T extends AbstractContainerMenu> Supplier<MenuType<T>> registerMenuType(IContainerFactory<T> factory, String name) {
        return MENU_TYPES.register(name, () -> IMenuTypeExtension.create((IContainerFactory)factory));
    }

    public static void register(IEventBus eventBus) {
        MENU_TYPES.register(eventBus);
    }
}

