/*
 * Decompiled with CFR 0.152.
 */
package net.tarantel.chickenroost.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.neoforged.neoforge.network.PacketDistributor;
import net.tarantel.chickenroost.ChickenRoostMod;
import net.tarantel.chickenroost.handler.RoostHandler;
import net.tarantel.chickenroost.networking.SetRoostNamePayload;
import org.jetbrains.annotations.NotNull;

public class RoostScreen
extends AbstractContainerScreen<RoostHandler> {
    private EditBox nameField;
    private String enteredName = "ROOST";
    private Button nameButton;
    private static final ResourceLocation GUI = ChickenRoostMod.ownresource("textures/screens/roostgui.png");
    private static final ResourceLocation ARROW = ChickenRoostMod.ownresource("textures/screens/newarrow.png");

    public RoostScreen(RoostHandler menu, Inventory inventory, Component component) {
        super((AbstractContainerMenu)menu, inventory, component);
        this.imageWidth = 176;
        this.imageHeight = 166;
    }

    protected void init() {
        super.init();
        int x = this.leftPos;
        int y = this.topPos - 17;
        int nameBtnX = this.leftPos + 20 + 2;
        int nameBtnY = this.topPos - 17;
        this.nameButton = Button.builder((Component)Component.literal((String)"Name"), btn -> {
            int fieldX = nameBtnX + 40 + 2;
            int fieldY = this.topPos - 21;
            if (this.nameField == null) {
                this.nameField = new EditBox(this.font, fieldX, fieldY, 60, 20, (Component)Component.literal((String)"Name").withColor(0xFFFFFF));
                this.nameField.setMaxLength(32);
                String currentname = ((RoostHandler)this.menu).blockEntity.getCustomName();
                this.nameField.setValue(currentname);
                this.nameField.setFocused(true);
                this.addRenderableWidget((GuiEventListener)this.nameField);
            } else {
                this.nameField.setFocused(true);
            }
        }).pos(nameBtnX, nameBtnY).size(40, 13).build();
        this.nameButton.setTooltip(Tooltip.create((Component)Component.literal((String)"Set Name")));
        this.addRenderableWidget((GuiEventListener)this.nameButton);
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (this.nameField != null && this.nameField.isFocused()) {
            if (keyCode == 256) {
                return super.keyPressed(keyCode, scanCode, modifiers);
            }
            if (keyCode == 257 || keyCode == 257 || keyCode == 335) {
                this.enteredName = this.nameField.getValue().trim();
                if (!this.enteredName.isEmpty()) {
                    PacketDistributor.sendToServer((CustomPacketPayload)new SetRoostNamePayload(((RoostHandler)this.menu).getBlockEntity().getBlockPos(), this.enteredName), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
                this.nameField.setFocused(false);
                return true;
            }
            if (this.nameField.keyPressed(keyCode, scanCode, modifiers)) {
                return true;
            }
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    public boolean charTyped(char codePoint, int modifiers) {
        if (this.nameField != null && this.nameField.isFocused()) {
            if (this.nameField.charTyped(codePoint, modifiers)) {
                return true;
            }
            return true;
        }
        return super.charTyped(codePoint, modifiers);
    }

    protected void renderBg(@NotNull GuiGraphics ms, float partialTicks, int gx, int gy) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)GUI);
        ms.blit(GUI, this.leftPos, this.topPos, 0.0f, 0.0f, this.imageWidth, this.imageHeight, this.imageWidth, this.imageHeight);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        ms.blit(ARROW, this.leftPos + 63, this.topPos + 11, 0.0f, 0.0f, ((RoostHandler)this.menu).getScaledProgress(), 33, 54, 33);
        RenderSystem.disableBlend();
    }

    public void render(@NotNull GuiGraphics ms, int mouseX, int mouseY, float partialTicks) {
        this.renderBackground(ms, mouseX, mouseY, partialTicks);
        super.render(ms, mouseX, mouseY, partialTicks);
        this.renderTooltip(ms, mouseX, mouseY);
    }

    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
    }
}

